/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper.recyclerviewitemhelper;

import android.graphics.Canvas;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.helper.recyclerviewitemhelper.ItemTouchHelperAdapter;
import com.ypx.imagepicker.helper.recyclerviewitemhelper.ItemTouchHelperViewHolder;

public class SimpleItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    public static final float ALPHA_FULL = 1.0f;
    private boolean moveFreely = false;
    private boolean lastActive = false;
    private float moveScaleFactor = 1.1f;
    private final ItemTouchHelperAdapter mAdapter;
    private OnSelectChangedListener mOnSelectChangedListener;

    public SimpleItemTouchHelperCallback(ItemTouchHelperAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void setOnSelectChangedListener(OnSelectChangedListener mOnSelectChangedListener) {
        this.mOnSelectChangedListener = mOnSelectChangedListener;
    }

    public void setMoveScaleFactor(float moveScaleFactor) {
        this.moveScaleFactor = moveScaleFactor;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.mAdapter.isItemViewSwipeEnabled();
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (this.moveFreely) {
            int dragFlags = 15;
            boolean swipeFlags = false;
            return SimpleItemTouchHelperCallback.makeMovementFlags((int)15, (int)0);
        }
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int dragFlags = 15;
            boolean swipeFlags = false;
            return SimpleItemTouchHelperCallback.makeMovementFlags((int)15, (int)0);
        }
        if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager linear = (LinearLayoutManager)recyclerView.getLayoutManager();
            if (linear.getOrientation() == 0) {
                int dragFlags = 12;
                boolean swipeFlags = false;
                return SimpleItemTouchHelperCallback.makeMovementFlags((int)12, (int)0);
            }
            int dragFlags = 3;
            boolean swipeFlags = false;
            return SimpleItemTouchHelperCallback.makeMovementFlags((int)3, (int)0);
        }
        int dragFlags = 3;
        boolean swipeFlags = false;
        return SimpleItemTouchHelperCallback.makeMovementFlags((int)3, (int)0);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        if (source.getItemViewType() != target.getItemViewType()) {
            return false;
        }
        this.mAdapter.onItemMove(source.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public void onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, int fromPos, RecyclerView.ViewHolder target, int toPos, int x, int y) {
        super.onMoved(recyclerView, viewHolder, fromPos, target, toPos, x, y);
        viewHolder.itemView.setAlpha(1.0f);
        target.itemView.setAlpha(1.0f);
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int i) {
        this.mAdapter.onItemDismiss(viewHolder.getAdapterPosition());
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            float alpha = 1.0f - Math.abs(dX) / (float)viewHolder.itemView.getWidth();
            viewHolder.itemView.setAlpha(alpha);
            viewHolder.itemView.setTranslationX(dX);
        } else if (actionState == 2) {
            if (isCurrentlyActive) {
                viewHolder.itemView.setAlpha(0.5f);
                viewHolder.itemView.setScaleX(this.moveScaleFactor);
                viewHolder.itemView.setScaleY(this.moveScaleFactor);
            } else {
                viewHolder.itemView.setAlpha(1.0f);
                viewHolder.itemView.setScaleX(1.0f);
                viewHolder.itemView.setScaleY(1.0f);
            }
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
        if (null != this.mOnSelectChangedListener && !isCurrentlyActive && this.lastActive) {
            this.mOnSelectChangedListener.onSelectedChanged(viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
        this.lastActive = isCurrentlyActive;
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0 && viewHolder instanceof ItemTouchHelperViewHolder) {
            ItemTouchHelperViewHolder itemViewHolder = (ItemTouchHelperViewHolder)viewHolder;
            itemViewHolder.onItemSelected();
        }
        super.onSelectedChanged(viewHolder, actionState);
        if (null != this.mOnSelectChangedListener) {
            this.mOnSelectChangedListener.onSelectedChanged(viewHolder, actionState);
        }
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        viewHolder.itemView.setAlpha(1.0f);
        if (viewHolder instanceof ItemTouchHelperViewHolder) {
            ItemTouchHelperViewHolder itemViewHolder = (ItemTouchHelperViewHolder)viewHolder;
            itemViewHolder.onItemClear();
        }
    }

    public void setMoveFreely(boolean moveFreely) {
        this.moveFreely = moveFreely;
    }

    public static interface OnSelectChangedListener {
        public void onSelectedChanged(RecyclerView.ViewHolder var1, float var2, float var3, int var4, boolean var5);

        public void onSelectedChanged(RecyclerView.ViewHolder var1, int var2);
    }
}

