/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper.launcher;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.ypx.imagepicker.helper.launcher.PRouter;
import com.ypx.imagepicker.helper.launcher.PRouterV4;

public class PLauncher {
    private static final String TAG = "PLauncher";
    private Context mContext;
    private PRouterV4 mRouterFragmentV4;
    private PRouter mRouterFragment;

    public static PLauncher init(androidx.fragment.app.Fragment fragment) {
        return PLauncher.init(fragment.getActivity());
    }

    public static PLauncher init(FragmentActivity activity) {
        return new PLauncher(activity);
    }

    public static PLauncher init(Activity activity) {
        return new PLauncher(activity);
    }

    private PLauncher(FragmentActivity activity) {
        this.mContext = activity;
        this.mRouterFragmentV4 = this.getRouterFragmentV4(activity);
    }

    private PLauncher(Activity activity) {
        this.mContext = activity;
        this.mRouterFragment = this.getRouterFragment(activity);
    }

    private PRouterV4 getRouterFragmentV4(FragmentActivity activity) {
        PRouterV4 routerFragment = this.findRouterFragmentV4(activity);
        if (routerFragment == null) {
            routerFragment = PRouterV4.newInstance();
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            fragmentManager.beginTransaction().add((androidx.fragment.app.Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private PRouterV4 findRouterFragmentV4(FragmentActivity activity) {
        return (PRouterV4)activity.getSupportFragmentManager().findFragmentByTag(TAG);
    }

    private PRouter getRouterFragment(Activity activity) {
        PRouter routerFragment = this.findRouterFragment(activity);
        if (routerFragment == null) {
            routerFragment = PRouter.newInstance();
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private PRouter findRouterFragment(Activity activity) {
        return (PRouter)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void startActivityForResult(Class<?> clazz, Callback callback) {
        Intent intent = new Intent(this.mContext, clazz);
        this.startActivityForResult(intent, callback);
    }

    public void startActivityForResult(Intent intent, Callback callback) {
        if (this.mRouterFragmentV4 != null) {
            this.mRouterFragmentV4.startActivityForResult(intent, callback);
        } else if (this.mRouterFragment != null) {
            this.mRouterFragment.startActivityForResult(intent, callback);
        } else {
            throw new RuntimeException("please do init first!");
        }
    }

    public static interface Callback {
        public void onActivityResult(int var1, Intent var2);
    }
}

