/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper;

import android.content.Context;
import android.media.MediaPlayer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.VideoView;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.views.PickerUiConfig;

public class VideoViewContainerHelper {
    private VideoView videoView;
    private ImageView previewImg;
    private ImageView pauseImg;

    public void loadVideoView(ViewGroup parent, ImageItem imageItem, IPickerPresenter presenter, PickerUiConfig uiConfig) {
        Context context = parent.getContext();
        if (this.videoView == null) {
            this.videoView = new VideoView(context);
            this.videoView.setBackgroundColor(0);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.gravity = 17;
            this.videoView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.previewImg = new ImageView(context);
            this.previewImg.setLayoutParams((ViewGroup.LayoutParams)params);
            this.previewImg.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.pauseImg = new ImageView(context);
            this.pauseImg.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.pauseImg.setImageDrawable(context.getResources().getDrawable(uiConfig.getVideoPauseIconID()));
            FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
            params2.gravity = 17;
            this.pauseImg.setLayoutParams((ViewGroup.LayoutParams)params2);
        }
        this.pauseImg.setVisibility(8);
        parent.removeAllViews();
        parent.addView((View)this.videoView);
        parent.addView((View)this.previewImg);
        parent.addView((View)this.pauseImg);
        this.previewImg.setVisibility(0);
        presenter.displayImage((View)this.previewImg, imageItem, 0, false);
        this.videoView.setVideoPath(imageItem.path);
        this.videoView.start();
        this.videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mPlayer) {
                mPlayer.start();
                mPlayer.setLooping(true);
            }
        });
        this.videoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoViewContainerHelper.this.videoView.isPlaying()) {
                    VideoViewContainerHelper.this.onPause();
                } else {
                    VideoViewContainerHelper.this.onResume();
                }
            }
        });
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                    public void onSeekComplete(MediaPlayer mp) {
                        VideoViewContainerHelper.this.videoView.start();
                    }
                });
                mp.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mp, int what, int extra) {
                        if (what == 3) {
                            VideoViewContainerHelper.this.videoView.setBackgroundColor(0);
                            VideoViewContainerHelper.this.previewImg.setVisibility(8);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
    }

    public void onResume() {
        if (this.videoView != null && this.pauseImg != null) {
            this.videoView.start();
            this.videoView.seekTo(this.videoView.getCurrentPosition());
            this.pauseImg.setVisibility(8);
        }
    }

    public void onPause() {
        if (this.videoView != null && this.pauseImg != null) {
            this.videoView.pause();
            this.pauseImg.setVisibility(0);
        }
    }

    public void onDestroy() {
        if (this.videoView != null) {
            this.videoView.suspend();
        }
    }
}

