/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.widget.TouchRecyclerView;

public class RecyclerViewTouchHelper {
    private TouchRecyclerView recyclerView;
    private View topView;
    private View maskView;
    private boolean isScrollTopView = false;
    private boolean isTopViewStick = false;
    private int canScrollHeight;
    private int stickHeight;
    private int lastScrollY = 0;
    private int spanCount = 0;

    public static RecyclerViewTouchHelper create(TouchRecyclerView recyclerView) {
        return new RecyclerViewTouchHelper(recyclerView);
    }

    private RecyclerViewTouchHelper(TouchRecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public RecyclerViewTouchHelper setTopView(View topView) {
        this.topView = topView;
        return this;
    }

    public RecyclerViewTouchHelper setMaskView(View maskView) {
        this.maskView = maskView;
        return this;
    }

    public RecyclerViewTouchHelper setCanScrollHeight(int canScrollHeight) {
        this.canScrollHeight = canScrollHeight;
        return this;
    }

    public RecyclerViewTouchHelper setStickHeight(int stickHeight) {
        this.stickHeight = stickHeight;
        return this;
    }

    private void setRecyclerViewPaddingTop(int top) {
        this.recyclerView.setPadding(this.recyclerView.getPaddingStart(), top, this.recyclerView.getPaddingEnd(), this.recyclerView.getPaddingBottom());
    }

    public RecyclerViewTouchHelper build() {
        this.setRecyclerViewPaddingTop(this.canScrollHeight + this.stickHeight);
        this.recyclerView.post(new Runnable(){

            @Override
            public void run() {
                RecyclerViewTouchHelper.this.setRecyclerViewPaddingTop(RecyclerViewTouchHelper.this.topView.getHeight());
            }
        });
        this.recyclerView.setTouchView(this.topView);
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (RecyclerViewTouchHelper.this.isImageGridCantScroll()) {
                    return;
                }
                int scrollY = RecyclerViewTouchHelper.this.getScrollYDistance();
                if (RecyclerViewTouchHelper.this.isScrollTopView && RecyclerViewTouchHelper.this.topView.getTranslationY() != (float)(-RecyclerViewTouchHelper.this.canScrollHeight)) {
                    int distance;
                    if (RecyclerViewTouchHelper.this.lastScrollY == 0) {
                        RecyclerViewTouchHelper.this.lastScrollY = scrollY;
                    }
                    if ((distance = scrollY - RecyclerViewTouchHelper.this.lastScrollY) >= RecyclerViewTouchHelper.this.canScrollHeight) {
                        RecyclerViewTouchHelper.this.setMaskAlpha(1.0f);
                        RecyclerViewTouchHelper.this.topView.setTranslationY((float)(-RecyclerViewTouchHelper.this.canScrollHeight));
                        RecyclerViewTouchHelper.this.setRecyclerViewPaddingTop(RecyclerViewTouchHelper.this.stickHeight);
                    } else if (distance <= 0) {
                        RecyclerViewTouchHelper.this.setMaskAlpha(0.0f);
                        RecyclerViewTouchHelper.this.topView.setTranslationY(0.0f);
                    } else {
                        float ratio = (float)(-distance) * 1.0f / ((float)(-RecyclerViewTouchHelper.this.canScrollHeight) * 1.0f);
                        RecyclerViewTouchHelper.this.setMaskAlpha(ratio);
                        RecyclerViewTouchHelper.this.topView.setTranslationY((float)(-distance));
                    }
                    return;
                }
                if (RecyclerViewTouchHelper.this.isTopViewFullShow()) {
                    RecyclerViewTouchHelper.this.isTopViewStick = false;
                    RecyclerViewTouchHelper.this.setMaskAlpha(0.0f);
                }
                if (RecyclerViewTouchHelper.this.isTopViewStick) {
                    int translate = -scrollY - RecyclerViewTouchHelper.this.topView.getHeight();
                    if (translate <= -RecyclerViewTouchHelper.this.canScrollHeight) {
                        RecyclerViewTouchHelper.this.topView.setTranslationY((float)(-RecyclerViewTouchHelper.this.canScrollHeight));
                        RecyclerViewTouchHelper.this.setRecyclerViewPaddingTop(RecyclerViewTouchHelper.this.stickHeight);
                        RecyclerViewTouchHelper.this.isTopViewStick = false;
                    } else {
                        if (translate >= -20) {
                            translate = 0;
                        }
                        RecyclerViewTouchHelper.this.topView.setTranslationY((float)translate);
                        float ratio = RecyclerViewTouchHelper.this.topView.getTranslationY() * 1.0f / ((float)(-RecyclerViewTouchHelper.this.topView.getHeight()) * 1.0f);
                        RecyclerViewTouchHelper.this.setMaskAlpha(ratio);
                    }
                }
            }
        });
        this.recyclerView.setDragScrollListener(new TouchRecyclerView.onDragScrollListener(){

            @Override
            public void onScrollOverTop(int distance) {
                if (RecyclerViewTouchHelper.this.isImageGridCantScroll()) {
                    return;
                }
                RecyclerViewTouchHelper.this.isScrollTopView = true;
            }

            @Override
            public void onScrollDown(int distance) {
                if (RecyclerViewTouchHelper.this.isImageGridCantScroll()) {
                    return;
                }
                if (RecyclerViewTouchHelper.this.isRecyclerViewScrollToTop() && !RecyclerViewTouchHelper.this.isScrollTopView) {
                    RecyclerViewTouchHelper.this.setRecyclerViewPaddingTop(RecyclerViewTouchHelper.this.topView.getHeight());
                    RecyclerViewTouchHelper.this.isTopViewStick = true;
                }
            }

            @Override
            public void onScrollUp() {
                RecyclerViewTouchHelper.this.lastScrollY = 0;
                if (RecyclerViewTouchHelper.this.isImageGridCantScroll()) {
                    return;
                }
                if (RecyclerViewTouchHelper.this.isScrollTopView) {
                    RecyclerViewTouchHelper.this.transitTopWithAnim(!RecyclerViewTouchHelper.this.isRecyclerViewCanScrollOverScreen(), -1, true);
                } else if (RecyclerViewTouchHelper.this.isTopViewStick && !RecyclerViewTouchHelper.this.isTopViewFullShow()) {
                    RecyclerViewTouchHelper.this.reset();
                }
                RecyclerViewTouchHelper.this.isScrollTopView = false;
            }
        });
        return this;
    }

    private boolean isRecyclerViewScrollToTop() {
        return !this.recyclerView.canScrollVertically(-1);
    }

    private boolean isRecyclerViewScrollToBottom() {
        return !this.recyclerView.canScrollVertically(1);
    }

    private boolean isRecyclerViewCanScrollOverScreen() {
        if (this.isImageGridCantScroll()) {
            return false;
        }
        int count = 0;
        if (this.recyclerView.getAdapter() != null) {
            count = this.recyclerView.getAdapter().getItemCount();
        }
        int itemHeight = this.getItemHeight();
        if (count < this.getSpanCount()) {
            return false;
        }
        int lineCount = count % this.getSpanCount() == 0 ? count / this.getSpanCount() : count / this.getSpanCount() + 1;
        return lineCount * itemHeight + this.recyclerView.getPaddingBottom() > PViewSizeUtils.getScreenHeight(this.recyclerView.getContext()) - this.stickHeight;
    }

    private int getSpanCount() {
        if (this.spanCount != 0) {
            return this.spanCount;
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)this.recyclerView.getLayoutManager();
        if (gridLayoutManager != null) {
            this.spanCount = gridLayoutManager.getSpanCount();
            return this.spanCount;
        }
        return 0;
    }

    private void setMaskAlpha(float ratio) {
        this.maskView.setVisibility(0);
        if (ratio <= 0.0f) {
            ratio = 0.0f;
            this.maskView.setVisibility(8);
        } else if (ratio >= 1.0f) {
            ratio = 1.0f;
        }
        this.maskView.setAlpha(ratio);
    }

    private boolean isTopViewFullShow() {
        return this.topView.getTranslationY() == 0.0f;
    }

    private boolean isImageGridCantScroll() {
        return !this.recyclerView.canScrollVertically(1) && !this.recyclerView.canScrollVertically(-1);
    }

    private int getScrollYDistance() {
        View firstVisibleChildView;
        if (!(this.recyclerView.getLayoutManager() instanceof GridLayoutManager)) {
            return 0;
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)this.recyclerView.getLayoutManager();
        int position = gridLayoutManager.findFirstVisibleItemPosition();
        if (position < 0) {
            position = 0;
        }
        if ((firstVisibleChildView = gridLayoutManager.findViewByPosition(position)) == null) {
            return 0;
        }
        int itemHeight = firstVisibleChildView.getHeight() + PViewSizeUtils.dp(this.recyclerView.getContext(), 2.0f);
        return position / this.getSpanCount() * itemHeight - firstVisibleChildView.getTop();
    }

    private int getItemHeight() {
        View firstVisibleChildView;
        if (!(this.recyclerView.getLayoutManager() instanceof GridLayoutManager)) {
            return 0;
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)this.recyclerView.getLayoutManager();
        int position = gridLayoutManager.findFirstVisibleItemPosition();
        if (position < 0) {
            position = 0;
        }
        if ((firstVisibleChildView = gridLayoutManager.findViewByPosition(position)) == null) {
            return 0;
        }
        return firstVisibleChildView.getHeight();
    }

    private void reset() {
        final int scrollY = this.getScrollYDistance();
        if (scrollY == 0) {
            return;
        }
        ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        anim2.setDuration(500L);
        anim2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                RecyclerViewTouchHelper.this.recyclerView.scrollBy(0, (int)((float)scrollY * ratio));
            }
        });
        anim2.start();
    }

    public void transitTopWithAnim(boolean isFocusShow, final int scrollToPosition, boolean isShowTransit) {
        if (!isShowTransit) {
            return;
        }
        if (this.isTopViewFullShow()) {
            return;
        }
        final int startTop = (int)this.topView.getTranslationY();
        final int endTop = isFocusShow || startTop > -this.stickHeight / 2 ? 0 : -this.canScrollHeight;
        final int startPadding = this.recyclerView.getPaddingTop();
        final float startAlpha = this.maskView.getAlpha();
        ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        anim2.setDuration(300L);
        anim2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                int dis = (int)((float)(endTop - startTop) * ratio + (float)startTop);
                RecyclerViewTouchHelper.this.topView.setTranslationY((float)dis);
                float maskAlpha = endTop == 0 ? -startAlpha * ratio + startAlpha : (1.0f - startAlpha) * ratio + startAlpha;
                RecyclerViewTouchHelper.this.setMaskAlpha(maskAlpha);
                int padding = (int)((float)((endTop == 0 ? RecyclerViewTouchHelper.this.topView.getHeight() : RecyclerViewTouchHelper.this.stickHeight) - startPadding) * ratio + (float)startPadding);
                RecyclerViewTouchHelper.this.setRecyclerViewPaddingTop(padding);
                if (ratio == 1.0f) {
                    if (scrollToPosition == 0) {
                        RecyclerViewTouchHelper.this.recyclerView.scrollToPosition(0);
                    } else if (scrollToPosition != -1) {
                        RecyclerViewTouchHelper.this.recyclerView.smoothScrollToPosition(scrollToPosition);
                    }
                }
            }
        });
        anim2.start();
    }

    public int dp(int dp) {
        return PViewSizeUtils.dp(this.recyclerView.getContext(), dp);
    }
}

