/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.ypx.imagepicker.bean.ImageCropMode;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.helper.DetailImageLoadHelper;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.widget.cropimage.CropImageView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CropViewContainerHelper {
    private WeakReference<ViewGroup> parentReference;
    private HashMap<ImageItem, CropImageView> cropViewList = new HashMap();
    private CropImageView mCropView;

    public CropViewContainerHelper(@NonNull ViewGroup parent) {
        this.parentReference = new WeakReference<ViewGroup>(parent);
    }

    private ViewGroup getParent() {
        if (this.parentReference != null && this.parentReference.get() != null) {
            return (ViewGroup)this.parentReference.get();
        }
        return null;
    }

    public void setBackgroundColor(int color2) {
        if (this.mCropView != null) {
            this.mCropView.setBackgroundColor(color2);
        }
    }

    public CropImageView loadCropView(Context context, final ImageItem imageItem, int mCropSize, IPickerPresenter presenter, final onLoadComplete loadComplete) {
        Activity activity = (Activity)context;
        if (this.cropViewList.containsKey(imageItem) && this.cropViewList.get(imageItem) != null) {
            this.mCropView = this.cropViewList.get(imageItem);
        } else {
            this.mCropView = new CropImageView(context);
            this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mCropView.enable();
            this.mCropView.setMaxScale(7.0f);
            this.mCropView.setCanShowTouchLine(true);
            this.mCropView.setShowImageRectLine(true);
            if (imageItem.width == 0 || imageItem.height == 0) {
                this.mCropView.setOnImageLoadListener(new CropImageView.onImageLoadListener(){

                    @Override
                    public void onImageLoaded(float w, float h) {
                        imageItem.width = (int)w;
                        imageItem.height = (int)h;
                        if (loadComplete != null) {
                            loadComplete.loadComplete();
                        }
                    }
                });
            }
            DetailImageLoadHelper.displayDetailImage(true, this.mCropView, presenter, imageItem);
        }
        if (this.getParent() != null) {
            this.getParent().removeAllViews();
            if (this.mCropView.getParent() != null) {
                ((ViewGroup)this.mCropView.getParent()).removeView((View)this.mCropView);
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(mCropSize, mCropSize);
            params.gravity = 17;
            this.getParent().addView((View)this.mCropView, (ViewGroup.LayoutParams)params);
        }
        return this.mCropView;
    }

    public void addCropView(CropImageView view, ImageItem imageItem) {
        if (!this.cropViewList.containsKey(imageItem)) {
            this.cropViewList.put(imageItem, view);
        }
    }

    public void removeCropView(ImageItem imageItem) {
        this.cropViewList.remove(imageItem);
    }

    public void refreshAllState(ImageItem currentImageItem, List<ImageItem> selectList, ViewGroup invisibleContainer, boolean isFitState, ResetSizeExecutor executor) {
        invisibleContainer.removeAllViews();
        invisibleContainer.setVisibility(0);
        for (ImageItem imageItem : selectList) {
            CropImageView picBrowseImageView;
            if (imageItem == currentImageItem || (picBrowseImageView = this.cropViewList.get(imageItem)) == null) continue;
            invisibleContainer.addView((View)picBrowseImageView);
            if (executor != null) {
                executor.resetAllCropViewSize(picBrowseImageView);
            }
            if (isFitState) {
                imageItem.setCropMode(ImageCropMode.ImageScale_FILL);
                picBrowseImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
            this.cropViewList.put(imageItem, picBrowseImageView);
        }
        invisibleContainer.setVisibility(4);
    }

    public ArrayList<ImageItem> generateCropUrls(List<ImageItem> selectList, int cropMode) {
        for (ImageItem imageItem : selectList) {
            CropImageView view = this.cropViewList.get(imageItem);
            if (view == null) continue;
            view.requestLayout();
            Bitmap bitmap = imageItem.getCropMode() == ImageCropMode.ImageScale_GAP ? view.generateCropBitmapFromView(-1) : view.generateCropBitmap();
            String cropUrl = PBitmapUtils.saveBitmapToFile(view.getContext(), bitmap, "crop_" + System.currentTimeMillis(), Bitmap.CompressFormat.JPEG);
            if (imageItem.getCropUrl() != null && imageItem.getCropUrl().length() > 0) {
                new File(imageItem.getCropUrl()).delete();
            }
            imageItem.setCropUrl(cropUrl);
            imageItem.setCropMode(cropMode);
            imageItem.setPress(false);
        }
        return (ArrayList)selectList;
    }

    public static interface ResetSizeExecutor {
        public void resetAllCropViewSize(CropImageView var1);
    }

    public static interface onLoadComplete {
        public void loadComplete();
    }
}

