/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.helper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.UriPathInfo;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.helper.launcher.PLauncher;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.utils.PDateUtil;
import com.ypx.imagepicker.utils.PPermissionUtils;
import com.ypx.imagepicker.utils.PSingleMediaScanner;
import com.ypx.imagepicker.utils.PickerFileProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CameraCompat {
    public static void takePhoto(final Activity activity, final String imageName, final boolean isCopyInDCIM, final OnImagePickCompleteListener listener) {
        final String path = PBitmapUtils.getPickerFileDirectory((Context)activity).getAbsolutePath() + File.separator + imageName + ".jpg";
        if (!PPermissionUtils.hasCameraPermissions(activity) || listener == null) {
            return;
        }
        final Uri imageUri = PickerFileProvider.getUriForFile(activity, new File(path));
        PLauncher.init(activity).startActivityForResult(CameraCompat.getTakePhotoIntent(activity, imageUri), new PLauncher.Callback(){

            @Override
            public void onActivityResult(int resultCode, Intent data) {
                UriPathInfo uriPathInfo;
                if (resultCode != -1 || path == null || path.trim().length() == 0) {
                    PickerErrorExecutor.executeError(listener, PickerError.TAKE_PHOTO_FAILED.getCode());
                    return;
                }
                if (isCopyInDCIM) {
                    uriPathInfo = PBitmapUtils.copyFileToDCIM((Context)activity, path, imageName, MimeType.JPEG);
                    PSingleMediaScanner.refresh((Context)activity, uriPathInfo.absolutePath, null);
                } else {
                    uriPathInfo = new UriPathInfo(imageUri, path);
                }
                ImageItem item = new ImageItem();
                item.path = uriPathInfo.absolutePath;
                item.mimeType = MimeType.JPEG.toString();
                item.setUriPath(uriPathInfo.uri.toString());
                item.time = System.currentTimeMillis();
                int[] size = PBitmapUtils.getImageWidthHeight(path);
                item.width = size[0];
                item.height = size[1];
                item.mimeType = MimeType.JPEG.toString();
                ArrayList<ImageItem> list = new ArrayList<ImageItem>();
                list.add(item);
                listener.onImagePickComplete(list);
            }
        });
    }

    public static void takeVideo(final Activity activity, final String videoName, long maxDuration, final boolean isCopyInDCIM, final OnImagePickCompleteListener listener) {
        if (!PPermissionUtils.hasCameraPermissions(activity) || listener == null) {
            return;
        }
        final String path = PBitmapUtils.getPickerFileDirectory((Context)activity).getAbsolutePath() + File.separator + videoName + ".mp4";
        final Uri videoUri = PickerFileProvider.getUriForFile(activity, new File(path));
        PLauncher.init(activity).startActivityForResult(CameraCompat.getTakeVideoIntent(activity, videoUri, maxDuration), new PLauncher.Callback(){

            @Override
            public void onActivityResult(int resultCode, Intent data) {
                UriPathInfo uriPathInfo;
                if (resultCode != -1 || path == null || path.trim().length() == 0) {
                    PickerErrorExecutor.executeError(listener, PickerError.TAKE_PHOTO_FAILED.getCode());
                    return;
                }
                if (isCopyInDCIM) {
                    uriPathInfo = PBitmapUtils.copyFileToDCIM((Context)activity, path, videoName, MimeType.MP4);
                    PSingleMediaScanner.refresh((Context)activity, uriPathInfo.absolutePath, null);
                } else {
                    uriPathInfo = new UriPathInfo(videoUri, path);
                }
                ImageItem item = new ImageItem();
                item.path = uriPathInfo.absolutePath;
                item.setUriPath(uriPathInfo.uri.toString());
                item.time = System.currentTimeMillis();
                item.mimeType = MimeType.MP4.toString();
                item.setVideo(true);
                item.duration = PBitmapUtils.getLocalVideoDuration(path);
                item.setDurationFormat(PDateUtil.getVideoDuration(item.duration));
                ArrayList<ImageItem> list = new ArrayList<ImageItem>();
                list.add(item);
                listener.onImagePickComplete(list);
            }
        });
    }

    private static Intent getTakePhotoIntent(Activity activity, Uri imageUri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Environment.getExternalStorageState().equals("mounted")) {
            if (Build.VERSION.SDK_INT < 21) {
                List resInfoList = activity.getPackageManager().queryIntentActivities(intent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, imageUri, 3);
                }
            }
            intent.putExtra("output", (Parcelable)imageUri);
            intent.addFlags(2);
        }
        return intent;
    }

    private static Intent getTakeVideoIntent(Activity activity, Uri imageUri, long maxDuration) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (Environment.getExternalStorageState().equals("mounted")) {
            if (Build.VERSION.SDK_INT < 21) {
                List resInfoList = activity.getPackageManager().queryIntentActivities(intent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, imageUri, 3);
                }
            }
            intent.putExtra("output", (Parcelable)imageUri);
            if (maxDuration > 1L) {
                intent.putExtra("android.intent.extra.durationLimit", maxDuration / 1000L);
            }
            intent.addFlags(2);
        }
        return intent;
    }
}

