/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.data;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.LongSparseArray;
import androidx.loader.content.CursorLoader;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.data.MediaStoreConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MediaSetsLoader
extends CursorLoader {
    private boolean isLoadVideo;
    private boolean isLoadImage;
    private static final String[] COLUMNS = new String[]{"_id", "bucket_id", "bucket_display_name", "uri", "count"};
    private static final String[] PROJECTION = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type"};

    private MediaSetsLoader(Context context, String selection, String[] selectionArgs, boolean isLoadVideo, boolean isLoadImage) {
        super(context, MediaStoreConstants.QUERY_URI, PROJECTION, selection, selectionArgs, "date_modified DESC");
        this.isLoadVideo = isLoadVideo;
        this.isLoadImage = isLoadImage;
    }

    public static CursorLoader create(Context context, Set<MimeType> mimeTypeSet, boolean isLoadVideo, boolean isLoadImage) {
        int index = 0;
        String mimeSelection = "";
        ArrayList<String> arrayList = MimeType.getMimeTypeList(mimeTypeSet);
        String[] selectionArgs = new String[arrayList.size()];
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String mimeType;
            selectionArgs[index] = mimeType = iterator.next();
            mimeSelection = String.format("%s =? OR %s", "mime_type", mimeSelection);
            ++index;
        }
        if (mimeSelection.endsWith(" OR ")) {
            mimeSelection = mimeSelection.substring(0, mimeSelection.length() - 4);
        }
        String selection = "(media_type=3 OR media_type=1) AND _size>0 AND (" + mimeSelection + ")";
        return new MediaSetsLoader(context, selection, selectionArgs, isLoadVideo, isLoadImage);
    }

    public Cursor loadInBackground() {
        Cursor albums = super.loadInBackground();
        MatrixCursor allAlbum = new MatrixCursor(COLUMNS);
        int totalCount = 0;
        Uri allAlbumCoverUri = null;
        LongSparseArray countMap = new LongSparseArray();
        if (albums != null) {
            while (albums.moveToNext()) {
                long bucketId = albums.getLong(albums.getColumnIndex("bucket_id"));
                Long count = (Long)countMap.get(bucketId);
                count = count == null ? 1L : count + 1L;
                countMap.put(bucketId, (Object)count);
            }
        }
        MatrixCursor newAlbums = new MatrixCursor(COLUMNS);
        if (albums != null && albums.moveToFirst()) {
            allAlbumCoverUri = MediaSetsLoader.getUri(albums);
            HashSet<Long> done = new HashSet<Long>();
            do {
                long bucketId;
                if (done.contains(bucketId = albums.getLong(albums.getColumnIndex("bucket_id")))) continue;
                long fileId = albums.getLong(albums.getColumnIndex("_id"));
                String bucketDisplayName = albums.getString(albums.getColumnIndex("bucket_display_name"));
                Uri uri = MediaSetsLoader.getUri(albums);
                long count = (Long)countMap.get(bucketId);
                newAlbums.addRow((Object[])new String[]{Long.toString(fileId), Long.toString(bucketId), bucketDisplayName, uri.toString(), String.valueOf(count)});
                done.add(bucketId);
                totalCount = (int)((long)totalCount + count);
            } while (albums.moveToNext());
        }
        String name = "";
        if (this.isLoadImage && this.isLoadVideo) {
            name = this.getContext().getString(R.string.picker_str_folder_item_all);
        } else if (this.isLoadImage) {
            name = this.getContext().getString(R.string.picker_str_folder_item_image);
        } else if (this.isLoadVideo) {
            name = this.getContext().getString(R.string.picker_str_folder_item_video);
        }
        allAlbum.addRow((Object[])new String[]{"-1", "-1", name, allAlbumCoverUri == null ? null : allAlbumCoverUri.toString(), String.valueOf(totalCount)});
        return new MergeCursor(new Cursor[]{allAlbum, newAlbums});
    }

    private static Uri getUri(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndex("_id"));
        String mimeType = cursor.getString(cursor.getColumnIndex("mime_type"));
        Uri contentUri = MimeType.isImage(mimeType) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (MimeType.isVideo(mimeType) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStoreConstants.QUERY_URI);
        return ContentUris.withAppendedId((Uri)contentUri, (long)id2);
    }

    public void onContentChanged() {
    }
}

