/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.data;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.data.MediaSetsLoader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;

public class MediaSetsDataSource
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int LOADER_ID = 1;
    private WeakReference<FragmentActivity> mContext;
    private LoaderManager mLoaderManager;
    private MediaSetProvider mediaSetProvider;
    private boolean isLoadVideo;
    private boolean isLoadImage;
    private Set<MimeType> mimeTypeSet = MimeType.ofAll();

    public MediaSetsDataSource setMimeTypeSet(BaseSelectConfig config) {
        this.isLoadImage = config.isShowImage();
        this.isLoadVideo = config.isShowVideo();
        this.mimeTypeSet = config.getMimeTypes();
        return this;
    }

    public MediaSetsDataSource setMimeTypeSet(Set<MimeType> mimeTypeSet) {
        this.mimeTypeSet = mimeTypeSet;
        for (MimeType mimeType : mimeTypeSet) {
            if (MimeType.ofVideo().contains((Object)mimeType)) {
                this.isLoadVideo = true;
            }
            if (!MimeType.ofImage().contains((Object)mimeType)) continue;
            this.isLoadImage = true;
        }
        return this;
    }

    public void loadMediaSets(MediaSetProvider mediaSetProvider) {
        this.mediaSetProvider = mediaSetProvider;
        this.mLoaderManager.initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
    }

    public static MediaSetsDataSource create(FragmentActivity activity) {
        return new MediaSetsDataSource(activity);
    }

    private MediaSetsDataSource(FragmentActivity activity) {
        this.mContext = new WeakReference<FragmentActivity>(activity);
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)((LifecycleOwner)this.mContext.get()));
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        Context context = (Context)this.mContext.get();
        return MediaSetsLoader.create(context, this.mimeTypeSet, this.isLoadVideo, this.isLoadImage);
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor cursor) {
        FragmentActivity context = (FragmentActivity)this.mContext.get();
        if (context == null) {
            return;
        }
        ArrayList<ImageSet> imageSetList = new ArrayList<ImageSet>();
        if (!context.isDestroyed() && cursor.moveToFirst() && !cursor.isClosed()) {
            do {
                ImageSet imageSet = new ImageSet();
                imageSet.id = this.getString(cursor, "bucket_id");
                imageSet.name = this.getString(cursor, "bucket_display_name");
                imageSet.coverPath = this.getString(cursor, "uri");
                imageSet.count = this.getInt(cursor, "count");
                imageSetList.add(imageSet);
            } while (!context.isDestroyed() && cursor.moveToNext() && !cursor.isClosed());
        }
        if (this.mediaSetProvider != null) {
            this.mediaSetProvider.providerMediaSets(imageSetList);
        }
        if (this.mLoaderManager != null) {
            this.mLoaderManager.destroyLoader(1);
        }
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
    }

    private int getInt(Cursor data, String text) {
        int index = this.hasColumn(data, text);
        if (index != -1) {
            return data.getInt(index);
        }
        return 0;
    }

    private String getString(Cursor data, String text) {
        int index = this.hasColumn(data, text);
        if (index != -1) {
            return data.getString(index);
        }
        return "";
    }

    private int hasColumn(Cursor data, String id2) {
        try {
            return data.getColumnIndexOrThrow(id2);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static interface MediaSetProvider {
        public void providerMediaSets(ArrayList<ImageSet> var1);
    }
}

