/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.data;

import android.content.Context;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.loader.content.CursorLoader;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.MimeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class MediaItemsLoader
extends CursorLoader {
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String[] PROJECTION = new String[]{"_id", "_data", "_display_name", "width", "height", "mime_type", "_size", "duration", "date_modified"};
    private static final String ORDER_BY = "date_modified DESC";

    private MediaItemsLoader(Context context, String selection, String[] selectionArgs) {
        super(context, QUERY_URI, PROJECTION, selection, selectionArgs, ORDER_BY);
    }

    static CursorLoader newInstance(Context context, ImageSet album, Set<MimeType> mimeTypeSet) {
        String[] selectionsArgs;
        String albumSelections = "";
        String mimeSelections = "";
        int index = 0;
        ArrayList<String> arrayList = MimeType.getMimeTypeList(mimeTypeSet);
        if (album.isAllMedia() || album.isAllVideo()) {
            selectionsArgs = new String[arrayList.size()];
        } else {
            selectionsArgs = new String[arrayList.size() + 1];
            selectionsArgs[0] = album.id;
            index = 1;
            albumSelections = " bucket_id=? AND ";
        }
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String mimeType;
            selectionsArgs[index] = mimeType = iterator.next();
            mimeSelections = String.format("%s =? OR %s", "mime_type", mimeSelections);
            ++index;
        }
        if (mimeSelections.endsWith(" OR ")) {
            mimeSelections = mimeSelections.substring(0, mimeSelections.length() - 4);
        }
        String selections = albumSelections + "(" + "media_type" + "=" + 1 + " OR " + "media_type" + "=" + 3 + ") AND " + "_size" + ">0 AND (" + mimeSelections + ")";
        return new MediaItemsLoader(context, selections, selectionsArgs);
    }

    public void onContentChanged() {
    }
}

