/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.data;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.data.MediaItemsLoader;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.utils.PDateUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;

public class MediaItemsDataSource
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int LOADER_ID = 2;
    private WeakReference<FragmentActivity> mContext;
    private LoaderManager mLoaderManager;
    private MediaItemProvider mediaItemProvider;
    private int preloadSize = 40;
    private Set<MimeType> mimeTypeSet = MimeType.ofAll();
    private ImageSet set;
    private Cursor cursor;
    private Thread thread;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            FragmentActivity context = (FragmentActivity)MediaItemsDataSource.this.mContext.get();
            ArrayList<ImageItem> imageItems = new ArrayList<ImageItem>();
            ArrayList<ImageItem> allVideoItems = new ArrayList<ImageItem>();
            if (!context.isDestroyed() && !MediaItemsDataSource.this.cursor.isClosed() && MediaItemsDataSource.this.cursor.moveToFirst()) {
                do {
                    ImageItem item = new ImageItem();
                    try {
                        item.id = MediaItemsDataSource.this.getLong(MediaItemsDataSource.this.cursor, "_id");
                        item.mimeType = MediaItemsDataSource.this.getString(MediaItemsDataSource.this.cursor, "mime_type");
                        item.displayName = MediaItemsDataSource.this.getString(MediaItemsDataSource.this.cursor, "_display_name");
                        try {
                            item.path = MediaItemsDataSource.this.getString(MediaItemsDataSource.this.cursor, "_data");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Uri urlPath = item.getUri();
                        if (urlPath != null) {
                            item.setUriPath(urlPath.toString());
                        }
                        if (item.path == null || item.path.length() == 0) {
                            item.path = urlPath.toString();
                        }
                        item.width = MediaItemsDataSource.this.getInt(MediaItemsDataSource.this.cursor, "width");
                        item.height = MediaItemsDataSource.this.getInt(MediaItemsDataSource.this.cursor, "height");
                        item.setVideo(MimeType.isVideo(item.mimeType));
                        item.time = MediaItemsDataSource.this.getLong(MediaItemsDataSource.this.cursor, "date_modified");
                        item.timeFormat = PDateUtil.getStrTime((Context)context, item.time);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (item.path == null || item.path.length() == 0) continue;
                    if (item.isVideo()) {
                        item.duration = MediaItemsDataSource.this.getLong(MediaItemsDataSource.this.cursor, "duration");
                        if (item.duration == 0L) continue;
                        item.durationFormat = PDateUtil.getVideoDuration(item.duration);
                        if (MediaItemsDataSource.this.set.isAllMedia()) {
                            allVideoItems.add(item);
                        }
                    } else if (!(item.width != 0 && item.height != 0 || item.isUriPath())) {
                        int[] size = PBitmapUtils.getImageWidthHeight(item.path);
                        item.width = size[0];
                        item.height = size[1];
                    }
                    imageItems.add(item);
                    if (MediaItemsDataSource.this.preloadProvider == null || imageItems.size() != MediaItemsDataSource.this.preloadSize) continue;
                    MediaItemsDataSource.this.notifyPreloadItem(context, imageItems);
                } while (!context.isDestroyed() && !MediaItemsDataSource.this.cursor.isClosed() && MediaItemsDataSource.this.cursor.moveToNext());
            }
            ImageSet allVideoSet = null;
            if (allVideoItems.size() > 0) {
                allVideoSet = new ImageSet();
                allVideoSet.id = "-2";
                allVideoSet.coverPath = ((ImageItem)allVideoItems.get((int)0)).path;
                allVideoSet.cover = (ImageItem)allVideoItems.get(0);
                allVideoSet.count = allVideoItems.size();
                allVideoSet.imageItems = allVideoItems;
                allVideoSet.name = context.getString(R.string.picker_str_folder_item_video);
            }
            MediaItemsDataSource.this.notifyMediaItem(context, imageItems, allVideoSet);
        }
    };
    private MediaItemPreloadProvider preloadProvider;

    public MediaItemsDataSource setMimeTypeSet(BaseSelectConfig config) {
        this.mimeTypeSet = config.getMimeTypes();
        return this;
    }

    public MediaItemsDataSource setMimeTypeSet(Set<MimeType> mimeTypeSet) {
        this.mimeTypeSet = mimeTypeSet;
        return this;
    }

    public MediaItemsDataSource preloadSize(int preloadSize) {
        this.preloadSize = preloadSize;
        return this;
    }

    public void loadMediaItems(MediaItemProvider mediaItemProvider) {
        this.mediaItemProvider = mediaItemProvider;
        this.mLoaderManager.initLoader(2, null, (LoaderManager.LoaderCallbacks)this);
    }

    public static MediaItemsDataSource create(FragmentActivity activity, ImageSet set) {
        return new MediaItemsDataSource(activity, set);
    }

    private MediaItemsDataSource(FragmentActivity activity, ImageSet set) {
        this.set = set;
        this.mContext = new WeakReference<FragmentActivity>(activity);
        this.mLoaderManager = LoaderManager.getInstance((LifecycleOwner)((LifecycleOwner)this.mContext.get()));
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return MediaItemsLoader.newInstance(context, this.set, this.mimeTypeSet);
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor cursor) {
        FragmentActivity context = (FragmentActivity)this.mContext.get();
        if (context == null | cursor == null || cursor.isClosed()) {
            return;
        }
        this.cursor = cursor;
        if (this.thread != null && this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(this.runnable);
        this.thread.start();
    }

    private void notifyPreloadItem(final FragmentActivity context, final ArrayList<ImageItem> imageItems) {
        context.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (context.isDestroyed()) {
                    return;
                }
                MediaItemsDataSource.this.preloadProvider.providerMediaItems(imageItems);
                MediaItemsDataSource.this.preloadProvider = null;
            }
        });
    }

    private void notifyMediaItem(final FragmentActivity context, final ArrayList<ImageItem> imageItems, final ImageSet allVideoSet) {
        context.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (context.isDestroyed()) {
                    return;
                }
                if (MediaItemsDataSource.this.mediaItemProvider != null) {
                    MediaItemsDataSource.this.mediaItemProvider.providerMediaItems(imageItems, allVideoSet);
                }
                if (MediaItemsDataSource.this.mLoaderManager != null) {
                    MediaItemsDataSource.this.mLoaderManager.destroyLoader(2);
                }
            }
        });
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
    }

    public void setPreloadProvider(MediaItemPreloadProvider preloadProvider) {
        this.preloadProvider = preloadProvider;
    }

    private long getLong(Cursor data, String text) {
        int index = this.hasColumn(data, text);
        if (index != -1) {
            return data.getLong(index);
        }
        return 0L;
    }

    private int getInt(Cursor data, String text) {
        int index = this.hasColumn(data, text);
        if (index != -1) {
            return data.getInt(index);
        }
        return 0;
    }

    private String getString(Cursor data, String text) {
        int index = this.hasColumn(data, text);
        if (index != -1) {
            return data.getString(index);
        }
        return "";
    }

    private int hasColumn(Cursor data, String id2) {
        try {
            return data.getColumnIndexOrThrow(id2);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static interface MediaItemPreloadProvider {
        public void providerMediaItems(ArrayList<ImageItem> var1);
    }

    public static interface MediaItemProvider {
        public void providerMediaItems(ArrayList<ImageItem> var1, ImageSet var2);
    }
}

