/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.builder;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.multi.MultiImagePickerActivity;
import com.ypx.imagepicker.activity.multi.MultiImagePickerFragment;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MultiPickerBuilder {
    private MultiSelectConfig selectConfig;
    private IPickerPresenter presenter;

    public MultiPickerBuilder(IPickerPresenter presenter) {
        this.presenter = presenter;
        this.selectConfig = new MultiSelectConfig();
    }

    public MultiPickerBuilder setSinglePickWithAutoComplete(boolean isAutoComplete) {
        this.selectConfig.setSinglePickAutoComplete(isAutoComplete);
        return this;
    }

    public MultiPickerBuilder setMaxCount(int selectLimit) {
        this.selectConfig.setMaxCount(selectLimit);
        return this;
    }

    public MultiPickerBuilder setSelectMode(int selectMode) {
        this.selectConfig.setSelectMode(selectMode);
        return this;
    }

    public MultiPickerBuilder setMaxVideoDuration(long duration) {
        this.selectConfig.setMaxVideoDuration(duration);
        return this;
    }

    public MultiPickerBuilder setMinVideoDuration(long duration) {
        this.selectConfig.setMinVideoDuration(duration);
        return this;
    }

    public MultiPickerBuilder mimeTypes(MimeType ... mimeTypes) {
        if (mimeTypes == null || mimeTypes.length == 0) {
            return this;
        }
        HashSet<MimeType> mimeTypeSet = new HashSet<MimeType>(Arrays.asList(mimeTypes));
        return this.mimeTypes(mimeTypeSet);
    }

    public MultiPickerBuilder filterMimeTypes(Set<MimeType> mimeTypes) {
        if (mimeTypes != null && this.selectConfig != null && this.selectConfig.getMimeTypes() != null) {
            this.selectConfig.getMimeTypes().removeAll(mimeTypes);
        }
        return this;
    }

    public MultiPickerBuilder filterMimeTypes(MimeType ... mimeTypes) {
        if (mimeTypes == null || mimeTypes.length == 0) {
            return this;
        }
        HashSet<MimeType> mimeTypeSet = new HashSet<MimeType>(Arrays.asList(mimeTypes));
        return this.filterMimeTypes(mimeTypeSet);
    }

    public MultiPickerBuilder mimeTypes(Set<MimeType> mimeTypes) {
        if (mimeTypes == null || mimeTypes.size() == 0) {
            return this;
        }
        this.selectConfig.setMimeTypes(mimeTypes);
        return this;
    }

    public MultiPickerBuilder setColumnCount(int columnCount) {
        this.selectConfig.setColumnCount(columnCount);
        return this;
    }

    public MultiPickerBuilder showCamera(boolean showCamera) {
        this.selectConfig.setShowCamera(showCamera);
        return this;
    }

    public MultiPickerBuilder showCameraOnlyInAllMediaSet(boolean showCamera) {
        this.selectConfig.setShowCameraInAllMedia(showCamera);
        return this;
    }

    public MultiPickerBuilder setSinglePickImageOrVideoType(boolean isSinglePickImageOrVideoType) {
        this.selectConfig.setSinglePickImageOrVideoType(isSinglePickImageOrVideoType);
        return this;
    }

    public MultiPickerBuilder setVideoSinglePick(boolean isVideoSinglePick) {
        this.selectConfig.setVideoSinglePick(isVideoSinglePick);
        return this;
    }

    public MultiPickerBuilder setPreviewVideo(boolean isPreview) {
        this.selectConfig.setCanPreviewVideo(isPreview);
        return this;
    }

    public MultiPickerBuilder setPreview(boolean isPreview) {
        this.selectConfig.setPreview(isPreview);
        return this;
    }

    public MultiPickerBuilder setOriginal(boolean isOriginal) {
        this.selectConfig.setShowOriginalCheckBox(isOriginal);
        return this;
    }

    public MultiPickerBuilder setDefaultOriginal(boolean isOriginal) {
        this.selectConfig.setDefaultOriginal(isOriginal);
        return this;
    }

    public <T> MultiPickerBuilder setShieldList(ArrayList<T> imageList) {
        if (imageList == null || imageList.size() == 0) {
            return this;
        }
        this.selectConfig.setShieldImageList(this.transitArray(imageList));
        return this;
    }

    public <T> MultiPickerBuilder setLastImageList(ArrayList<T> imageList) {
        if (imageList == null || imageList.size() == 0) {
            return this;
        }
        this.selectConfig.setLastImageList(this.transitArray(imageList));
        return this;
    }

    public MultiPickerBuilder cropRectMinMargin(int margin) {
        this.selectConfig.setCropRectMargin(margin);
        return this;
    }

    public MultiPickerBuilder cropStyle(int style) {
        this.selectConfig.setCropStyle(style);
        return this;
    }

    public MultiPickerBuilder cropGapBackgroundColor(int color2) {
        this.selectConfig.setCropGapBackgroundColor(color2);
        return this;
    }

    public MultiPickerBuilder setCropRatio(int x, int y) {
        this.selectConfig.setCropRatio(x, y);
        return this;
    }

    public MultiPickerBuilder cropAsCircle() {
        this.selectConfig.setCircle(true);
        return this;
    }

    public MultiPickerBuilder cropSaveInDCIM(boolean isSaveInDCIM) {
        this.selectConfig.saveInDCIM(isSaveInDCIM);
        return this;
    }

    public MultiPickerBuilder setSingleCropCutNeedTop(boolean singleCropCutNeedTop) {
        this.selectConfig.setSingleCropCutNeedTop(singleCropCutNeedTop);
        return this;
    }

    public MultiPickerBuilder withMultiSelectConfig(MultiSelectConfig config) {
        this.selectConfig = config;
        return this;
    }

    public MultiImagePickerFragment pickWithFragment(OnImagePickCompleteListener completeListener) {
        this.checkVideoAndImage();
        MultiImagePickerFragment mFragment = new MultiImagePickerFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("MultiSelectConfig", (Serializable)this.selectConfig);
        bundle.putSerializable("IPickerPresenter", (Serializable)this.presenter);
        mFragment.setArguments(bundle);
        mFragment.setOnImagePickCompleteListener(completeListener);
        return mFragment;
    }

    public void pick(Activity context, OnImagePickCompleteListener listener) {
        this.checkVideoAndImage();
        if (this.selectConfig.getMimeTypes() == null || this.selectConfig.getMimeTypes().size() == 0) {
            PickerErrorExecutor.executeError(listener, PickerError.MIMETYPES_EMPTY.getCode());
            this.presenter.tip((Context)context, context.getString(R.string.picker_str_tip_mimeTypes_empty));
            return;
        }
        MultiImagePickerActivity.intent(context, this.selectConfig, this.presenter, listener);
    }

    public void crop(Activity context, OnImagePickCompleteListener listener) {
        this.setMaxCount(1);
        this.filterMimeTypes(MimeType.ofVideo());
        this.setSinglePickImageOrVideoType(false);
        this.setSinglePickWithAutoComplete(true);
        this.setVideoSinglePick(false);
        this.setShieldList(null);
        this.setLastImageList(null);
        this.setPreview(false);
        this.selectConfig.setSelectMode(3);
        if (this.selectConfig.isCircle()) {
            this.selectConfig.setCropRatio(1, 1);
        }
        if (this.selectConfig.getMimeTypes() == null || this.selectConfig.getMimeTypes().size() == 0) {
            PickerErrorExecutor.executeError(listener, PickerError.MIMETYPES_EMPTY.getCode());
            this.presenter.tip((Context)context, context.getString(R.string.picker_str_tip_mimeTypes_empty));
            return;
        }
        MultiImagePickerActivity.intent(context, this.selectConfig, this.presenter, listener);
    }

    private void checkVideoAndImage() {
        if (this.selectConfig == null) {
            return;
        }
        this.selectConfig.setShowVideo(false);
        this.selectConfig.setShowImage(false);
        for (MimeType mimeType : this.selectConfig.getMimeTypes()) {
            if (MimeType.ofVideo().contains((Object)mimeType)) {
                this.selectConfig.setShowVideo(true);
            }
            if (!MimeType.ofImage().contains((Object)mimeType)) continue;
            this.selectConfig.setShowImage(true);
        }
    }

    private <T> ArrayList<ImageItem> transitArray(ArrayList<T> imageList) {
        ArrayList<ImageItem> items = new ArrayList<ImageItem>();
        for (T t : imageList) {
            if (t instanceof String) {
                ImageItem imageItem = new ImageItem();
                imageItem.path = (String)t;
                items.add(imageItem);
                continue;
            }
            if (t instanceof ImageItem) {
                items.add((ImageItem)t);
                continue;
            }
            throw new RuntimeException("ImageList item must be instanceof String or ImageItem");
        }
        return items;
    }
}

