/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.builder;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.crop.MultiImageCropActivity;
import com.ypx.imagepicker.activity.crop.MultiImageCropFragment;
import com.ypx.imagepicker.bean.ImageCropMode;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.CropSelectConfig;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CropPickerBuilder {
    private CropSelectConfig selectConfig;
    private IPickerPresenter presenter;

    public CropPickerBuilder(IPickerPresenter presenter) {
        this.presenter = presenter;
        this.selectConfig = new CropSelectConfig();
    }

    public CropPickerBuilder setColumnCount(int columnCount) {
        this.selectConfig.setColumnCount(columnCount);
        return this;
    }

    public CropPickerBuilder setMaxVideoDuration(long duration) {
        this.selectConfig.setMaxVideoDuration(duration);
        return this;
    }

    public CropPickerBuilder setMinVideoDuration(long duration) {
        this.selectConfig.setMinVideoDuration(duration);
        return this;
    }

    public CropPickerBuilder setMaxCount(int maxCount) {
        this.selectConfig.setMaxCount(maxCount);
        return this;
    }

    public CropPickerBuilder setVideoSinglePick(boolean isSinglePick) {
        this.selectConfig.setVideoSinglePick(isSinglePick);
        return this;
    }

    public CropPickerBuilder showCamera(boolean isShowCamera) {
        this.selectConfig.setShowCamera(isShowCamera);
        return this;
    }

    public CropPickerBuilder mimeTypes(Set<MimeType> mimeTypes) {
        if (mimeTypes == null || mimeTypes.size() == 0) {
            return this;
        }
        this.selectConfig.setMimeTypes(mimeTypes);
        return this;
    }

    public CropPickerBuilder mimeTypes(MimeType ... mimeTypes) {
        if (mimeTypes == null || mimeTypes.length == 0) {
            return this;
        }
        HashSet<MimeType> mimeTypeSet = new HashSet<MimeType>(Arrays.asList(mimeTypes));
        return this.mimeTypes(mimeTypeSet);
    }

    public CropPickerBuilder filterMimeTypes(MimeType ... mimeTypes) {
        if (mimeTypes == null || mimeTypes.length == 0) {
            return this;
        }
        HashSet<MimeType> mimeTypeSet = new HashSet<MimeType>(Arrays.asList(mimeTypes));
        return this.filterMimeTypes(mimeTypeSet);
    }

    public CropPickerBuilder filterMimeTypes(Set<MimeType> mimeTypes) {
        this.selectConfig.getMimeTypes().removeAll(mimeTypes);
        return this;
    }

    public CropPickerBuilder setSinglePickWithAutoComplete(boolean isAutoComplete) {
        this.selectConfig.setSinglePickAutoComplete(isAutoComplete);
        return this;
    }

    public CropPickerBuilder setFirstImageItemSize(int width, int height) {
        if (width == 0 || height == 0 || this.selectConfig.hasFirstImageItem()) {
            return this;
        }
        ImageItem firstImageItem = new ImageItem();
        firstImageItem.setVideo(false);
        firstImageItem.width = width;
        firstImageItem.height = height;
        if (Math.abs(width - height) < 5) {
            firstImageItem.setCropMode(ImageCropMode.CropViewScale_FULL);
        } else {
            firstImageItem.setCropMode(ImageCropMode.CropViewScale_FIT);
        }
        return this.setFirstImageItem(firstImageItem);
    }

    public CropPickerBuilder assignGapState(boolean isAssignGap) {
        this.selectConfig.setAssignGapState(isAssignGap);
        if (isAssignGap) {
            this.setFirstImageItemSize(1, 1);
        }
        return this;
    }

    public CropPickerBuilder setFirstImageItem(ImageItem firstImageItem) {
        if (firstImageItem != null) {
            if (firstImageItem.isVideo() || this.selectConfig.hasFirstImageItem()) {
                return this;
            }
            if (firstImageItem.width > 0 && firstImageItem.height > 0) {
                this.selectConfig.setFirstImageItem(firstImageItem);
            }
        }
        return this;
    }

    public CropPickerBuilder withSelectConfig(CropSelectConfig selectConfig) {
        this.selectConfig = selectConfig;
        return this;
    }

    public void pick(Activity activity, OnImagePickCompleteListener listener) {
        this.checkVideoAndImage();
        if (this.selectConfig.getMimeTypes() == null || this.selectConfig.getMimeTypes().size() == 0) {
            PickerErrorExecutor.executeError(listener, PickerError.MIMETYPES_EMPTY.getCode());
            this.presenter.tip((Context)activity, activity.getString(R.string.picker_str_tip_mimeTypes_empty));
            return;
        }
        MultiImageCropActivity.intent(activity, this.presenter, this.selectConfig, listener);
    }

    public MultiImageCropFragment pickWithFragment(OnImagePickCompleteListener imageListener) {
        this.checkVideoAndImage();
        MultiImageCropFragment mFragment = new MultiImageCropFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("ICropPickerBindPresenter", (Serializable)this.presenter);
        bundle.putSerializable("selectConfig", (Serializable)this.selectConfig);
        mFragment.setArguments(bundle);
        mFragment.setOnImagePickCompleteListener(imageListener);
        return mFragment;
    }

    private void checkVideoAndImage() {
        this.selectConfig.setSinglePickImageOrVideoType(true);
        if (this.selectConfig == null) {
            return;
        }
        this.selectConfig.setShowVideo(false);
        this.selectConfig.setShowImage(false);
        for (MimeType mimeType : this.selectConfig.getMimeTypes()) {
            if (MimeType.ofVideo().contains((Object)mimeType)) {
                this.selectConfig.setShowVideo(true);
            }
            if (!MimeType.ofImage().contains((Object)mimeType)) continue;
            this.selectConfig.setShowImage(true);
        }
    }
}

