/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.bean;

import android.content.Context;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import java.util.ArrayList;

public class PickerItemDisableCode {
    public static final int NORMAL = 0;
    public static final int DISABLE_IN_SHIELD = 1;
    public static final int DISABLE_OVER_MAX_COUNT = 2;
    public static final int DISABLE_ONLY_SELECT_IMAGE = 3;
    public static final int DISABLE_ONLY_SELECT_VIDEO = 4;
    public static final int DISABLE_VIDEO_OVER_MAX_DURATION = 5;
    public static final int DISABLE_VIDEO_LESS_MIN_DURATION = 6;
    public static final int DISABLE_VIDEO_ONLY_SINGLE_PICK = 7;

    public static String getMessageFormCode(Context context, int code, IPickerPresenter presenter, BaseSelectConfig selectConfig) {
        String message = "";
        switch (code) {
            case 1: {
                message = context.getString(R.string.picker_str_tip_shield);
                break;
            }
            case 2: {
                presenter.overMaxCountTip(context, selectConfig.getMaxCount());
                message = "";
                break;
            }
            case 3: {
                message = context.getString(R.string.picker_str_tip_only_select_image);
                break;
            }
            case 4: {
                message = context.getString(R.string.picker_str_tip_only_select_video);
                break;
            }
            case 5: {
                message = context.getString(R.string.picker_str_str_video_over_max_duration) + selectConfig.getMaxVideoDurationFormat(context);
                break;
            }
            case 6: {
                message = context.getString(R.string.picker_str_tip_video_less_min_duration) + selectConfig.getMinVideoDurationFormat(context);
                break;
            }
            case 7: {
                message = context.getString(R.string.picker_str_tip_only_select_one_video);
            }
        }
        return message;
    }

    public static int getItemDisableCode(ImageItem imageItem, BaseSelectConfig selectConfig, ArrayList<ImageItem> selectList, boolean isContainsThisItem) {
        boolean isItemEnable = true;
        int disableCode = 0;
        if (selectConfig.isShieldItem(imageItem)) {
            isItemEnable = false;
            disableCode = 1;
        }
        if (imageItem.isVideo()) {
            if (isItemEnable && selectConfig.isSinglePickImageOrVideoType() && PickerItemDisableCode.selectedFirstItemIsImage(selectList)) {
                isItemEnable = false;
                disableCode = 3;
            } else if (isItemEnable && imageItem.duration > selectConfig.getMaxVideoDuration()) {
                isItemEnable = false;
                disableCode = 5;
            } else if (isItemEnable && imageItem.duration < selectConfig.getMinVideoDuration()) {
                isItemEnable = false;
                disableCode = 6;
            } else if (isItemEnable && selectConfig.isVideoSinglePick() && PickerItemDisableCode.isSelectedListContainsVideo(selectList) && !isContainsThisItem) {
                isItemEnable = false;
                disableCode = 7;
            }
        } else if (selectConfig.isSinglePickImageOrVideoType() && PickerItemDisableCode.selectedFirstItemIsVideo(selectList)) {
            isItemEnable = false;
            disableCode = 4;
        }
        if (isItemEnable && PickerItemDisableCode.hasSelectedList(selectList) && selectList.size() >= selectConfig.getMaxCount() && !isContainsThisItem) {
            disableCode = 2;
        }
        return disableCode;
    }

    private static boolean selectedFirstItemIsVideo(ArrayList<ImageItem> selectList) {
        return PickerItemDisableCode.hasSelectedList(selectList) && selectList.get(0) != null && selectList.get(0).isVideo();
    }

    private static boolean selectedFirstItemIsImage(ArrayList<ImageItem> selectList) {
        return PickerItemDisableCode.hasSelectedList(selectList) && selectList.get(0) != null && !selectList.get(0).isVideo();
    }

    private static boolean hasSelectedList(ArrayList<ImageItem> selectList) {
        return selectList != null && selectList.size() > 0;
    }

    private static boolean isSelectedListContainsVideo(ArrayList<ImageItem> selectList) {
        for (ImageItem imageItem : selectList) {
            if (!imageItem.isVideo()) continue;
            return true;
        }
        return false;
    }
}

