/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.bean;

import androidx.collection.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum MimeType {
    JPEG("image/jpeg", MimeType.arraySetOf("jpg", "jpeg")),
    PNG("image/png", MimeType.arraySetOf("png")),
    GIF("image/gif", MimeType.arraySetOf("gif")),
    BMP("image/x-ms-bmp", MimeType.arraySetOf("bmp", "x-ms-bmp")),
    WEBP("image/webp", MimeType.arraySetOf("webp")),
    MPEG("video/mpeg", MimeType.arraySetOf("mpeg", "mpg")),
    MP4("video/mp4", MimeType.arraySetOf("mp4")),
    QUICKTIME("video/quicktime", MimeType.arraySetOf("mov", "quicktime")),
    THREEGPP("video/3gpp", MimeType.arraySetOf("3gp", "3gpp")),
    THREEGPP2("video/3gpp2", MimeType.arraySetOf("3g2", "3gpp2")),
    MKV("video/x-matroska", MimeType.arraySetOf("mkv", "x-matroska")),
    WEBM("video/webm", MimeType.arraySetOf("webm")),
    TS("video/mp2ts", MimeType.arraySetOf("ts", "mp2ts")),
    AVI("video/avi", MimeType.arraySetOf("avi"));

    private final String mMimeTypeName;
    private final Set<String> mExtensions;

    private MimeType(String mimeTypeName, Set<String> extensions) {
        this.mMimeTypeName = mimeTypeName;
        this.mExtensions = extensions;
    }

    public Set<String> getExtensions() {
        return this.mExtensions;
    }

    public String getSuffix() {
        return new ArrayList<String>(this.mExtensions).get(0);
    }

    public static Set<MimeType> ofAll() {
        return EnumSet.allOf(MimeType.class);
    }

    public static Set<MimeType> of(MimeType type, MimeType ... rest) {
        return EnumSet.of(type, rest);
    }

    public static Set<MimeType> ofImage() {
        return EnumSet.of(JPEG, PNG, GIF, BMP, WEBP);
    }

    public static Set<MimeType> ofVideo() {
        return EnumSet.of(MPEG, new MimeType[]{MP4, QUICKTIME, THREEGPP, THREEGPP2, MKV, WEBM, TS, AVI});
    }

    public static boolean isImage(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public static boolean isVideo(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("video");
    }

    public static boolean isGif(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals(GIF.toString());
    }

    private static Set<String> arraySetOf(String ... suffixes) {
        return new ArraySet(Arrays.asList(suffixes));
    }

    public String toString() {
        return this.mMimeTypeName;
    }

    public static ArrayList<String> getMimeTypeList(Set<MimeType> mimeTypes) {
        if (mimeTypes == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> mimeList = new ArrayList<String>();
        for (MimeType mimeType : mimeTypes) {
            if (mimeType.mExtensions == null) continue;
            for (String s : mimeType.mExtensions) {
                if (MimeType.isImage(String.valueOf((Object)mimeType))) {
                    mimeList.add("image/" + s);
                    continue;
                }
                if (!MimeType.isVideo(String.valueOf((Object)mimeType))) continue;
                mimeList.add("video/" + s);
            }
        }
        return mimeList;
    }
}

