/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.bean;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.ypx.imagepicker.bean.ImageCropMode;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.widget.cropimage.Info;
import java.io.Serializable;

public class ImageItem
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 3429291195776736078L;
    public long id;
    public int width;
    public int height;
    public long time;
    public long duration;
    public String mimeType;
    public String timeFormat;
    public String durationFormat;
    private boolean isVideo = false;
    public boolean isOriginalImage = true;
    public String displayName;
    private String videoImageUri;
    private String imageFilterPath = "";
    public String path;
    private String uriPath;
    private String cropUrl;
    private boolean isSelect = false;
    private boolean isPress = false;
    private int selectIndex = -1;
    private int cropMode = ImageCropMode.ImageScale_FILL;
    private Info cropRestoreInfo;
    public static final Parcelable.Creator<ImageItem> CREATOR = new Parcelable.Creator<ImageItem>(){

        public ImageItem createFromParcel(Parcel in) {
            return new ImageItem(in);
        }

        public ImageItem[] newArray(int size) {
            return new ImageItem[size];
        }
    };

    public ImageItem() {
    }

    public static ImageItem withPath(Context context, String path) {
        ImageItem imageItem = new ImageItem();
        imageItem.path = path;
        if (imageItem.isUriPath()) {
            Uri uri = Uri.parse((String)path);
            imageItem.setUriPath(uri.toString());
            imageItem.mimeType = PBitmapUtils.getMimeTypeFromUri((Activity)context, uri);
            if (imageItem.mimeType != null && imageItem.isImage()) {
                imageItem.setVideo(MimeType.isVideo(imageItem.mimeType));
                if (imageItem.isImage()) {
                    int[] size = PBitmapUtils.getImageWidthHeight(context, uri);
                    imageItem.width = size[0];
                    imageItem.height = size[1];
                }
            }
        } else {
            imageItem.mimeType = PBitmapUtils.getMimeTypeFromPath(imageItem.path);
            if (imageItem.mimeType != null) {
                Uri uri;
                imageItem.setVideo(MimeType.isVideo(imageItem.mimeType));
                if (imageItem.isImage()) {
                    uri = PBitmapUtils.getImageContentUri(context, path);
                    int[] size = PBitmapUtils.getImageWidthHeight(path);
                    imageItem.width = size[0];
                    imageItem.height = size[1];
                } else {
                    uri = PBitmapUtils.getVideoContentUri(context, path);
                    imageItem.duration = PBitmapUtils.getLocalVideoDuration(path);
                }
                if (uri != null) {
                    imageItem.setUriPath(uri.toString());
                }
            }
        }
        return imageItem;
    }

    protected ImageItem(Parcel in) {
        this.id = in.readLong();
        this.width = in.readInt();
        this.height = in.readInt();
        this.time = in.readLong();
        this.duration = in.readLong();
        this.mimeType = in.readString();
        this.timeFormat = in.readString();
        this.durationFormat = in.readString();
        this.isVideo = in.readByte() != 0;
        this.videoImageUri = in.readString();
        this.imageFilterPath = in.readString();
        this.path = in.readString();
        this.uriPath = in.readString();
        this.cropUrl = in.readString();
        this.isSelect = in.readByte() != 0;
        this.isPress = in.readByte() != 0;
        this.selectIndex = in.readInt();
        this.cropMode = in.readInt();
        this.cropRestoreInfo = (Info)in.readParcelable(Info.class.getClassLoader());
        this.isOriginalImage = in.readByte() != 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeLong(this.time);
        dest.writeLong(this.duration);
        dest.writeString(this.mimeType);
        dest.writeString(this.timeFormat);
        dest.writeString(this.durationFormat);
        dest.writeByte((byte)(this.isVideo ? 1 : 0));
        dest.writeString(this.videoImageUri);
        dest.writeString(this.imageFilterPath);
        dest.writeString(this.path);
        dest.writeString(this.uriPath);
        dest.writeString(this.cropUrl);
        dest.writeByte((byte)(this.isSelect ? 1 : 0));
        dest.writeByte((byte)(this.isPress ? 1 : 0));
        dest.writeInt(this.selectIndex);
        dest.writeInt(this.cropMode);
        dest.writeParcelable((Parcelable)this.cropRestoreInfo, flags);
        dest.writeByte((byte)(this.isOriginalImage ? 1 : 0));
    }

    public int describeContents() {
        return 0;
    }

    public Info getCropRestoreInfo() {
        return this.cropRestoreInfo;
    }

    public void setCropRestoreInfo(Info cropRestoreInfo) {
        this.cropRestoreInfo = cropRestoreInfo;
    }

    public String getVideoImageUri() {
        if (this.videoImageUri == null || this.videoImageUri.length() == 0) {
            return this.path;
        }
        return this.videoImageUri;
    }

    public void setVideoImageUri(String videoImageUri) {
        this.videoImageUri = videoImageUri;
    }

    public String getImageFilterPath() {
        if (this.imageFilterPath == null || this.imageFilterPath.length() == 0) {
            return this.path;
        }
        return this.imageFilterPath;
    }

    public void setImageFilterPath(String imageFilterPath) {
        this.imageFilterPath = imageFilterPath;
    }

    public boolean isOriginalImage() {
        return this.isOriginalImage;
    }

    public void setOriginalImage(boolean originalImage) {
        this.isOriginalImage = originalImage;
    }

    public String getLastImageFilterPath() {
        return this.imageFilterPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public String getDurationFormat() {
        return this.durationFormat;
    }

    public void setDurationFormat(String durationFormat) {
        this.durationFormat = durationFormat;
    }

    public void setVideo(boolean video) {
        this.isVideo = video;
    }

    public boolean isGif() {
        return MimeType.isGif(this.mimeType);
    }

    public boolean isLongImage() {
        return this.getWidthHeightRatio() > 5.0f || (double)this.getWidthHeightRatio() < 0.2;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public boolean isImage() {
        return !this.isVideo;
    }

    public int getCropMode() {
        return this.cropMode;
    }

    public void setCropMode(int cropMode) {
        this.cropMode = cropMode;
    }

    public String getCropUrl() {
        return this.cropUrl;
    }

    public void setCropUrl(String cropUrl) {
        this.cropUrl = cropUrl;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }

    public boolean isPress() {
        return this.isPress;
    }

    public void setPress(boolean press) {
        this.isPress = press;
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isUriPath() {
        return this.path != null && this.path.contains("content://");
    }

    public Uri getUri() {
        if (this.uriPath != null && this.uriPath.length() > 0) {
            return Uri.parse((String)this.uriPath);
        }
        if (this.isUriPath()) {
            return Uri.parse((String)this.path);
        }
        return PBitmapUtils.getContentUri(this.mimeType, this.id);
    }

    public float getWidthHeightRatio() {
        if (this.height == 0) {
            return 1.0f;
        }
        return (float)this.width * 1.0f / ((float)this.height * 1.0f);
    }

    public int getWidthHeightType() {
        if (this.getWidthHeightRatio() > 1.02f) {
            return 1;
        }
        if (this.getWidthHeightRatio() < 0.98f) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this.path == null) {
            return false;
        }
        try {
            ImageItem other = (ImageItem)o;
            if (other.path == null) {
                return false;
            }
            return this.path.equalsIgnoreCase(other.path);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return super.equals(o);
        }
    }

    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    public ImageItem copy() {
        ImageItem newItem = new ImageItem();
        newItem.path = this.path;
        newItem.isVideo = this.isVideo;
        newItem.duration = this.duration;
        newItem.height = this.height;
        newItem.width = this.width;
        newItem.cropMode = this.cropMode;
        newItem.cropUrl = this.cropUrl;
        newItem.durationFormat = this.durationFormat;
        newItem.id = this.id;
        newItem.isPress = false;
        newItem.isSelect = false;
        newItem.cropRestoreInfo = this.cropRestoreInfo;
        newItem.isOriginalImage = this.isOriginalImage;
        return newItem;
    }

    public boolean isOver2KImage() {
        return this.width > 3000 || this.height > 3000;
    }

    public boolean isEmpty() {
        return !(this.path != null && this.path.length() != 0 || this.uriPath != null && this.uriPath.length() != 0);
    }
}

