/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.adapter;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.PickerItemDisableCode;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.PickerItemView;
import java.util.ArrayList;
import java.util.List;

public class PickerItemAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    private static final int ITEM_TYPE_CAMERA = 0;
    private static final int ITEM_TYPE_NORMAL = 1;
    private List<ImageItem> images;
    private ArrayList<ImageItem> selectList;
    private BaseSelectConfig selectConfig;
    private IPickerPresenter presenter;
    private PickerUiConfig uiConfig;
    private boolean isPreformClick = false;
    private OnActionResult onActionResult;

    public PickerItemAdapter(ArrayList<ImageItem> selectList, List<ImageItem> images, BaseSelectConfig selectConfig, IPickerPresenter presenter, PickerUiConfig uiConfig) {
        this.images = images;
        this.selectList = selectList;
        this.selectConfig = selectConfig;
        this.presenter = presenter;
        this.uiConfig = uiConfig;
    }

    public void preformCheckItem(ImageItem imageItem) {
        if (this.onActionResult != null) {
            this.isPreformClick = true;
            this.onActionResult.onCheckItem(imageItem, 0);
        }
    }

    public void preformClickItem(ImageItem imageItem, int position) {
        if (this.onActionResult != null) {
            this.isPreformClick = true;
            this.onActionResult.onClickItem(imageItem, position, 0);
        }
    }

    @NonNull
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ItemViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picker_item_root, parent, false), viewType == 0, this.selectConfig, this.presenter, this.uiConfig);
    }

    public void onBindViewHolder(@NonNull ItemViewHolder viewHolder, final int position) {
        int itemViewType = this.getItemViewType(position);
        final ImageItem imageItem = this.getItem(position);
        if (itemViewType == 0 || imageItem == null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PickerItemAdapter.this.preformClickItem(null, -1);
                }
            });
            return;
        }
        PickerItemView pickerItemView = viewHolder.pickerItemView;
        int index = this.selectConfig.isShowCamera() ? position - 1 : position;
        pickerItemView.setPosition(index);
        pickerItemView.setAdapter(this);
        pickerItemView.initItem(imageItem, this.presenter, this.selectConfig);
        int indexOfSelectList = this.selectList.indexOf(imageItem);
        boolean isContainsThisItem = indexOfSelectList >= 0;
        final int finalDisableCode = PickerItemDisableCode.getItemDisableCode(imageItem, this.selectConfig, this.selectList, isContainsThisItem);
        if (pickerItemView.getCheckBoxView() != null) {
            pickerItemView.getCheckBoxView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PickerItemAdapter.this.onActionResult != null) {
                        PickerItemAdapter.this.isPreformClick = false;
                        PickerItemAdapter.this.onActionResult.onCheckItem(imageItem, finalDisableCode);
                    }
                }
            });
        }
        pickerItemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PickerItemAdapter.this.onActionResult != null) {
                    PickerItemAdapter.this.isPreformClick = false;
                    PickerItemAdapter.this.onActionResult.onClickItem(imageItem, position, finalDisableCode);
                }
            }
        });
        pickerItemView.enableItem(imageItem, indexOfSelectList >= 0, indexOfSelectList);
        if (finalDisableCode != 0) {
            pickerItemView.disableItem(imageItem, finalDisableCode);
        }
    }

    public int getItemViewType(int position) {
        if (this.selectConfig.isShowCamera()) {
            return position == 0 ? 0 : 1;
        }
        return 1;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.selectConfig.isShowCamera() ? this.images.size() + 1 : this.images.size();
    }

    private ImageItem getItem(int position) {
        if (this.selectConfig.isShowCamera()) {
            if (position == 0) {
                return null;
            }
            return this.images.get(position - 1);
        }
        return this.images.get(position);
    }

    public void refreshData(List<ImageItem> items) {
        if (items != null && items.size() > 0) {
            this.images = items;
        }
        this.notifyDataSetChanged();
    }

    public boolean isPreformClick() {
        return this.isPreformClick;
    }

    public void setOnActionResult(OnActionResult onActionResult) {
        this.onActionResult = onActionResult;
    }

    public static interface OnActionResult {
        public void onClickItem(ImageItem var1, int var2, int var3);

        public void onCheckItem(ImageItem var1, int var2);
    }

    static class ItemViewHolder
    extends RecyclerView.ViewHolder {
        private PickerItemView pickerItemView;
        private Context context;

        ItemViewHolder(@NonNull View itemView, boolean isCamera, BaseSelectConfig selectConfig, IPickerPresenter presenter, PickerUiConfig uiConfig) {
            super(itemView);
            this.context = itemView.getContext();
            FrameLayout layout2 = (FrameLayout)itemView.findViewById(R.id.mRoot);
            int width = (this.getScreenWidth() - this.dp(2)) / selectConfig.getColumnCount();
            PViewSizeUtils.setViewSize((View)layout2, width, 1.0f);
            this.pickerItemView = uiConfig.getPickerUiProvider().getItemView(this.context);
            layout2.removeAllViews();
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.bottomMargin = this.dp(1);
            params.topMargin = this.dp(1);
            params.rightMargin = this.dp(1);
            params.leftMargin = this.dp(1);
            if (isCamera) {
                layout2.addView(this.pickerItemView.getCameraView(selectConfig, presenter), (ViewGroup.LayoutParams)params);
            } else {
                layout2.addView((View)this.pickerItemView, (ViewGroup.LayoutParams)params);
            }
        }

        int getScreenWidth() {
            WindowManager wm = (WindowManager)this.context.getSystemService("window");
            DisplayMetrics outMetrics = new DisplayMetrics();
            assert (wm != null);
            wm.getDefaultDisplay().getMetrics(outMetrics);
            return outMetrics.widthPixels;
        }

        int dp(int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        }
    }
}

