/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.PickerFolderItemView;
import com.ypx.imagepicker.views.wx.WXFolderItemView;
import java.util.ArrayList;
import java.util.List;

public class PickerFolderAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<ImageSet> mImageSets = new ArrayList<ImageSet>();
    private IPickerPresenter presenter;
    private PickerUiConfig uiConfig;
    private FolderSelectResult folderSelectResult;

    public PickerFolderAdapter(IPickerPresenter presenter, PickerUiConfig uiConfig) {
        this.presenter = presenter;
        this.uiConfig = uiConfig;
    }

    public void refreshData(List<ImageSet> folders) {
        this.mImageSets.clear();
        this.mImageSets.addAll(folders);
        this.notifyDataSetChanged();
    }

    private ImageSet getItem(int i) {
        return this.mImageSets.get(i);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picker_item_root, parent, false);
        return new ViewHolder(view, this.uiConfig);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, final int position) {
        ImageSet imageSet = this.getItem(position);
        PickerFolderItemView pickerFolderItemView = holder.pickerFolderItemView;
        pickerFolderItemView.displayCoverImage(imageSet, this.presenter);
        pickerFolderItemView.loadItem(imageSet);
        pickerFolderItemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PickerFolderAdapter.this.folderSelectResult != null) {
                    PickerFolderAdapter.this.folderSelectResult.folderSelected(PickerFolderAdapter.this.getItem(position), position);
                }
            }
        });
    }

    public long getItemId(int i) {
        return i;
    }

    public int getItemCount() {
        return this.mImageSets.size();
    }

    public void setFolderSelectResult(FolderSelectResult folderSelectResult) {
        this.folderSelectResult = folderSelectResult;
    }

    public static interface FolderSelectResult {
        public void folderSelected(ImageSet var1, int var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private PickerFolderItemView pickerFolderItemView;

        ViewHolder(View view, PickerUiConfig uiConfig) {
            super(view);
            this.pickerFolderItemView = uiConfig.getPickerUiProvider().getFolderItemView(view.getContext());
            if (this.pickerFolderItemView == null) {
                this.pickerFolderItemView = new WXFolderItemView(view.getContext());
            }
            FrameLayout layout2 = (FrameLayout)this.itemView.findViewById(R.id.mRoot);
            int height = this.pickerFolderItemView.getItemHeight();
            layout2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, height > 0 ? height : -2));
            layout2.removeAllViews();
            layout2.addView((View)this.pickerFolderItemView);
        }
    }
}

