/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.activity.preview.MultiImagePreviewActivity;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.helper.recyclerviewitemhelper.ItemTouchHelperAdapter;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.widget.ShowTypeImageView;
import java.util.ArrayList;
import java.util.Collections;

public class MultiPreviewAdapter
extends RecyclerView.Adapter<ViewHolder>
implements ItemTouchHelperAdapter {
    private ArrayList<ImageItem> previewList;
    private Context context;
    private IPickerPresenter presenter;
    private ImageItem previewImageItem;

    public void setPreviewImageItem(ImageItem previewImageItem) {
        this.previewImageItem = previewImageItem;
        this.notifyDataSetChanged();
    }

    public MultiPreviewAdapter(ArrayList<ImageItem> previewList, IPickerPresenter presenter) {
        this.previewList = previewList;
        this.presenter = presenter;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        ShowTypeImageView imageView = new ShowTypeImageView(this.context);
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(this.dp(60.0f), this.dp(60.0f));
        params.leftMargin = this.dp(8.0f);
        params.rightMargin = this.dp(8.0f);
        params.topMargin = this.dp(15.0f);
        params.bottomMargin = this.dp(15.0f);
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        return new ViewHolder((View)imageView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final ImageItem imageItem = this.previewList.get(position);
        boolean isSelect = this.previewImageItem != null && this.previewImageItem.equals(imageItem);
        holder.imageView.setSelect(isSelect, ImagePicker.getThemeColor());
        holder.imageView.setTypeFromImage(imageItem);
        holder.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultiPreviewAdapter.this.context instanceof MultiImagePreviewActivity) {
                    ((MultiImagePreviewActivity)MultiPreviewAdapter.this.context).onPreviewItemClick(imageItem);
                }
            }
        });
        this.presenter.displayImage((View)holder.imageView, imageItem, 0, true);
    }

    public int getItemCount() {
        return this.previewList.size();
    }

    public int dp(float dp) {
        if (this.context == null) {
            return 0;
        }
        float density = this.context.getResources().getDisplayMetrics().density;
        return (int)((double)(dp * density) + 0.5);
    }

    @Override
    public boolean onItemMove(int fromPosition, int toPosition) {
        try {
            if (null == this.previewList || fromPosition >= this.previewList.size() || toPosition >= this.previewList.size()) {
                return true;
            }
            Collections.swap(this.previewList, fromPosition, toPosition);
            this.notifyItemMoved(fromPosition, toPosition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void onItemDismiss(int position) {
    }

    @Override
    public boolean isItemViewSwipeEnabled() {
        return false;
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ShowTypeImageView imageView;

        ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.imageView = (ShowTypeImageView)itemView;
        }
    }
}

