/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.singlecrop;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PickerActivityManager;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.CropConfig;
import com.ypx.imagepicker.bean.selectconfig.CropConfigParcelable;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.data.PickerActivityCallBack;
import com.ypx.imagepicker.data.ProgressSceneEnum;
import com.ypx.imagepicker.helper.DetailImageLoadHelper;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.helper.launcher.PLauncher;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.SingleCropControllerView;
import com.ypx.imagepicker.widget.cropimage.CropImageView;
import java.io.Serializable;
import java.util.ArrayList;

public class SingleCropActivity
extends FragmentActivity {
    public static final String INTENT_KEY_CURRENT_IMAGE_ITEM = "currentImageItem";
    private CropImageView cropView;
    private CropConfigParcelable cropConfig;
    private IPickerPresenter presenter;
    private ImageItem currentImageItem;
    private DialogInterface dialogInterface;

    public static void intentCrop(Activity activity, IPickerPresenter presenter, CropConfig cropConfig, String path, OnImagePickCompleteListener listener) {
        SingleCropActivity.intentCrop(activity, presenter, cropConfig, ImageItem.withPath((Context)activity, path), listener);
    }

    public static void intentCrop(Activity activity, IPickerPresenter presenter, CropConfig cropConfig, ImageItem item, OnImagePickCompleteListener listener) {
        Intent intent = new Intent((Context)activity, SingleCropActivity.class);
        intent.putExtra("IPickerPresenter", (Serializable)presenter);
        intent.putExtra("MultiSelectConfig", (Parcelable)cropConfig.getCropInfo());
        intent.putExtra(INTENT_KEY_CURRENT_IMAGE_ITEM, (Parcelable)item);
        PLauncher.init(activity).startActivityForResult(intent, (PLauncher.Callback)PickerActivityCallBack.create(listener));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.PRESENTER_NOT_FOUND.getCode());
            return;
        }
        this.presenter = (IPickerPresenter)this.getIntent().getSerializableExtra("IPickerPresenter");
        this.cropConfig = (CropConfigParcelable)this.getIntent().getParcelableExtra("MultiSelectConfig");
        if (this.presenter == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.PRESENTER_NOT_FOUND.getCode());
            return;
        }
        if (this.cropConfig == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
            return;
        }
        this.currentImageItem = (ImageItem)this.getIntent().getParcelableExtra(INTENT_KEY_CURRENT_IMAGE_ITEM);
        if (this.currentImageItem == null || this.currentImageItem.isEmpty()) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.CROP_URL_NOT_FOUND.getCode());
            return;
        }
        PickerActivityManager.addActivity((Activity)this);
        this.setContentView(this.cropConfig.isSingleCropCutNeedTop() ? R.layout.picker_activity_crop_cover : R.layout.picker_activity_crop);
        this.cropView = (CropImageView)this.findViewById(R.id.cropView);
        this.cropView.setMaxScale(7.0f);
        this.cropView.setRotateEnable(false);
        this.cropView.enable();
        this.cropView.setBounceEnable(!this.cropConfig.isGap());
        this.cropView.setCropMargin(this.cropConfig.getCropRectMargin());
        this.cropView.setCircle(this.cropConfig.isCircle());
        this.cropView.setCropRatio(this.cropConfig.getCropRatioX(), this.cropConfig.getCropRatioY());
        if (this.cropConfig.getCropRestoreInfo() != null) {
            this.cropView.setRestoreInfo(this.cropConfig.getCropRestoreInfo());
        }
        DetailImageLoadHelper.displayDetailImage(true, this.cropView, this.presenter, this.currentImageItem);
        this.setControllerView();
    }

    private void setControllerView() {
        FrameLayout mCropPanel = (FrameLayout)this.findViewById(R.id.mCropPanel);
        PickerUiConfig uiConfig = this.presenter.getUiConfig((Context)this);
        this.findViewById(R.id.mRoot).setBackgroundColor(uiConfig.getSingleCropBackgroundColor());
        SingleCropControllerView cropControllerView = uiConfig.getPickerUiProvider().getSingleCropControllerView((Context)this);
        mCropPanel.addView((View)cropControllerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        cropControllerView.setStatusBar();
        cropControllerView.setCropViewParams(this.cropView, (ViewGroup.MarginLayoutParams)this.cropView.getLayoutParams());
        cropControllerView.getCompleteView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PViewSizeUtils.onDoubleClick()) {
                    return;
                }
                SingleCropActivity.this.generateCropFile("crop_" + System.currentTimeMillis());
            }
        });
    }

    private void cropComplete(String cropUrl) {
        if (this.cropView.isEditing()) {
            return;
        }
        if (cropUrl == null || cropUrl.length() == 0 || cropUrl.startsWith("Exception:")) {
            this.presenter.tip((Context)this, this.getString(R.string.picker_str_tip_singleCrop_error));
            this.cropView.setCropRatio(this.cropConfig.getCropRatioX(), this.cropConfig.getCropRatioY());
            return;
        }
        this.currentImageItem.mimeType = this.cropConfig.isNeedPng() ? MimeType.PNG.toString() : MimeType.JPEG.toString();
        this.currentImageItem.width = this.cropView.getCropWidth();
        this.currentImageItem.height = this.cropView.getCropHeight();
        this.currentImageItem.setCropUrl(cropUrl);
        this.currentImageItem.setCropRestoreInfo(this.cropView.getInfo());
        this.notifyOnImagePickComplete(this.currentImageItem);
    }

    public void generateCropFile(final String fileName) {
        this.dialogInterface = this.presenter.showProgressDialog((Activity)this, ProgressSceneEnum.crop);
        if (this.cropConfig.isGap() && !this.cropConfig.isCircle()) {
            this.cropView.setBackgroundColor(this.cropConfig.getCropGapBackgroundColor());
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = SingleCropActivity.this.cropConfig.isGap() ? SingleCropActivity.this.cropView.generateCropBitmapFromView(SingleCropActivity.this.cropConfig.getCropGapBackgroundColor()) : SingleCropActivity.this.cropView.generateCropBitmap();
                final String url = SingleCropActivity.this.saveBitmapToFile(bitmap, fileName);
                SingleCropActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SingleCropActivity.this.dialogInterface != null) {
                            SingleCropActivity.this.dialogInterface.dismiss();
                        }
                        SingleCropActivity.this.cropComplete(url);
                    }
                });
            }
        }).start();
    }

    private String saveBitmapToFile(Bitmap bitmap, String fileName) {
        Bitmap.CompressFormat format = this.cropConfig.isNeedPng() ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
        String cropUrl = this.cropConfig.isSaveInDCIM() ? PBitmapUtils.saveBitmapToDCIM((Context)this, bitmap, fileName, format).toString() : PBitmapUtils.saveBitmapToFile((Context)this, bitmap, fileName, format);
        return cropUrl;
    }

    private void notifyOnImagePickComplete(ImageItem imageItem) {
        ArrayList<ImageItem> list = new ArrayList<ImageItem>();
        list.add(imageItem);
        Intent intent = new Intent();
        intent.putExtra("pickerResult", list);
        this.setResult(1433, intent);
        this.finish();
    }

    public void finish() {
        super.finish();
        if (this.dialogInterface != null) {
            this.dialogInterface.dismiss();
        }
        PickerActivityManager.removeActivity((Activity)this);
    }
}

