/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.preview;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PickerActivityManager;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.data.MediaItemsDataSource;
import com.ypx.imagepicker.data.ProgressSceneEnum;
import com.ypx.imagepicker.helper.launcher.PLauncher;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.PreviewControllerView;
import com.ypx.imagepicker.views.wx.WXPreviewControllerView;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class MultiImagePreviewActivity
extends FragmentActivity
implements MediaItemsDataSource.MediaItemProvider {
    static ImageSet currentImageSet;
    public static final String INTENT_KEY_SELECT_LIST = "selectList";
    private ViewPager mViewPager;
    private ArrayList<ImageItem> mSelectList;
    private ArrayList<ImageItem> mImageList;
    private int mCurrentItemPosition = 0;
    private MultiSelectConfig selectConfig;
    private IPickerPresenter presenter;
    private PickerUiConfig uiConfig;
    private WeakReference<Activity> activityWeakReference;
    private DialogInterface dialogInterface;
    private PreviewControllerView controllerView;

    public static void intent(Activity activity, ImageSet imageSet, ArrayList<ImageItem> selectList, MultiSelectConfig selectConfig, IPickerPresenter presenter, int position, final PreviewResult result) {
        if (activity == null || selectList == null || selectConfig == null || presenter == null || result == null) {
            return;
        }
        if (imageSet != null) {
            currentImageSet = imageSet.copy();
        }
        Intent intent = new Intent((Context)activity, MultiImagePreviewActivity.class);
        intent.putExtra(INTENT_KEY_SELECT_LIST, selectList);
        intent.putExtra("MultiSelectConfig", (Serializable)selectConfig);
        intent.putExtra("IPickerPresenter", (Serializable)presenter);
        intent.putExtra("currentIndex", position);
        PLauncher.init(activity).startActivityForResult(intent, new PLauncher.Callback(){

            @Override
            public void onActivityResult(int resultCode, Intent data) {
                ArrayList mList;
                if (data != null && data.hasExtra("pickerResult") && (mList = (ArrayList)data.getSerializableExtra("pickerResult")) != null) {
                    result.onResult(mList, resultCode == 0);
                }
            }
        });
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.activityWeakReference = new WeakReference<MultiImagePreviewActivity>(this);
        if (this.isIntentDataFailed()) {
            this.finish();
            return;
        }
        PickerActivityManager.addActivity((Activity)this);
        this.setContentView(R.layout.picker_activity_preview);
        this.setUI();
        this.loadMediaPreviewList();
    }

    private boolean isIntentDataFailed() {
        if (this.getIntent() == null || !this.getIntent().hasExtra("MultiSelectConfig") || !this.getIntent().hasExtra("IPickerPresenter")) {
            return true;
        }
        this.selectConfig = (MultiSelectConfig)this.getIntent().getSerializableExtra("MultiSelectConfig");
        this.presenter = (IPickerPresenter)this.getIntent().getSerializableExtra("IPickerPresenter");
        this.mCurrentItemPosition = this.getIntent().getIntExtra("currentIndex", 0);
        ArrayList list = (ArrayList)this.getIntent().getSerializableExtra(INTENT_KEY_SELECT_LIST);
        if (list == null || this.presenter == null) {
            return true;
        }
        this.mSelectList = new ArrayList(list);
        this.uiConfig = this.presenter.getUiConfig((Context)this.activityWeakReference.get());
        return false;
    }

    private void notifyCallBack(boolean isClickComplete) {
        Intent intent = new Intent();
        intent.putExtra("pickerResult", this.mSelectList);
        this.setResult(isClickComplete ? 1433 : 0, intent);
        this.finish();
    }

    public void onBackPressed() {
        this.notifyCallBack(false);
    }

    private void loadMediaPreviewList() {
        if (currentImageSet == null) {
            this.initViewPager(this.mSelectList);
        } else if (MultiImagePreviewActivity.currentImageSet.imageItems != null && MultiImagePreviewActivity.currentImageSet.imageItems.size() > 0 && MultiImagePreviewActivity.currentImageSet.imageItems.size() >= MultiImagePreviewActivity.currentImageSet.count) {
            this.initViewPager(MultiImagePreviewActivity.currentImageSet.imageItems);
        } else {
            this.dialogInterface = this.getPresenter().showProgressDialog((Activity)this, ProgressSceneEnum.loadMediaItem);
            ImagePicker.provideMediaItemsFromSet(this, currentImageSet, this.selectConfig.getMimeTypes(), this);
        }
    }

    @Override
    public void providerMediaItems(ArrayList<ImageItem> imageItems, ImageSet allVideoSet) {
        if (this.dialogInterface != null) {
            this.dialogInterface.dismiss();
        }
        this.initViewPager(imageItems);
    }

    private ArrayList<ImageItem> filterVideo(ArrayList<ImageItem> list) {
        if (this.selectConfig.isCanPreviewVideo()) {
            this.mImageList = new ArrayList<ImageItem>(list);
            return this.mImageList;
        }
        this.mImageList = new ArrayList();
        int videoCount = 0;
        int nowPosition = 0;
        int i = 0;
        for (ImageItem imageItem : list) {
            if (!imageItem.isVideo() && !imageItem.isGif()) {
                this.mImageList.add(imageItem);
            } else {
                ++videoCount;
            }
            if (i == this.mCurrentItemPosition) {
                nowPosition = i - videoCount;
            }
            ++i;
        }
        this.mCurrentItemPosition = nowPosition;
        return this.mImageList;
    }

    private void setUI() {
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.mViewPager.setBackgroundColor(this.uiConfig.getPreviewBackgroundColor());
        this.controllerView = this.uiConfig.getPickerUiProvider().getPreviewControllerView((Context)this.activityWeakReference.get());
        if (this.controllerView == null) {
            this.controllerView = new WXPreviewControllerView((Context)this);
        }
        this.controllerView.setStatusBar();
        this.controllerView.initData(this.selectConfig, this.presenter, this.uiConfig, this.mSelectList);
        if (this.controllerView.getCompleteView() != null) {
            this.controllerView.getCompleteView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PViewSizeUtils.onDoubleClick()) {
                        return;
                    }
                    MultiImagePreviewActivity.this.notifyCallBack(true);
                }
            });
        }
        FrameLayout mPreviewPanel = (FrameLayout)this.findViewById(R.id.mPreviewPanel);
        mPreviewPanel.addView((View)this.controllerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void initViewPager(ArrayList<ImageItem> sourceList) {
        this.mImageList = this.filterVideo(sourceList);
        if (this.mImageList == null || this.mImageList.size() == 0) {
            this.getPresenter().tip((Context)this, this.getString(R.string.picker_str_preview_empty));
            this.finish();
            return;
        }
        if (this.mCurrentItemPosition < 0) {
            this.mCurrentItemPosition = 0;
        }
        TouchImageAdapter mAdapter = new TouchImageAdapter(this.getSupportFragmentManager(), this.mImageList);
        this.mViewPager.setAdapter((PagerAdapter)mAdapter);
        this.mViewPager.setOffscreenPageLimit(1);
        this.mViewPager.setCurrentItem(this.mCurrentItemPosition, false);
        ImageItem item = this.mImageList.get(this.mCurrentItemPosition);
        this.controllerView.onPageSelected(this.mCurrentItemPosition, item, this.mImageList.size());
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                MultiImagePreviewActivity.this.mCurrentItemPosition = position;
                ImageItem item = (ImageItem)MultiImagePreviewActivity.this.mImageList.get(MultiImagePreviewActivity.this.mCurrentItemPosition);
                MultiImagePreviewActivity.this.controllerView.onPageSelected(MultiImagePreviewActivity.this.mCurrentItemPosition, item, MultiImagePreviewActivity.this.mImageList.size());
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onPreviewItemClick(ImageItem imageItem) {
        this.mViewPager.setCurrentItem(this.mImageList.indexOf(imageItem), false);
    }

    public IPickerPresenter getPresenter() {
        return this.presenter;
    }

    public PreviewControllerView getControllerView() {
        return this.controllerView;
    }

    public void finish() {
        super.finish();
        PickerActivityManager.removeActivity((Activity)this);
        if (currentImageSet != null && MultiImagePreviewActivity.currentImageSet.imageItems != null) {
            MultiImagePreviewActivity.currentImageSet.imageItems.clear();
            currentImageSet = null;
        }
    }

    public static class SinglePreviewFragment
    extends Fragment {
        static final String KEY_URL = "key_url";
        private ImageItem imageItem;

        static SinglePreviewFragment newInstance(ImageItem imageItem) {
            SinglePreviewFragment fragment = new SinglePreviewFragment();
            Bundle bundle = new Bundle();
            bundle.putSerializable(KEY_URL, (Serializable)imageItem);
            fragment.setArguments(bundle);
            return fragment;
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            Bundle bundle = this.getArguments();
            if (bundle == null) {
                return;
            }
            this.imageItem = (ImageItem)bundle.getSerializable(KEY_URL);
        }

        PreviewControllerView getControllerView() {
            return ((MultiImagePreviewActivity)this.getActivity()).getControllerView();
        }

        IPickerPresenter getPresenter() {
            return ((MultiImagePreviewActivity)this.getActivity()).getPresenter();
        }

        @Nullable
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return this.getControllerView().getItemView(this, this.imageItem, this.getPresenter());
        }
    }

    static class TouchImageAdapter
    extends FragmentStatePagerAdapter {
        private ArrayList<ImageItem> imageItems;

        TouchImageAdapter(FragmentManager fm, ArrayList<ImageItem> imageItems) {
            super(fm, 1);
            this.imageItems = imageItems;
            if (this.imageItems == null) {
                this.imageItems = new ArrayList();
            }
        }

        public int getCount() {
            return this.imageItems.size();
        }

        @NonNull
        public Fragment getItem(int position) {
            return SinglePreviewFragment.newInstance(this.imageItems.get(position));
        }
    }

    public static interface PreviewResult {
        public void onResult(ArrayList<ImageItem> var1, boolean var2);
    }
}

