/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.multi;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PBaseLoaderFragment;
import com.ypx.imagepicker.activity.preview.MultiImagePreviewActivity;
import com.ypx.imagepicker.adapter.PickerFolderAdapter;
import com.ypx.imagepicker.adapter.PickerItemAdapter;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.bean.selectconfig.CropConfig;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.data.IReloadExecutor;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.views.PickerUiConfig;
import java.util.ArrayList;
import java.util.List;

public class MultiImagePickerFragment
extends PBaseLoaderFragment
implements View.OnClickListener,
PickerItemAdapter.OnActionResult,
IReloadExecutor {
    private List<ImageSet> imageSets = new ArrayList<ImageSet>();
    private ArrayList<ImageItem> imageItems = new ArrayList();
    private RecyclerView mRecyclerView;
    private View v_masker;
    private TextView mTvTime;
    private PickerFolderAdapter mImageSetAdapter;
    private RecyclerView mFolderListRecyclerView;
    private PickerItemAdapter mAdapter;
    private ImageSet currentImageSet;
    private FrameLayout titleBarContainer;
    private FrameLayout bottomBarContainer;
    private MultiSelectConfig selectConfig;
    private IPickerPresenter presenter;
    private PickerUiConfig uiConfig;
    private FragmentActivity mContext;
    private GridLayoutManager layoutManager;
    private View view;
    private OnImagePickCompleteListener onImagePickCompleteListener;
    private RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 0) {
                if (MultiImagePickerFragment.this.mTvTime.getVisibility() == 0) {
                    MultiImagePickerFragment.this.mTvTime.setVisibility(8);
                    MultiImagePickerFragment.this.mTvTime.startAnimation(AnimationUtils.loadAnimation((Context)MultiImagePickerFragment.this.mContext, (int)R.anim.picker_fade_out));
                }
            } else if (MultiImagePickerFragment.this.mTvTime.getVisibility() == 8) {
                MultiImagePickerFragment.this.mTvTime.setVisibility(0);
                MultiImagePickerFragment.this.mTvTime.startAnimation(AnimationUtils.loadAnimation((Context)MultiImagePickerFragment.this.mContext, (int)R.anim.picker_fade_in));
            }
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (MultiImagePickerFragment.this.imageItems != null) {
                try {
                    MultiImagePickerFragment.this.mTvTime.setText((CharSequence)((ImageItem)MultiImagePickerFragment.this.imageItems.get(MultiImagePickerFragment.this.layoutManager.findFirstVisibleItemPosition())).getTimeFormat());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.picker_activity_multipick, container, false);
        return this.view;
    }

    private boolean isIntentDataValid() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.selectConfig = (MultiSelectConfig)bundle.getSerializable("MultiSelectConfig");
            this.presenter = (IPickerPresenter)bundle.getSerializable("IPickerPresenter");
            if (this.presenter == null) {
                PickerErrorExecutor.executeError(this.onImagePickCompleteListener, PickerError.PRESENTER_NOT_FOUND.getCode());
                return false;
            }
            if (this.selectConfig == null) {
                PickerErrorExecutor.executeError(this.onImagePickCompleteListener, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
                return false;
            }
            return true;
        }
        return false;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mContext = this.getActivity();
        if (this.isIntentDataValid()) {
            ImagePicker.isOriginalImage = this.selectConfig.isDefaultOriginal();
            this.uiConfig = this.presenter.getUiConfig((Context)this.getWeakActivity());
            this.setStatusBar();
            this.findView();
            if (this.selectConfig.getLastImageList() != null) {
                this.selectList.addAll(this.selectConfig.getLastImageList());
            }
            this.loadMediaSets();
            this.refreshCompleteState();
        }
    }

    public void setOnImagePickCompleteListener(@NonNull OnImagePickCompleteListener onImagePickCompleteListener) {
        this.onImagePickCompleteListener = onImagePickCompleteListener;
    }

    private void findView() {
        this.v_masker = this.view.findViewById(R.id.v_masker);
        this.mRecyclerView = (RecyclerView)this.view.findViewById(R.id.mRecyclerView);
        this.mFolderListRecyclerView = (RecyclerView)this.view.findViewById(R.id.mSetRecyclerView);
        this.mTvTime = (TextView)this.view.findViewById(R.id.tv_time);
        this.mTvTime.setVisibility(8);
        this.titleBarContainer = (FrameLayout)this.view.findViewById(R.id.titleBarContainer);
        this.bottomBarContainer = (FrameLayout)this.view.findViewById(R.id.bottomBarContainer);
        this.initAdapters();
        this.initUI();
        this.setListener();
        this.refreshCompleteState();
    }

    private void initUI() {
        this.mRecyclerView.setBackgroundColor(this.uiConfig.getPickerBackgroundColor());
        this.titleBar = this.inflateControllerView((ViewGroup)this.titleBarContainer, true, this.uiConfig);
        this.bottomBar = this.inflateControllerView((ViewGroup)this.bottomBarContainer, false, this.uiConfig);
        this.setFolderListHeight(this.mFolderListRecyclerView, this.v_masker, false);
    }

    private void setListener() {
        this.v_masker.setOnClickListener((View.OnClickListener)this);
        this.mRecyclerView.addOnScrollListener(this.onScrollListener);
        this.mImageSetAdapter.setFolderSelectResult(new PickerFolderAdapter.FolderSelectResult(){

            @Override
            public void folderSelected(ImageSet set, int pos) {
                MultiImagePickerFragment.this.selectImageFromSet(pos, true);
            }
        });
    }

    private void initAdapters() {
        this.mFolderListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mImageSetAdapter = new PickerFolderAdapter(this.presenter, this.uiConfig);
        this.mFolderListRecyclerView.setAdapter((RecyclerView.Adapter)this.mImageSetAdapter);
        this.mImageSetAdapter.refreshData(this.imageSets);
        this.mAdapter = new PickerItemAdapter(this.selectList, new ArrayList<ImageItem>(), this.selectConfig, this.presenter, this.uiConfig);
        this.mAdapter.setHasStableIds(true);
        this.mAdapter.setOnActionResult(this);
        this.layoutManager = new GridLayoutManager((Context)this.mContext, this.selectConfig.getColumnCount());
        if (this.mRecyclerView.getItemAnimator() instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
            this.mRecyclerView.getItemAnimator().setChangeDuration(0L);
        }
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    private void selectImageFromSet(int position, boolean isTransit) {
        this.currentImageSet = this.imageSets.get(position);
        if (isTransit) {
            this.toggleFolderList();
        }
        for (ImageSet set1 : this.imageSets) {
            set1.isSelected = false;
        }
        this.currentImageSet.isSelected = true;
        this.mImageSetAdapter.notifyDataSetChanged();
        if (this.currentImageSet.isAllMedia()) {
            if (this.selectConfig.isShowCameraInAllMedia()) {
                this.selectConfig.setShowCamera(true);
            }
        } else if (this.selectConfig.isShowCameraInAllMedia()) {
            this.selectConfig.setShowCamera(false);
        }
        this.loadMediaItemsFromSet(this.currentImageSet);
    }

    @Override
    protected void toggleFolderList() {
        if (this.mFolderListRecyclerView.getVisibility() == 8) {
            this.controllerViewOnTransitImageSet(true);
            this.v_masker.setVisibility(0);
            this.mFolderListRecyclerView.setVisibility(0);
            this.mFolderListRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.mContext, (int)(this.uiConfig.isShowFromBottom() ? R.anim.picker_show2bottom : R.anim.picker_anim_in)));
        } else {
            this.controllerViewOnTransitImageSet(false);
            this.v_masker.setVisibility(8);
            this.mFolderListRecyclerView.setVisibility(8);
            this.mFolderListRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.mContext, (int)(this.uiConfig.isShowFromBottom() ? R.anim.picker_hide2bottom : R.anim.picker_anim_up)));
        }
    }

    public void onClick(@NonNull View v) {
        if (this.onDoubleClick()) {
            return;
        }
        if (v == this.v_masker) {
            this.toggleFolderList();
        }
    }

    @Override
    protected void loadMediaSetsComplete(@Nullable List<ImageSet> imageSetList) {
        if (imageSetList == null || imageSetList.size() == 0 || imageSetList.size() == 1 && imageSetList.get((int)0).count == 0) {
            this.tip(this.getString(R.string.picker_str_tip_media_empty));
            return;
        }
        this.imageSets = imageSetList;
        this.mImageSetAdapter.refreshData(this.imageSets);
        this.selectImageFromSet(0, false);
    }

    @Override
    protected void loadMediaItemsComplete(ImageSet set) {
        this.imageItems = set.imageItems;
        this.controllerViewOnImageSetSelected(set);
        this.mAdapter.refreshData(this.imageItems);
    }

    @Override
    protected void refreshAllVideoSet(ImageSet allVideoSet) {
        if (allVideoSet != null && allVideoSet.imageItems != null && allVideoSet.imageItems.size() > 0 && !this.imageSets.contains(allVideoSet)) {
            this.imageSets.add(1, allVideoSet);
            this.mImageSetAdapter.refreshData(this.imageSets);
        }
    }

    @Override
    public void onTakePhotoResult(@NonNull ImageItem imageItem) {
        if (this.selectConfig.getSelectMode() == 3) {
            this.intentCrop(imageItem);
            return;
        }
        if (this.selectConfig.getSelectMode() == 0) {
            this.notifyOnSingleImagePickComplete(imageItem);
            return;
        }
        this.addItemInImageSets(this.imageSets, this.imageItems, imageItem);
        this.mAdapter.refreshData(this.imageItems);
        this.mImageSetAdapter.refreshData(this.imageSets);
        this.onCheckItem(imageItem, 0);
    }

    @Override
    public boolean onBackPressed() {
        if (this.mFolderListRecyclerView != null && this.mFolderListRecyclerView.getVisibility() == 0) {
            this.toggleFolderList();
            return true;
        }
        if (this.presenter != null && this.presenter.interceptPickerCancel(this.getWeakActivity(), this.selectList)) {
            return true;
        }
        PickerErrorExecutor.executeError(this.onImagePickCompleteListener, PickerError.CANCEL.getCode());
        return false;
    }

    @Override
    public void onClickItem(@NonNull ImageItem item, int position, int disableItemCode) {
        int n = position = this.selectConfig.isShowCamera() ? position - 1 : position;
        if (position < 0 && this.selectConfig.isShowCamera()) {
            if (!this.presenter.interceptCameraClick(this.getWeakActivity(), this)) {
                this.checkTakePhotoOrVideo();
            }
            return;
        }
        if (this.interceptClickDisableItem(disableItemCode, false)) {
            return;
        }
        this.mRecyclerView.setTag((Object)item);
        if (this.selectConfig.getSelectMode() == 3) {
            if (item.isGif() || item.isVideo()) {
                this.notifyOnSingleImagePickComplete(item);
            } else {
                this.intentCrop(item);
            }
            return;
        }
        if (!this.mAdapter.isPreformClick() && this.presenter.interceptItemClick(this.getWeakActivity(), item, this.selectList, this.imageItems, this.selectConfig, this.mAdapter, false, this)) {
            return;
        }
        if (item.isVideo() && this.selectConfig.isVideoSinglePickAndAutoComplete()) {
            this.notifyOnSingleImagePickComplete(item);
            return;
        }
        if (this.selectConfig.getMaxCount() <= 1 && this.selectConfig.isSinglePickAutoComplete()) {
            this.notifyOnSingleImagePickComplete(item);
            return;
        }
        if (item.isVideo() && !this.selectConfig.isCanPreviewVideo()) {
            this.tip(this.getActivity().getString(R.string.picker_str_tip_cant_preview_video));
            return;
        }
        if (this.selectConfig.isPreview()) {
            this.intentPreview(true, position);
        }
    }

    @Override
    public void onCheckItem(ImageItem imageItem, int disableItemCode) {
        if (this.selectConfig.getSelectMode() == 0 && this.selectConfig.getMaxCount() == 1 && this.selectList != null && this.selectList.size() > 0) {
            if (this.selectList.contains(imageItem)) {
                this.selectList.clear();
            } else {
                this.selectList.clear();
                this.selectList.add(imageItem);
            }
        } else {
            if (this.interceptClickDisableItem(disableItemCode, true)) {
                return;
            }
            if (!this.mAdapter.isPreformClick() && this.presenter.interceptItemClick(this.getWeakActivity(), imageItem, this.selectList, this.imageItems, this.selectConfig, this.mAdapter, true, this)) {
                return;
            }
            if (this.selectList.contains(imageItem)) {
                this.selectList.remove(imageItem);
            } else {
                this.selectList.add(imageItem);
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.refreshCompleteState();
    }

    private void intentCrop(ImageItem imageItem) {
        ImagePicker.crop((Activity)this.getActivity(), this.presenter, (CropConfig)this.selectConfig, imageItem, new OnImagePickCompleteListener(){

            @Override
            public void onImagePickComplete(ArrayList<ImageItem> items) {
                MultiImagePickerFragment.this.selectList.clear();
                MultiImagePickerFragment.this.selectList.addAll(items);
                MultiImagePickerFragment.this.mAdapter.notifyDataSetChanged();
                MultiImagePickerFragment.this.notifyPickerComplete();
            }
        });
    }

    @Override
    protected void intentPreview(boolean isClickItem, int position) {
        if (!(isClickItem || this.selectList != null && this.selectList.size() != 0)) {
            return;
        }
        MultiImagePreviewActivity.intent((Activity)this.getActivity(), isClickItem ? this.currentImageSet : null, this.selectList, this.selectConfig, this.presenter, position, new MultiImagePreviewActivity.PreviewResult(){

            @Override
            public void onResult(ArrayList<ImageItem> mImageItems, boolean isCancel) {
                if (isCancel) {
                    MultiImagePickerFragment.this.reloadPickerWithList(mImageItems);
                } else {
                    MultiImagePickerFragment.this.selectList.clear();
                    MultiImagePickerFragment.this.selectList.addAll(mImageItems);
                    MultiImagePickerFragment.this.mAdapter.notifyDataSetChanged();
                    MultiImagePickerFragment.this.notifyPickerComplete();
                }
            }
        });
    }

    @Override
    protected void notifyPickerComplete() {
        if (this.presenter == null || this.presenter.interceptPickerCompleteClick(this.getWeakActivity(), this.selectList, this.selectConfig)) {
            return;
        }
        if (this.onImagePickCompleteListener != null) {
            for (ImageItem imageItem : this.selectList) {
                imageItem.isOriginalImage = ImagePicker.isOriginalImage;
            }
            this.onImagePickCompleteListener.onImagePickComplete(this.selectList);
        }
    }

    @Override
    protected BaseSelectConfig getSelectConfig() {
        return this.selectConfig;
    }

    @Override
    protected IPickerPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    protected PickerUiConfig getUiConfig() {
        return this.uiConfig;
    }

    public void onDestroy() {
        this.uiConfig.setPickerUiProvider(null);
        this.uiConfig = null;
        this.presenter = null;
        super.onDestroy();
    }

    @Override
    public void reloadPickerWithList(List<ImageItem> selectedList) {
        this.selectList.clear();
        this.selectList.addAll(selectedList);
        this.mAdapter.refreshData(this.imageItems);
        this.refreshCompleteState();
    }
}

