/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.multi;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PickerActivityManager;
import com.ypx.imagepicker.activity.multi.MultiImagePickerFragment;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.data.OnImagePickCompleteListener2;
import com.ypx.imagepicker.data.PickerActivityCallBack;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.helper.launcher.PLauncher;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class MultiImagePickerActivity
extends FragmentActivity {
    public static final String INTENT_KEY_SELECT_CONFIG = "MultiSelectConfig";
    public static final String INTENT_KEY_PRESENTER = "IPickerPresenter";
    public static final String INTENT_KEY_CURRENT_INDEX = "currentIndex";
    public static final String INTENT_KEY_CURRENT_IMAGE = "currentImage";
    private MultiImagePickerFragment fragment;
    private MultiSelectConfig selectConfig;
    private IPickerPresenter presenter;

    public static void intent(@NonNull Activity activity, @NonNull MultiSelectConfig selectConfig, @NonNull IPickerPresenter presenter, @NonNull OnImagePickCompleteListener listener) {
        if (PViewSizeUtils.onDoubleClick()) {
            return;
        }
        Intent intent = new Intent((Context)activity, MultiImagePickerActivity.class);
        intent.putExtra(INTENT_KEY_SELECT_CONFIG, (Serializable)selectConfig);
        intent.putExtra(INTENT_KEY_PRESENTER, (Serializable)presenter);
        PLauncher.init(activity).startActivityForResult(intent, (PLauncher.Callback)PickerActivityCallBack.create(listener));
    }

    private boolean isIntentDataFailed() {
        this.selectConfig = (MultiSelectConfig)this.getIntent().getSerializableExtra(INTENT_KEY_SELECT_CONFIG);
        this.presenter = (IPickerPresenter)this.getIntent().getSerializableExtra(INTENT_KEY_PRESENTER);
        if (this.presenter == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.PRESENTER_NOT_FOUND.getCode());
            return true;
        }
        if (this.selectConfig == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
            return true;
        }
        return false;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isIntentDataFailed()) {
            return;
        }
        PickerActivityManager.addActivity((Activity)this);
        this.setContentView(R.layout.picker_activity_fragment_wrapper);
        this.setFragment();
    }

    private void setFragment() {
        this.fragment = ImagePicker.withMulti(this.presenter).withMultiSelectConfig(this.selectConfig).pickWithFragment(new OnImagePickCompleteListener2(){

            @Override
            public void onPickFailed(PickerError error) {
                PickerErrorExecutor.executeError((Activity)MultiImagePickerActivity.this, error.getCode());
                PickerActivityManager.clear();
            }

            @Override
            public void onImagePickComplete(ArrayList<ImageItem> items) {
                ImagePicker.closePickerWithCallback(items);
            }
        });
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)this.fragment).commit();
    }

    public void onBackPressed() {
        if (this.fragment != null && this.fragment.onBackPressed()) {
            return;
        }
        super.onBackPressed();
    }
}

