/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.crop;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PBaseLoaderFragment;
import com.ypx.imagepicker.adapter.PickerFolderAdapter;
import com.ypx.imagepicker.adapter.PickerItemAdapter;
import com.ypx.imagepicker.bean.ImageCropMode;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.PickerItemDisableCode;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.bean.selectconfig.CropSelectConfig;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.CropViewContainerHelper;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.helper.RecyclerViewTouchHelper;
import com.ypx.imagepicker.helper.VideoViewContainerHelper;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.widget.TouchRecyclerView;
import com.ypx.imagepicker.widget.cropimage.CropImageView;
import java.util.ArrayList;
import java.util.List;

public class MultiImageCropFragment
extends PBaseLoaderFragment
implements View.OnClickListener,
PickerFolderAdapter.FolderSelectResult,
PickerItemAdapter.OnActionResult {
    private TouchRecyclerView mGridImageRecyclerView;
    private RecyclerView mFolderListRecyclerView;
    private TextView mTvFullOrGap;
    private CropImageView mCropView;
    private ImageButton stateBtn;
    private FrameLayout mCropContainer;
    private RelativeLayout mCropLayout;
    private LinearLayout mInvisibleContainer;
    private View maskView;
    private View mImageSetMasker;
    private PickerItemAdapter imageGridAdapter;
    private PickerFolderAdapter folderAdapter;
    private List<ImageSet> imageSets = new ArrayList<ImageSet>();
    private List<ImageItem> imageItems = new ArrayList<ImageItem>();
    private int mCropSize;
    private int pressImageIndex = 0;
    private RecyclerViewTouchHelper touchHelper;
    private IPickerPresenter presenter;
    private CropSelectConfig selectConfig;
    private int cropMode = ImageCropMode.CropViewScale_FULL;
    private ImageItem currentImageItem;
    private View mContentView;
    private OnImagePickCompleteListener imageListener;
    private CropViewContainerHelper cropViewContainerHelper;
    private VideoViewContainerHelper videoViewContainerHelper;
    private PickerUiConfig uiConfig;
    private FrameLayout titleBarContainer;
    private FrameLayout bottomBarContainer;
    private FrameLayout titleBarContainer2;
    private ImageItem lastPressItem;

    public void setOnImagePickCompleteListener(@NonNull OnImagePickCompleteListener imageListener) {
        this.imageListener = imageListener;
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup container, @NonNull Bundle savedInstanceState) {
        this.mContentView = inflater.inflate(R.layout.picker_activity_multi_crop, container, false);
        return this.mContentView;
    }

    public void onViewCreated(@NonNull View view, @NonNull Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.isIntentDataValid()) {
            ImagePicker.isOriginalImage = false;
            this.uiConfig = this.presenter.getUiConfig((Context)this.getWeakActivity());
            this.setStatusBar();
            this.initView();
            this.initUI();
            this.initGridImagesAndImageSets();
            this.loadMediaSets();
        }
    }

    private boolean isIntentDataValid() {
        Bundle arguments = this.getArguments();
        if (null != arguments) {
            this.presenter = (IPickerPresenter)arguments.getSerializable("ICropPickerBindPresenter");
            this.selectConfig = (CropSelectConfig)arguments.getSerializable("selectConfig");
        }
        if (this.presenter == null) {
            PickerErrorExecutor.executeError(this.imageListener, PickerError.PRESENTER_NOT_FOUND.getCode());
            return false;
        }
        if (this.selectConfig == null) {
            PickerErrorExecutor.executeError(this.imageListener, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
            return false;
        }
        return true;
    }

    private void initView() {
        this.titleBarContainer = (FrameLayout)this.mContentView.findViewById(R.id.titleBarContainer);
        this.titleBarContainer2 = (FrameLayout)this.mContentView.findViewById(R.id.titleBarContainer2);
        this.bottomBarContainer = (FrameLayout)this.mContentView.findViewById(R.id.bottomBarContainer);
        this.mTvFullOrGap = (TextView)this.mContentView.findViewById(R.id.mTvFullOrGap);
        this.mImageSetMasker = this.mContentView.findViewById(R.id.mImageSetMasker);
        this.maskView = this.mContentView.findViewById(R.id.v_mask);
        this.mCropContainer = (FrameLayout)this.mContentView.findViewById(R.id.mCroupContainer);
        this.mInvisibleContainer = (LinearLayout)this.mContentView.findViewById(R.id.mInvisibleContainer);
        RelativeLayout topView = (RelativeLayout)this.mContentView.findViewById(R.id.topView);
        this.mCropLayout = (RelativeLayout)this.mContentView.findViewById(R.id.mCropLayout);
        this.stateBtn = (ImageButton)this.mContentView.findViewById(R.id.stateBtn);
        this.mGridImageRecyclerView = (TouchRecyclerView)this.mContentView.findViewById(R.id.mRecyclerView);
        this.mFolderListRecyclerView = (RecyclerView)this.mContentView.findViewById(R.id.mImageSetRecyclerView);
        this.mTvFullOrGap.setBackground(PCornerUtils.cornerDrawable(Color.parseColor((String)"#80000000"), this.dp(15.0f)));
        this.stateBtn.setOnClickListener((View.OnClickListener)this);
        this.maskView.setOnClickListener((View.OnClickListener)this);
        this.mImageSetMasker.setOnClickListener((View.OnClickListener)this);
        this.mTvFullOrGap.setOnClickListener((View.OnClickListener)this);
        this.mCropLayout.setClickable(true);
        this.maskView.setAlpha(0.0f);
        this.maskView.setVisibility(8);
        this.mCropSize = PViewSizeUtils.getScreenWidth((Context)this.getActivity());
        PViewSizeUtils.setViewSize((View)this.mCropLayout, this.mCropSize, 1.0f);
        this.touchHelper = RecyclerViewTouchHelper.create(this.mGridImageRecyclerView).setTopView((View)topView).setMaskView(this.maskView).setCanScrollHeight(this.mCropSize).build();
        this.cropViewContainerHelper = new CropViewContainerHelper((ViewGroup)this.mCropContainer);
        this.videoViewContainerHelper = new VideoViewContainerHelper();
        if (this.selectConfig.hasFirstImageItem()) {
            this.cropMode = this.selectConfig.getFirstImageItem().getCropMode();
        }
    }

    private void initUI() {
        this.titleBar = this.inflateControllerView((ViewGroup)this.titleBarContainer, true, this.uiConfig);
        this.bottomBar = this.inflateControllerView((ViewGroup)this.bottomBarContainer, false, this.uiConfig);
        if (this.titleBar != null) {
            PViewSizeUtils.setMarginTop((View)this.mCropLayout, this.titleBar.getViewHeight());
            this.touchHelper.setStickHeight(this.titleBar.getViewHeight());
        }
        if (this.bottomBar != null) {
            PViewSizeUtils.setMarginTopAndBottom((View)this.mGridImageRecyclerView, 0, this.bottomBar.getViewHeight());
        }
        this.mCropContainer.setBackgroundColor(this.uiConfig.getCropViewBackgroundColor());
        this.mGridImageRecyclerView.setBackgroundColor(this.uiConfig.getPickerBackgroundColor());
        this.stateBtn.setImageDrawable(this.getResources().getDrawable(this.uiConfig.getFullIconID()));
        this.mTvFullOrGap.setCompoundDrawablesWithIntrinsicBounds(this.getResources().getDrawable(this.uiConfig.getFillIconID()), null, null, null);
        this.setFolderListHeight(this.mFolderListRecyclerView, this.mImageSetMasker, true);
    }

    private void initGridImagesAndImageSets() {
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), this.selectConfig.getColumnCount());
        this.mGridImageRecyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.imageGridAdapter = new PickerItemAdapter(this.selectList, this.imageItems, this.selectConfig, this.presenter, this.uiConfig);
        this.imageGridAdapter.setHasStableIds(true);
        this.mGridImageRecyclerView.setAdapter(this.imageGridAdapter);
        this.mFolderListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.folderAdapter = new PickerFolderAdapter(this.presenter, this.uiConfig);
        this.mFolderListRecyclerView.setAdapter((RecyclerView.Adapter)this.folderAdapter);
        this.folderAdapter.refreshData(this.imageSets);
        this.mFolderListRecyclerView.setVisibility(8);
        this.folderAdapter.setFolderSelectResult(this);
        this.imageGridAdapter.setOnActionResult(this);
    }

    public void onClick(@NonNull View view) {
        if (this.imageItems == null || this.imageItems.size() == 0) {
            return;
        }
        if (this.onDoubleClick()) {
            this.tip(this.getActivity().getString(R.string.picker_str_tip_action_frequently));
            return;
        }
        if (view == this.stateBtn) {
            this.fullOrFit();
        } else if (view == this.maskView) {
            this.touchHelper.transitTopWithAnim(true, this.pressImageIndex, true);
        } else if (view == this.mTvFullOrGap) {
            this.fullOrGap();
        } else if (this.mImageSetMasker == view) {
            this.toggleFolderList();
        }
    }

    @Override
    public void onClickItem(@NonNull ImageItem imageItem, int position, int disableItemCode) {
        if (position <= 0 && this.selectConfig.isShowCamera()) {
            if (this.presenter.interceptCameraClick(this.getWeakActivity(), this)) {
                return;
            }
            this.checkTakePhotoOrVideo();
            return;
        }
        if (this.interceptClickDisableItem(disableItemCode, false)) {
            return;
        }
        this.pressImageIndex = position;
        if (this.imageItems == null || this.imageItems.size() == 0 || this.imageItems.size() <= this.pressImageIndex) {
            return;
        }
        if (this.isInterceptItemClick(imageItem, false)) {
            return;
        }
        this.onPressImage(imageItem, true);
    }

    private boolean isInterceptItemClick(ImageItem imageItem, boolean isClickCheckbox) {
        return !this.imageGridAdapter.isPreformClick() && this.presenter.interceptItemClick(this.getWeakActivity(), imageItem, this.selectList, (ArrayList)this.imageItems, this.selectConfig, this.imageGridAdapter, isClickCheckbox, null);
    }

    private void onPressImage(ImageItem imageItem, boolean isShowTransit) {
        this.currentImageItem = imageItem;
        if (this.lastPressItem != null) {
            if (this.lastPressItem.equals(this.currentImageItem)) {
                return;
            }
            this.lastPressItem.setPress(false);
        }
        this.currentImageItem.setPress(true);
        if (this.currentImageItem.isVideo()) {
            if (this.selectConfig.isVideoSinglePickAndAutoComplete()) {
                this.notifyOnSingleImagePickComplete(imageItem);
                return;
            }
            this.videoViewContainerHelper.loadVideoView((ViewGroup)this.mCropContainer, this.currentImageItem, this.presenter, this.uiConfig);
        } else {
            this.loadCropView();
        }
        this.checkStateBtn();
        this.imageGridAdapter.notifyDataSetChanged();
        this.touchHelper.transitTopWithAnim(true, this.pressImageIndex, isShowTransit);
        this.lastPressItem = this.currentImageItem;
    }

    @Override
    public void onCheckItem(ImageItem imageItem, int disableItemCode) {
        if (this.interceptClickDisableItem(disableItemCode, true)) {
            return;
        }
        if (this.isInterceptItemClick(imageItem, true)) {
            return;
        }
        if (this.selectList.contains(imageItem)) {
            this.removeImageItemFromCropViewList(imageItem);
            this.checkStateBtn();
        } else {
            this.onPressImage(imageItem, false);
            this.addImageItemToCropViewList(imageItem);
        }
        this.imageGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void folderSelected(ImageSet set, int pos) {
        this.selectImageSet(pos, true);
    }

    private void selectImageSet(int position, boolean isTransit) {
        ImageSet imageSet = this.imageSets.get(position);
        if (imageSet == null) {
            return;
        }
        for (ImageSet set : this.imageSets) {
            set.isSelected = false;
        }
        imageSet.isSelected = true;
        this.folderAdapter.notifyDataSetChanged();
        if (this.titleBar != null) {
            this.titleBar.onImageSetSelected(imageSet);
        }
        if (this.bottomBar != null) {
            this.bottomBar.onImageSetSelected(imageSet);
        }
        if (isTransit) {
            this.toggleFolderList();
        }
        this.loadMediaItemsFromSet(imageSet);
    }

    private void loadCropView() {
        this.mCropView = this.cropViewContainerHelper.loadCropView(this.getContext(), this.currentImageItem, this.mCropSize, this.presenter, new CropViewContainerHelper.onLoadComplete(){

            @Override
            public void loadComplete() {
                MultiImageCropFragment.this.checkStateBtn();
            }
        });
        this.resetCropViewSize(this.mCropView, false);
    }

    private void addImageItemToCropViewList(ImageItem imageItem) {
        if (!this.selectList.contains(imageItem)) {
            this.selectList.add(imageItem);
        }
        this.cropViewContainerHelper.addCropView(this.mCropView, imageItem);
        this.refreshCompleteState();
    }

    private void removeImageItemFromCropViewList(ImageItem imageItem) {
        this.selectList.remove(imageItem);
        this.cropViewContainerHelper.removeCropView(imageItem);
        this.refreshCompleteState();
    }

    private void checkStateBtn() {
        if (this.currentImageItem.isVideo()) {
            this.stateBtn.setVisibility(8);
            this.mTvFullOrGap.setVisibility(8);
            return;
        }
        if (this.currentImageItem.getWidthHeightType() == 0) {
            this.stateBtn.setVisibility(8);
            this.mTvFullOrGap.setVisibility(8);
            return;
        }
        if (this.selectConfig.hasFirstImageItem()) {
            this.stateBtn.setVisibility(8);
            if (this.selectConfig.isAssignGapState()) {
                if (this.selectList.size() == 0 || this.selectList.get(0) != null && ((ImageItem)this.selectList.get(0)).equals(this.currentImageItem)) {
                    this.setImageScaleState();
                } else {
                    this.mTvFullOrGap.setVisibility(8);
                    if (((ImageItem)this.selectList.get(0)).getCropMode() == ImageCropMode.ImageScale_GAP) {
                        this.mCropView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        this.mCropView.setBackgroundColor(-1);
                    } else {
                        this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        this.mCropView.setBackgroundColor(0);
                    }
                }
            } else {
                this.setImageScaleState();
            }
            return;
        }
        if (this.selectList.size() > 0) {
            if (this.currentImageItem == this.selectList.get(0)) {
                this.stateBtn.setVisibility(0);
                this.mTvFullOrGap.setVisibility(8);
                this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                this.currentImageItem.setCropMode(this.cropMode);
            } else {
                this.stateBtn.setVisibility(8);
                this.setImageScaleState();
            }
        } else {
            this.stateBtn.setVisibility(0);
            this.mTvFullOrGap.setVisibility(8);
        }
    }

    private void resetCropViewSize(CropImageView view, boolean isShowAnim) {
        int height = this.mCropSize;
        int width = this.mCropSize;
        if (this.cropMode == ImageCropMode.CropViewScale_FIT) {
            ImageItem firstImageItem = this.selectConfig.hasFirstImageItem() ? this.selectConfig.getFirstImageItem() : (this.selectList.size() > 0 ? (ImageItem)this.selectList.get(0) : this.currentImageItem);
            height = firstImageItem.getWidthHeightType() > 0 ? this.mCropSize * 3 / 4 : this.mCropSize;
            width = firstImageItem.getWidthHeightType() < 0 ? this.mCropSize * 3 / 4 : this.mCropSize;
        }
        view.changeSize(isShowAnim, width, height);
    }

    private void fullOrFit() {
        if (this.cropMode == ImageCropMode.CropViewScale_FIT) {
            this.cropMode = ImageCropMode.CropViewScale_FULL;
            this.stateBtn.setImageDrawable(this.getResources().getDrawable(this.uiConfig.getFitIconID()));
        } else {
            this.cropMode = ImageCropMode.CropViewScale_FIT;
            this.stateBtn.setImageDrawable(this.getResources().getDrawable(this.uiConfig.getFullIconID()));
        }
        if (this.currentImageItem != null) {
            this.currentImageItem.setCropMode(this.cropMode);
        }
        this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.resetCropViewSize(this.mCropView, true);
        this.cropViewContainerHelper.refreshAllState(this.currentImageItem, this.selectList, (ViewGroup)this.mInvisibleContainer, this.cropMode == ImageCropMode.CropViewScale_FIT, new CropViewContainerHelper.ResetSizeExecutor(){

            @Override
            public void resetAllCropViewSize(CropImageView view) {
                MultiImageCropFragment.this.resetCropViewSize(view, false);
            }
        });
    }

    private void setImageScaleState() {
        if (this.cropMode == ImageCropMode.CropViewScale_FIT) {
            this.mTvFullOrGap.setVisibility(8);
        } else {
            this.mTvFullOrGap.setVisibility(0);
            if (this.selectList.contains(this.currentImageItem)) {
                if (this.currentImageItem.getCropMode() == ImageCropMode.ImageScale_FILL) {
                    this.fullState();
                } else if (this.currentImageItem.getCropMode() == ImageCropMode.ImageScale_GAP) {
                    this.gapState();
                }
            } else {
                this.fullState();
                this.currentImageItem.setCropMode(ImageCropMode.ImageScale_FILL);
                this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        }
    }

    private void fullOrGap() {
        if (this.currentImageItem.getCropMode() == ImageCropMode.ImageScale_FILL) {
            this.currentImageItem.setCropMode(ImageCropMode.ImageScale_GAP);
            this.mCropView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.gapState();
        } else {
            this.currentImageItem.setCropMode(ImageCropMode.ImageScale_FILL);
            this.mCropView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.fullState();
        }
        this.resetCropViewSize(this.mCropView, false);
    }

    private void gapState() {
        this.mTvFullOrGap.setText((CharSequence)this.getString(R.string.picker_str_redBook_full));
        this.mCropView.setBackgroundColor(-1);
        this.mTvFullOrGap.setCompoundDrawablesWithIntrinsicBounds(this.getResources().getDrawable(this.uiConfig.getFillIconID()), null, null, null);
    }

    private void fullState() {
        this.mTvFullOrGap.setText((CharSequence)this.getString(R.string.picker_str_redBook_gap));
        this.mCropView.setBackgroundColor(0);
        this.mTvFullOrGap.setCompoundDrawablesWithIntrinsicBounds(this.getResources().getDrawable(this.uiConfig.getGapIconID()), null, null, null);
    }

    @Override
    protected void notifyPickerComplete() {
        if (this.selectList.size() <= 0 || !((ImageItem)this.selectList.get(0)).isVideo()) {
            if (this.mCropView.isEditing()) {
                return;
            }
            if (this.selectList.contains(this.currentImageItem) && (this.mCropView.getDrawable() == null || this.mCropView.getDrawable().getIntrinsicHeight() == 0 || this.mCropView.getDrawable().getIntrinsicWidth() == 0)) {
                this.tip(this.getString(R.string.picker_str_tip_shield));
                return;
            }
            this.selectList = this.cropViewContainerHelper.generateCropUrls(this.selectList, this.cropMode);
        }
        if (!this.presenter.interceptPickerCompleteClick(this.getWeakActivity(), this.selectList, this.selectConfig) && null != this.imageListener) {
            this.imageListener.onImagePickComplete(this.selectList);
        }
    }

    @Override
    protected void toggleFolderList() {
        if (this.mFolderListRecyclerView.getVisibility() == 8) {
            View view = this.titleBarContainer.getChildAt(0);
            if (view == null) {
                return;
            }
            this.titleBarContainer.removeAllViews();
            this.titleBarContainer2.removeAllViews();
            this.titleBarContainer2.addView(view);
            this.mImageSetMasker.setVisibility(0);
            this.controllerViewOnTransitImageSet(true);
            this.mFolderListRecyclerView.setVisibility(0);
            this.mFolderListRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)(this.uiConfig.isShowFromBottom() ? R.anim.picker_show2bottom : R.anim.picker_anim_in)));
        } else {
            final View view = this.titleBarContainer2.getChildAt(0);
            if (view == null) {
                return;
            }
            this.mImageSetMasker.setVisibility(8);
            this.controllerViewOnTransitImageSet(false);
            this.mFolderListRecyclerView.setVisibility(8);
            this.mFolderListRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)(this.uiConfig.isShowFromBottom() ? R.anim.picker_hide2bottom : R.anim.picker_anim_up)));
            this.titleBarContainer2.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MultiImageCropFragment.this.titleBarContainer2.removeAllViews();
                    MultiImageCropFragment.this.titleBarContainer.removeAllViews();
                    MultiImageCropFragment.this.titleBarContainer.addView(view);
                }
            }, 300L);
        }
    }

    @Override
    protected void intentPreview(boolean isFolderListPreview, int index) {
    }

    @Override
    protected void loadMediaSetsComplete(@Nullable List<ImageSet> imageSetList) {
        if (imageSetList == null || imageSetList.size() == 0 || imageSetList.size() == 1 && imageSetList.get((int)0).count == 0) {
            this.tip(this.getString(R.string.picker_str_tip_media_empty));
            return;
        }
        this.imageSets = imageSetList;
        this.folderAdapter.refreshData(this.imageSets);
        this.selectImageSet(0, false);
    }

    @Override
    protected void loadMediaItemsComplete(@NonNull ImageSet set) {
        if (set.imageItems != null && set.imageItems.size() > 0) {
            this.imageItems.clear();
            this.imageItems.addAll(set.imageItems);
            this.imageGridAdapter.notifyDataSetChanged();
            int firstImageIndex = this.getCanPressItemPosition();
            if (firstImageIndex < 0) {
                return;
            }
            int index = this.selectConfig.isShowCamera() ? firstImageIndex + 1 : firstImageIndex;
            this.onClickItem(this.imageItems.get(firstImageIndex), index, 0);
        }
    }

    private int getCanPressItemPosition() {
        for (int i = 0; i < this.imageItems.size(); ++i) {
            int code;
            ImageItem imageItem = this.imageItems.get(i);
            if (imageItem.isVideo() && this.selectConfig.isVideoSinglePickAndAutoComplete() || (code = PickerItemDisableCode.getItemDisableCode(imageItem, this.selectConfig, this.selectList, false)) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void refreshAllVideoSet(@Nullable ImageSet allVideoSet) {
        if (allVideoSet != null && allVideoSet.imageItems != null && allVideoSet.imageItems.size() > 0 && !this.imageSets.contains(allVideoSet)) {
            this.imageSets.add(1, allVideoSet);
            this.folderAdapter.refreshData(this.imageSets);
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.mFolderListRecyclerView != null && this.mFolderListRecyclerView.getVisibility() == 0) {
            this.toggleFolderList();
            return true;
        }
        if (this.presenter != null && this.presenter.interceptPickerCancel(this.getWeakActivity(), this.selectList)) {
            return true;
        }
        PickerErrorExecutor.executeError(this.imageListener, PickerError.CANCEL.getCode());
        return false;
    }

    @Override
    public void onTakePhotoResult(@Nullable ImageItem imageItem) {
        if (imageItem != null) {
            this.addItemInImageSets(this.imageSets, this.imageItems, imageItem);
            this.onCheckItem(imageItem, 0);
            this.imageGridAdapter.notifyDataSetChanged();
        }
    }

    @Override
    protected BaseSelectConfig getSelectConfig() {
        return this.selectConfig;
    }

    @Override
    protected IPickerPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    protected PickerUiConfig getUiConfig() {
        return this.uiConfig;
    }

    public void onDestroy() {
        if (this.videoViewContainerHelper != null) {
            this.videoViewContainerHelper.onDestroy();
        }
        this.uiConfig.setPickerUiProvider(null);
        this.uiConfig = null;
        this.presenter = null;
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
        if (this.videoViewContainerHelper != null) {
            this.videoViewContainerHelper.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.videoViewContainerHelper != null) {
            this.videoViewContainerHelper.onPause();
        }
    }
}

