/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity.crop;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.activity.PickerActivityManager;
import com.ypx.imagepicker.activity.crop.MultiImageCropFragment;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.CropSelectConfig;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.data.OnImagePickCompleteListener2;
import com.ypx.imagepicker.data.PickerActivityCallBack;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.helper.launcher.PLauncher;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class MultiImageCropActivity
extends FragmentActivity {
    public static final String INTENT_KEY_DATA_PRESENTER = "ICropPickerBindPresenter";
    public static final String INTENT_KEY_SELECT_CONFIG = "selectConfig";
    private MultiImageCropFragment mFragment;
    private IPickerPresenter presenter;
    private CropSelectConfig selectConfig;

    public static void intent(@NonNull Activity activity, @NonNull IPickerPresenter presenter, @NonNull CropSelectConfig selectConfig, @NonNull OnImagePickCompleteListener listener) {
        if (!PViewSizeUtils.onDoubleClick()) {
            Intent intent = new Intent((Context)activity, MultiImageCropActivity.class);
            intent.putExtra(INTENT_KEY_DATA_PRESENTER, (Serializable)presenter);
            intent.putExtra(INTENT_KEY_SELECT_CONFIG, (Serializable)selectConfig);
            PLauncher.init(activity).startActivityForResult(intent, (PLauncher.Callback)PickerActivityCallBack.create(listener));
        }
    }

    private boolean isIntentDataFailed() {
        this.presenter = (IPickerPresenter)this.getIntent().getSerializableExtra(INTENT_KEY_DATA_PRESENTER);
        this.selectConfig = (CropSelectConfig)this.getIntent().getSerializableExtra(INTENT_KEY_SELECT_CONFIG);
        if (this.presenter == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.PRESENTER_NOT_FOUND.getCode());
            return true;
        }
        if (this.selectConfig == null) {
            PickerErrorExecutor.executeError((Activity)this, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
            return true;
        }
        return false;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isIntentDataFailed()) {
            return;
        }
        PickerActivityManager.addActivity((Activity)this);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.picker_activity_fragment_wrapper);
        this.setFragment();
    }

    private void setFragment() {
        this.mFragment = ImagePicker.withCrop(this.presenter).withSelectConfig(this.selectConfig).pickWithFragment(new OnImagePickCompleteListener2(){

            @Override
            public void onPickFailed(PickerError error) {
                PickerErrorExecutor.executeError((Activity)MultiImageCropActivity.this, error.getCode());
                PickerActivityManager.clear();
            }

            @Override
            public void onImagePickComplete(ArrayList<ImageItem> items) {
                ImagePicker.closePickerWithCallback(items);
            }
        });
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)this.mFragment).commit();
    }

    public void onBackPressed() {
        if (null != this.mFragment && this.mFragment.onBackPressed()) {
            return;
        }
        super.onBackPressed();
    }
}

