/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.PickerItemDisableCode;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.data.ICameraExecutor;
import com.ypx.imagepicker.data.MediaItemsDataSource;
import com.ypx.imagepicker.data.MediaSetsDataSource;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.data.ProgressSceneEnum;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PPermissionUtils;
import com.ypx.imagepicker.utils.PStatusBarUtil;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.PickerUiProvider;
import com.ypx.imagepicker.views.base.PickerControllerView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class PBaseLoaderFragment
extends Fragment
implements ICameraExecutor {
    protected ArrayList<ImageItem> selectList = new ArrayList();
    protected PickerControllerView titleBar;
    protected PickerControllerView bottomBar;
    private WeakReference<Activity> weakReference;
    private long lastTime = 0L;

    @NonNull
    protected abstract BaseSelectConfig getSelectConfig();

    @NonNull
    protected abstract IPickerPresenter getPresenter();

    @NonNull
    protected abstract PickerUiConfig getUiConfig();

    protected abstract void notifyPickerComplete();

    protected abstract void toggleFolderList();

    protected abstract void intentPreview(boolean var1, int var2);

    protected abstract void loadMediaSetsComplete(@Nullable List<ImageSet> var1);

    protected abstract void loadMediaItemsComplete(@Nullable ImageSet var1);

    protected abstract void refreshAllVideoSet(@Nullable ImageSet var1);

    public boolean onBackPressed() {
        return false;
    }

    protected void notifyOnSingleImagePickComplete(ImageItem imageItem) {
        this.selectList.clear();
        this.selectList.add(imageItem);
        this.notifyPickerComplete();
    }

    private boolean isOverMaxCount() {
        if (this.selectList.size() >= this.getSelectConfig().getMaxCount()) {
            this.getPresenter().overMaxCountTip(this.getContext(), this.getSelectConfig().getMaxCount());
            return true;
        }
        return false;
    }

    protected void checkTakePhotoOrVideo() {
        if (this.getSelectConfig().isShowVideo() && !this.getSelectConfig().isShowImage()) {
            this.takeVideo();
        } else {
            this.takePhoto();
        }
    }

    @Override
    public void takePhoto() {
        if (this.getActivity() == null || this.isOverMaxCount()) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 1431);
        } else {
            ImagePicker.takePhoto((Activity)this.getActivity(), null, true, new OnImagePickCompleteListener(){

                @Override
                public void onImagePickComplete(ArrayList<ImageItem> items) {
                    if (items != null && items.size() > 0 && items.get(0) != null) {
                        PBaseLoaderFragment.this.onTakePhotoResult(items.get(0));
                    }
                }
            });
        }
    }

    @Override
    public void takeVideo() {
        if (this.getActivity() == null || this.isOverMaxCount()) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 1431);
        } else {
            ImagePicker.takeVideo((Activity)this.getActivity(), null, this.getSelectConfig().getMaxVideoDuration(), true, new OnImagePickCompleteListener(){

                @Override
                public void onImagePickComplete(ArrayList<ImageItem> items) {
                    if (items != null && items.size() > 0 && items.get(0) != null) {
                        PBaseLoaderFragment.this.onTakePhotoResult(items.get(0));
                    }
                }
            });
        }
    }

    protected void loadMediaSets() {
        if (this.getActivity() == null) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1432);
        } else {
            ImagePicker.provideMediaSets(this.getActivity(), this.getSelectConfig().getMimeTypes(), new MediaSetsDataSource.MediaSetProvider(){

                @Override
                public void providerMediaSets(ArrayList<ImageSet> imageSets) {
                    PBaseLoaderFragment.this.loadMediaSetsComplete(imageSets);
                }
            });
        }
    }

    protected void loadMediaItemsFromSet(final @NonNull ImageSet set) {
        if (set.imageItems == null || set.imageItems.size() == 0) {
            DialogInterface dialogInterface = null;
            if (!set.isAllMedia() && set.count > 1000) {
                dialogInterface = this.getPresenter().showProgressDialog(this.getWeakActivity(), ProgressSceneEnum.loadMediaItem);
            }
            final BaseSelectConfig selectConfig = this.getSelectConfig();
            final DialogInterface finalDialogInterface = dialogInterface;
            ImagePicker.provideMediaItemsFromSetWithPreload(this.getActivity(), set, selectConfig.getMimeTypes(), 40, new MediaItemsDataSource.MediaItemPreloadProvider(){

                @Override
                public void providerMediaItems(ArrayList<ImageItem> imageItems) {
                    if (finalDialogInterface != null) {
                        finalDialogInterface.dismiss();
                    }
                    set.imageItems = imageItems;
                    PBaseLoaderFragment.this.loadMediaItemsComplete(set);
                }
            }, new MediaItemsDataSource.MediaItemProvider(){

                @Override
                public void providerMediaItems(ArrayList<ImageItem> imageItems, ImageSet allVideoSet) {
                    if (finalDialogInterface != null) {
                        finalDialogInterface.dismiss();
                    }
                    set.imageItems = imageItems;
                    PBaseLoaderFragment.this.loadMediaItemsComplete(set);
                    if (selectConfig.isShowImage() && selectConfig.isShowVideo()) {
                        PBaseLoaderFragment.this.refreshAllVideoSet(allVideoSet);
                    }
                }
            });
        } else {
            this.loadMediaItemsComplete(set);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1431) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.takePhoto();
            } else {
                PPermissionUtils.create(this.getContext()).showSetPermissionDialog(this.getString(R.string.picker_str_camera_permission));
            }
        } else if (requestCode == 1432) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.loadMediaSets();
            } else {
                PPermissionUtils.create(this.getContext()).showSetPermissionDialog(this.getString(R.string.picker_str_storage_permission));
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    protected PickerControllerView inflateControllerView(ViewGroup container, boolean isTitle, PickerUiConfig uiConfig) {
        PickerControllerView view;
        BaseSelectConfig selectConfig = this.getSelectConfig();
        PickerUiProvider uiProvider = uiConfig.getPickerUiProvider();
        PickerControllerView pickerControllerView = view = isTitle ? uiProvider.getTitleBar((Context)this.getWeakActivity()) : uiProvider.getBottomBar((Context)this.getWeakActivity());
        if (view != null && view.isAddInParent()) {
            container.addView((View)view, new ViewGroup.LayoutParams(-1, -2));
            if (selectConfig.isShowVideo() && selectConfig.isShowImage()) {
                view.setTitle(this.getString(R.string.picker_str_title_all));
            } else if (selectConfig.isShowVideo()) {
                view.setTitle(this.getString(R.string.picker_str_title_video));
            } else {
                view.setTitle(this.getString(R.string.picker_str_title_image));
            }
            final PickerControllerView finalView = view;
            View.OnClickListener clickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    if (v == finalView.getCanClickToCompleteView()) {
                        PBaseLoaderFragment.this.notifyPickerComplete();
                    } else if (v == finalView.getCanClickToToggleFolderListView()) {
                        PBaseLoaderFragment.this.toggleFolderList();
                    } else {
                        PBaseLoaderFragment.this.intentPreview(false, 0);
                    }
                }
            };
            if (view.getCanClickToCompleteView() != null) {
                view.getCanClickToCompleteView().setOnClickListener(clickListener);
            }
            if (view.getCanClickToToggleFolderListView() != null) {
                view.getCanClickToToggleFolderListView().setOnClickListener(clickListener);
            }
            if (view.getCanClickToIntentPreviewView() != null) {
                view.getCanClickToIntentPreviewView().setOnClickListener(clickListener);
            }
        }
        return view;
    }

    protected void controllerViewOnTransitImageSet(boolean isOpen) {
        if (this.titleBar != null) {
            this.titleBar.onTransitImageSet(isOpen);
        }
        if (this.bottomBar != null) {
            this.bottomBar.onTransitImageSet(isOpen);
        }
    }

    protected void controllerViewOnImageSetSelected(ImageSet set) {
        if (this.titleBar != null) {
            this.titleBar.onImageSetSelected(set);
        }
        if (this.bottomBar != null) {
            this.bottomBar.onImageSetSelected(set);
        }
    }

    protected void refreshCompleteState() {
        if (this.titleBar != null) {
            this.titleBar.refreshCompleteViewState(this.selectList, this.getSelectConfig());
        }
        if (this.bottomBar != null) {
            this.bottomBar.refreshCompleteViewState(this.selectList, this.getSelectConfig());
        }
    }

    protected void setFolderListHeight(RecyclerView mFolderListRecyclerView, View mImageSetMask, boolean isCrop) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)mFolderListRecyclerView.getLayoutParams();
        RelativeLayout.LayoutParams maskParams = (RelativeLayout.LayoutParams)mImageSetMask.getLayoutParams();
        PickerUiConfig uiConfig = this.getUiConfig();
        int height = uiConfig.getFolderListOpenMaxMargin();
        if (uiConfig.getFolderListOpenDirection() == 2) {
            params.addRule(12, -1);
            if (isCrop) {
                params.bottomMargin = this.bottomBar != null ? this.bottomBar.getViewHeight() : 0;
                params.topMargin = (this.titleBar != null ? this.titleBar.getViewHeight() : 0) + height;
                maskParams.topMargin = this.titleBar != null ? this.titleBar.getViewHeight() : 0;
                maskParams.bottomMargin = this.bottomBar != null ? this.bottomBar.getViewHeight() : 0;
            } else {
                params.bottomMargin = 0;
                params.topMargin = height;
            }
        } else {
            params.addRule(10, -1);
            if (isCrop) {
                params.bottomMargin = height + (this.bottomBar != null ? this.bottomBar.getViewHeight() : 0);
                params.topMargin = this.titleBar != null ? this.titleBar.getViewHeight() : 0;
                maskParams.topMargin = this.titleBar != null ? this.titleBar.getViewHeight() : 0;
                maskParams.bottomMargin = this.bottomBar != null ? this.bottomBar.getViewHeight() : 0;
            } else {
                params.bottomMargin = height;
                params.topMargin = 0;
            }
        }
        mFolderListRecyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        mImageSetMask.setLayoutParams((ViewGroup.LayoutParams)maskParams);
    }

    protected boolean interceptClickDisableItem(int disableItemCode, boolean isCheckOverMaxCount) {
        if (disableItemCode != 0) {
            if (!isCheckOverMaxCount && disableItemCode == 2) {
                return false;
            }
            String message = PickerItemDisableCode.getMessageFormCode((Context)this.getActivity(), disableItemCode, this.getPresenter(), this.getSelectConfig());
            if (message.length() > 0) {
                this.getPresenter().tip((Context)this.getWeakActivity(), message);
            }
            return true;
        }
        return false;
    }

    protected void addItemInImageSets(@NonNull List<ImageSet> imageSets, @NonNull List<ImageItem> imageItems, @NonNull ImageItem imageItem) {
        imageItems.add(0, imageItem);
        if (imageSets.size() == 0) {
            String firstImageSetName = imageItem.isVideo() ? this.getActivity().getString(R.string.picker_str_folder_item_video) : this.getActivity().getString(R.string.picker_str_folder_item_image);
            ImageSet imageSet = ImageSet.allImageSet(firstImageSetName);
            imageSet.cover = imageItem;
            imageSet.coverPath = imageItem.path;
            imageSet.imageItems = (ArrayList)imageItems;
            imageSet.count = imageSet.imageItems.size();
            imageSets.add(imageSet);
        } else {
            imageSets.get((int)0).imageItems = (ArrayList)imageItems;
            imageSets.get((int)0).cover = imageItem;
            imageSets.get((int)0).coverPath = imageItem.path;
            imageSets.get((int)0).count = imageItems.size();
        }
    }

    protected Activity getWeakActivity() {
        if (this.getActivity() != null) {
            if (this.weakReference == null) {
                this.weakReference = new WeakReference<FragmentActivity>(this.getActivity());
            }
            return (Activity)this.weakReference.get();
        }
        return null;
    }

    protected void tip(String msg) {
        this.getPresenter().tip((Context)this.getWeakActivity(), msg);
    }

    public final int dp(float dp) {
        if (this.getActivity() == null || this.getContext() == null) {
            return 0;
        }
        float density = this.getResources().getDisplayMetrics().density;
        return (int)((double)(dp * density) + 0.5);
    }

    protected boolean onDoubleClick() {
        boolean flag = false;
        long time = System.currentTimeMillis() - this.lastTime;
        if (time > 300L) {
            flag = true;
        }
        this.lastTime = System.currentTimeMillis();
        return !flag;
    }

    protected void setStatusBar() {
        if (this.getActivity() != null) {
            if (this.getUiConfig().isShowStatusBar() || PStatusBarUtil.hasNotchInScreen((Activity)this.getActivity())) {
                PStatusBarUtil.setStatusBar((Activity)this.getActivity(), this.getUiConfig().getStatusBarColor(), false, PStatusBarUtil.isDarkColor(this.getUiConfig().getStatusBarColor()));
            } else {
                PStatusBarUtil.fullScreen((Activity)this.getActivity());
            }
        }
    }
}

