/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.ypx.imagepicker.activity.PickerActivityManager;
import com.ypx.imagepicker.activity.preview.MultiImagePreviewActivity;
import com.ypx.imagepicker.activity.singlecrop.SingleCropActivity;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.PickerError;
import com.ypx.imagepicker.bean.selectconfig.CropConfig;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.builder.CropPickerBuilder;
import com.ypx.imagepicker.builder.MultiPickerBuilder;
import com.ypx.imagepicker.data.MediaItemsDataSource;
import com.ypx.imagepicker.data.MediaSetsDataSource;
import com.ypx.imagepicker.data.OnImagePickCompleteListener;
import com.ypx.imagepicker.helper.CameraCompat;
import com.ypx.imagepicker.helper.PickerErrorExecutor;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.utils.PPermissionUtils;
import java.util.ArrayList;
import java.util.Set;

public class ImagePicker {
    public static String DEFAULT_FILE_NAME = "imagePicker";
    public static final String INTENT_KEY_PICKER_RESULT = "pickerResult";
    public static final int REQ_PICKER_RESULT_CODE = 1433;
    public static final int REQ_CAMERA = 1431;
    public static final int REQ_STORAGE = 1432;
    public static boolean isOriginalImage = false;
    private static int themeColor = -65536;
    private static boolean previewWithHighQuality = false;

    public static void setPreviewWithHighQuality(boolean previewWithHighQuality) {
        ImagePicker.previewWithHighQuality = previewWithHighQuality;
    }

    public static boolean isPreviewWithHighQuality() {
        return previewWithHighQuality;
    }

    public static CropPickerBuilder withCrop(IPickerPresenter presenter) {
        return new CropPickerBuilder(presenter);
    }

    public static MultiPickerBuilder withMulti(IPickerPresenter presenter) {
        return new MultiPickerBuilder(presenter);
    }

    public static void takePhoto(Activity activity, String imageName, boolean isCopyInDCIM, OnImagePickCompleteListener listener) {
        if (imageName == null || imageName.length() == 0) {
            imageName = "Img_" + System.currentTimeMillis();
        }
        CameraCompat.takePhoto(activity, imageName, isCopyInDCIM, listener);
    }

    public static void takeVideo(Activity activity, String videoName, long maxDuration, boolean isCopyInDCIM, OnImagePickCompleteListener listener) {
        if (videoName == null || videoName.length() == 0) {
            videoName = "Video_" + System.currentTimeMillis();
        }
        CameraCompat.takeVideo(activity, videoName, maxDuration, isCopyInDCIM, listener);
    }

    public static void takePhotoAndCrop(final Activity activity, final IPickerPresenter presenter, final CropConfig cropConfig, final @NonNull OnImagePickCompleteListener listener) {
        if (presenter == null) {
            PickerErrorExecutor.executeError(activity, PickerError.PRESENTER_NOT_FOUND.getCode());
            return;
        }
        if (cropConfig == null) {
            PickerErrorExecutor.executeError(activity, PickerError.SELECT_CONFIG_NOT_FOUND.getCode());
            return;
        }
        ImagePicker.takePhoto(activity, null, false, new OnImagePickCompleteListener(){

            @Override
            public void onImagePickComplete(ArrayList<ImageItem> items) {
                if (items != null && items.size() > 0) {
                    SingleCropActivity.intentCrop(activity, presenter, cropConfig, items.get(0), listener);
                }
            }
        });
    }

    public static void crop(Activity activity, IPickerPresenter presenter, CropConfig cropConfig, String cropImagePath, OnImagePickCompleteListener listener) {
        if (presenter == null || cropConfig == null || listener == null) {
            PickerErrorExecutor.executeError(activity, PickerError.PRESENTER_NOT_FOUND.getCode());
            return;
        }
        SingleCropActivity.intentCrop(activity, presenter, cropConfig, cropImagePath, listener);
    }

    public static void crop(Activity activity, IPickerPresenter presenter, CropConfig cropConfig, ImageItem imageItem, OnImagePickCompleteListener listener) {
        if (presenter == null || cropConfig == null || listener == null) {
            PickerErrorExecutor.executeError(activity, PickerError.PRESENTER_NOT_FOUND.getCode());
            return;
        }
        SingleCropActivity.intentCrop(activity, presenter, cropConfig, imageItem, listener);
    }

    public static <T> void preview(Activity context, IPickerPresenter presenter, ArrayList<T> imageList, int pos, final OnImagePickCompleteListener listener) {
        if (imageList == null || imageList.size() == 0) {
            return;
        }
        MultiSelectConfig selectConfig = new MultiSelectConfig();
        selectConfig.setMaxCount(imageList.size());
        MultiImagePreviewActivity.intent(context, null, ImagePicker.transitArray(context, imageList), selectConfig, presenter, pos, new MultiImagePreviewActivity.PreviewResult(){

            @Override
            public void onResult(ArrayList<ImageItem> imageItems, boolean isCancel) {
                if (listener != null) {
                    listener.onImagePickComplete(imageItems);
                }
            }
        });
    }

    private static <T> ArrayList<ImageItem> transitArray(Activity activity, ArrayList<T> imageList) {
        ArrayList<ImageItem> items = new ArrayList<ImageItem>();
        for (T t : imageList) {
            if (t instanceof String) {
                ImageItem imageItem = ImageItem.withPath((Context)activity, (String)t);
                items.add(imageItem);
                continue;
            }
            if (t instanceof ImageItem) {
                items.add((ImageItem)t);
                continue;
            }
            if (t instanceof Uri) {
                Uri uri = (Uri)t;
                ImageItem imageItem = new ImageItem();
                imageItem.path = uri.toString();
                imageItem.mimeType = PBitmapUtils.getMimeTypeFromUri(activity, uri);
                imageItem.setVideo(MimeType.isVideo(imageItem.mimeType));
                imageItem.setUriPath(uri.toString());
                items.add(imageItem);
                continue;
            }
            throw new RuntimeException("ImageList item must be instanceof String or Uri or ImageItem");
        }
        return items;
    }

    public static void provideMediaSets(FragmentActivity activity, Set<MimeType> mimeTypeSet, MediaSetsDataSource.MediaSetProvider provider) {
        if (PPermissionUtils.hasStoragePermissions((Activity)activity)) {
            MediaSetsDataSource.create(activity).setMimeTypeSet(mimeTypeSet).loadMediaSets(provider);
        }
    }

    public static void provideMediaItemsFromSet(FragmentActivity activity, ImageSet set, Set<MimeType> mimeTypeSet, MediaItemsDataSource.MediaItemProvider provider) {
        if (PPermissionUtils.hasStoragePermissions((Activity)activity)) {
            MediaItemsDataSource.create(activity, set).setMimeTypeSet(mimeTypeSet).loadMediaItems(provider);
        }
    }

    public static void provideMediaItemsFromSetWithPreload(FragmentActivity activity, ImageSet set, Set<MimeType> mimeTypeSet, int preloadSize, MediaItemsDataSource.MediaItemPreloadProvider preloadProvider, MediaItemsDataSource.MediaItemProvider provider) {
        if (PPermissionUtils.hasStoragePermissions((Activity)activity)) {
            MediaItemsDataSource dataSource = MediaItemsDataSource.create(activity, set).setMimeTypeSet(mimeTypeSet).preloadSize(preloadSize);
            dataSource.setPreloadProvider(preloadProvider);
            dataSource.loadMediaItems(provider);
        }
    }

    public static void provideAllMediaItems(FragmentActivity activity, Set<MimeType> mimeTypeSet, MediaItemsDataSource.MediaItemProvider provider) {
        ImageSet set = new ImageSet();
        set.id = "-1";
        ImagePicker.provideMediaItemsFromSet(activity, set, mimeTypeSet, provider);
    }

    public static void clearAllCache() {
    }

    public static void closePickerWithCallback(ArrayList<ImageItem> list) {
        Activity activity = PickerActivityManager.getLastActivity();
        if (activity == null || list == null || list.size() == 0) {
            return;
        }
        Intent intent = new Intent();
        intent.putExtra(INTENT_KEY_PICKER_RESULT, list);
        activity.setResult(1433, intent);
        activity.finish();
        PickerActivityManager.clear();
    }

    public static void closePickerWithCallback(ImageItem imageItem) {
        ArrayList<ImageItem> imageItems = new ArrayList<ImageItem>();
        imageItems.add(imageItem);
        ImagePicker.closePickerWithCallback(imageItems);
    }

    public static int getThemeColor() {
        return themeColor;
    }

    public static void setThemeColor(int themeColor) {
        ImagePicker.themeColor = themeColor;
    }
}

