/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.spiderman.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.youzan.spiderman.utils.Logger;

public class NetWorkUtil {
    public static String STATE_WIFI = "wifi";
    public static String STATE_4G = "4G";
    public static String STATE_3G = "3G";
    public static String STATE_2G = "2G";
    public static String STAT_UNCONNECTION = "unconnection";
    public static String UNKNOWN = "unknown";

    public static boolean hasNetworkPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context != null && context.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0 && context.checkSelfPermission("android.permission.INTERNET") == 0;
        }
        return true;
    }

    public static boolean hasNetworkInternetPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context != null && context.checkSelfPermission("android.permission.INTERNET") == 0;
        }
        return true;
    }

    public static boolean hasNetworkStatePermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context != null && context.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        return true;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (!NetWorkUtil.hasNetworkStatePermission(context)) {
            return null;
        }
        return (context = (ConnectivityManager)context.getSystemService("connectivity")) != null ? context.getActiveNetworkInfo() : null;
    }

    public static boolean isConnected(Context context) {
        return (context = NetWorkUtil.getNetworkInfo(context)) != null && context.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        boolean bl;
        block5: {
            block4: {
                try {
                    context = NetWorkUtil.getNetworkInfo(context);
                    if (context == null) break block4;
                }
                catch (Exception exception) {
                    Logger.e("error", exception);
                    return true;
                }
                if (!context.isConnected()) break block4;
                if (context.getType() != 1) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public static String getConnectionStatus(Context context) {
        if ((context = NetWorkUtil.getNetworkInfo(context)) != null && context.isConnected()) {
            int n2 = context.getType();
            int n3 = context.getSubtype();
            if (n2 == 1) {
                return STATE_WIFI;
            }
            if (n2 == 0) {
                switch (n3) {
                    default: {
                        return UNKNOWN;
                    }
                    case 13: {
                        return STATE_4G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return STATE_3G;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                }
                return STATE_2G;
            }
        }
        return STAT_UNCONNECTION;
    }
}

