/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.spiderman.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    private static final String TAG = "JsonUtil";
    private static Gson sGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ").setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public static <T> T fromJsonObj(JSONObject jSONObject, Class<T> clazz) {
        return JsonUtil.fromJson(jSONObject.toString(), clazz);
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        return (T)sGson.fromJson(string, clazz);
    }

    public static <T> T fromJson(String string, Type type) {
        return (T)sGson.fromJson(string, type);
    }

    public static HashMap<String, String> fromJsonToMap(String string) {
        return (HashMap)sGson.fromJson(string, new TypeToken<HashMap<String, String>>(){}.getType());
    }

    public static String toJson(Object object) {
        return sGson.toJson(object);
    }

    public static String toJson(Object object, Type type) {
        return sGson.toJson(object, type);
    }

    public static <T> List<T> toArrayList(JSONArray jSONArray) {
        if (jSONArray == null) {
            return new ArrayList();
        }
        return (List)sGson.fromJson(jSONArray.toString(), new TypeToken<List<T>>(){}.getType());
    }

    public static <T> List<T> getObjectListFromStr(String string, Class<T> clazz) {
        return JsonUtil.getObjectListFromJsonArray(JsonUtil.fromJson(string, JsonArray.class), clazz);
    }

    public static <T> List<T> getObjectListFromJsonArray(JsonArray jsonArray, Class<T> clazz) {
        if (jsonArray != null && !"null".equals(jsonArray.toString())) {
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2 = arrayList;
            arrayList = new ArrayList<Object>(jsonArray.size());
            for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
                arrayList2.add(sGson.fromJson(jsonArray.get(i2), clazz));
            }
            return arrayList2;
        }
        return new ArrayList();
    }

    public static JSONObject readJSONObject(JsonReader jsonReader) throws IOException, JSONException {
        JSONObject jSONObject;
        jsonReader.beginObject();
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        while (jsonReader.hasNext()) {
            Object object;
            JsonReader jsonReader2 = jsonReader;
            String string = jsonReader2.nextName();
            if (jsonReader2.peek() == JsonToken.BEGIN_ARRAY) {
                JSONArray jSONArray;
                object = jSONArray;
                jSONArray = new JSONArray();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    object.put(JsonUtil.nextValue(jsonReader));
                }
                jsonReader.endArray();
            } else {
                object = JsonUtil.nextValue(jsonReader);
            }
            jSONObject2.put(string, object);
        }
        jsonReader.endObject();
        return jSONObject2;
    }

    public static String mapToJson(Map<String, String> map) {
        return new GsonBuilder().enableComplexMapKeySerialization().create().toJson(map);
    }

    private static Object nextValue(JsonReader jsonReader) throws IOException, JSONException {
        JsonToken jsonToken = jsonReader.peek();
        Object object = null;
        if (jsonToken == JsonToken.BEGIN_OBJECT) {
            object = JsonUtil.readJSONObject(jsonReader);
        } else if (jsonToken == JsonToken.BOOLEAN) {
            object = jsonReader.nextBoolean();
        } else if (jsonToken == JsonToken.NUMBER) {
            object = jsonReader.nextLong();
        } else if (jsonToken == JsonToken.STRING) {
            object = jsonReader.nextString();
        } else if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
        } else {
            jsonReader.skipValue();
        }
        return object;
    }
}

