/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.spiderman.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.youzan.spiderman.utils.PermissionUtil;
import java.util.UUID;

public class DeviceUuidFactory {
    private static final String PREFS_FILE = "com.youzan.spiderman.device_id.xml";
    private static final String PREFS_DEVICE_ID = "device_id";
    private static UUID uuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"MissingPermission"})
    public DeviceUuidFactory(Context object) {
        if (uuid != null) return;
        Class<DeviceUuidFactory> clazz = DeviceUuidFactory.class;
        synchronized (DeviceUuidFactory.class) {
            if (uuid != null) return;
            SharedPreferences sharedPreferences = object.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                string = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"android_id");
                try {
                    if (!"9774d56d682e549c".equals(string)) {
                        uuid = UUID.nameUUIDFromBytes(string.getBytes("utf8"));
                    } else {
                        void var1_4;
                        string = null;
                        if (PermissionUtil.hasReadPhoneStatePermission(object)) {
                            string = ((TelephonyManager)object.getSystemService("phone")).getDeviceId();
                        }
                        if (string != null) {
                            UUID uUID = UUID.nameUUIDFromBytes(string.getBytes("utf8"));
                        } else {
                            UUID uUID = UUID.randomUUID();
                        }
                        uuid = var1_4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).apply();
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    public String getDeviceUuid() {
        return uuid.toString();
    }
}

