/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;

public class Utils {
    public static float dp2px(Context context, float dp) {
        return context.getResources().getDisplayMetrics().density * dp;
    }

    public static int changeAlpha(@ColorInt int color, int alpha) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static void backToHome(Context context) {
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getNavigationHeight(@NonNull Context context) {
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        int navigationBarHeight = 0;
        if (resourceId > 0) {
            navigationBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
        return navigationBarHeight;
    }

    public static boolean navigationBarVisible(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            Point realSize = new Point();
            display.getRealSize(realSize);
            return realSize.y != size.y;
        }
        boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        return !hasMenuKey && !hasBackKey;
    }
}

