/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.youngfeng.snake.R;
import com.youngfeng.snake.config.SnakeConfigReader;
import com.youngfeng.snake.util.ActivityHelper;
import com.youngfeng.snake.util.ActivityManager;
import com.youngfeng.snake.util.Logger;
import com.youngfeng.snake.util.SoftKeyboardHelper;
import com.youngfeng.snake.util.TranslucentConversionListener;
import com.youngfeng.snake.util.Utils;
import com.youngfeng.snake.view.SnakeHackLayout;

public class ActivityDragInterceptor
extends SnakeHackLayout.DragInterceptor {
    public static final int INTERCEPT_SCENE_ROOT_ACTIVITY = 1;
    public static final int INTERCEPT_SCENE_TRANSLUCENT_CONVERSION = 2;
    private Activity mActivity;
    private boolean isTranslucent = false;

    private ActivityDragInterceptor(Activity activity) {
        this.mActivity = activity;
        this.convertToTranslucent(this.mActivity, new TranslucentConversionListener(){

            @Override
            public void onTranslucentConversionComplete(boolean drawComplete) {
                ActivityDragInterceptor.this.isTranslucent = true;
                ActivityDragInterceptor.this.convertFromTranslucent(ActivityDragInterceptor.this.mActivity);
                ActivityDragInterceptor.this.isTranslucent = false;
            }
        });
    }

    public static ActivityDragInterceptor get(Activity activity) {
        return new ActivityDragInterceptor(activity);
    }

    public void attachToLayout(SnakeHackLayout snakeLayout) {
        snakeLayout.setOnEdgeDragListener(new SnakeHackLayout.OnEdgeDragListener(){
            private View viewOfLastActivity;
            {
                this.viewOfLastActivity = ActivityManager.get().getViewOfLastActivity(ActivityDragInterceptor.this.mActivity);
            }

            @Override
            public void onDragStart(SnakeHackLayout parent) {
                SoftKeyboardHelper.hideKeyboard(ActivityDragInterceptor.this.mActivity);
                if (parent.onlyListenToFastSwipe()) {
                    ActivityDragInterceptor.this.isTranslucent = true;
                } else {
                    ActivityDragInterceptor.this.convertToTranslucent(ActivityDragInterceptor.this.mActivity, new TranslucentConversionListener(){

                        @Override
                        public void onTranslucentConversionComplete(boolean drawComplete) {
                            ActivityDragInterceptor.this.isTranslucent = true;
                        }
                    });
                }
                Logger.d("ActivityDragInterceptor: onDragStart...");
            }

            @Override
            public void onDrag(SnakeHackLayout parent, View view, int left) {
                Logger.d("ActivityDragInterceptor: onDrag: left = " + left);
                if (parent.onlyListenToFastSwipe() || !parent.getUIConfig().allowPageLinkage) {
                    return;
                }
                if (null != this.viewOfLastActivity && left > 0) {
                    float ratio = (float)left * 1.0f / (float)parent.getWidth();
                    this.viewOfLastActivity.setX((ratio - 1.0f) * Utils.dp2px((Context)ActivityDragInterceptor.this.mActivity, 100.0f));
                }
            }

            @Override
            public void onRelease(SnakeHackLayout parent, View view, int left, boolean shouldClose, int interceptScene) {
                Logger.d("ActivityDragInterceptor: onRelease -> shouldClose = " + shouldClose + ", interceptScene = " + interceptScene + "\uff0cleft = " + left);
                if (1 == interceptScene || parent.ignoredDragEvent()) {
                    parent.smoothScrollToStart(view);
                    return;
                }
                if (parent.onlyListenToFastSwipe() || 2 == interceptScene || left <= 0) {
                    ActivityDragInterceptor.this.resetLastActivityUI(this.viewOfLastActivity);
                    if (shouldClose) {
                        ActivityDragInterceptor.this.mActivity.finish();
                        ActivityDragInterceptor.this.mActivity.overridePendingTransition(R.anim.snake_slide_in_left, R.anim.snake_slide_out_right);
                    } else {
                        parent.smoothScrollToStart(view);
                        if (!parent.onlyListenToFastSwipe()) {
                            ActivityDragInterceptor.this.convertFromTranslucent(ActivityDragInterceptor.this.mActivity);
                            ActivityDragInterceptor.this.isTranslucent = false;
                        }
                    }
                    return;
                }
                ActivityDragInterceptor.this.resetLastActivityUI(this.viewOfLastActivity);
                if (shouldClose) {
                    parent.smoothScrollToLeave(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            ActivityDragInterceptor.this.mActivity.finish();
                            ActivityDragInterceptor.this.mActivity.overridePendingTransition(0, 0);
                            ActivityDragInterceptor.this.resetLastActivityUI(viewOfLastActivity);
                        }
                    });
                } else {
                    parent.smoothScrollToStart(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            ActivityDragInterceptor.this.convertFromTranslucent(ActivityDragInterceptor.this.mActivity);
                            ActivityDragInterceptor.this.isTranslucent = false;
                            ActivityDragInterceptor.this.resetLastActivityUI(viewOfLastActivity);
                        }
                    });
                }
            }
        });
        snakeLayout.setDragInterceptor(this);
    }

    private void resetLastActivityUI(View viewOfLastActivity) {
        if (null != viewOfLastActivity) {
            viewOfLastActivity.setX(0.0f);
        }
    }

    private void convertToTranslucent(Activity activity, TranslucentConversionListener listener) {
        if (this.needConvertToTranslucent(activity)) {
            ActivityHelper.convertToTranslucent(activity, listener);
        } else if (null != listener) {
            listener.onTranslucentConversionComplete(true);
        }
    }

    private boolean needConvertToTranslucent(Activity activity) {
        return !ActivityHelper.isTranslucent(activity);
    }

    private void convertFromTranslucent(Activity activity) {
        if (this.needConvertToTranslucent(activity)) {
            ActivityHelper.convertFromTranslucent(activity);
        }
    }

    @Override
    public int intercept(SnakeHackLayout parent, View view, int pointerId) {
        if (ActivityManager.get().isRootActivity(this.mActivity) && !SnakeConfigReader.get().enableForRootActivity()) {
            return 1;
        }
        if (!this.isTranslucent) {
            return 2;
        }
        return -1;
    }
}

