/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.config;

import android.annotation.SuppressLint;
import android.app.Application;
import android.graphics.Color;
import android.util.Xml;
import com.youngfeng.snake.config.SnakeConfig;
import com.youngfeng.snake.config.SnakeConfigException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SnakeConfigReader {
    private Application mApplication;
    @SuppressLint(value={"StaticFieldLeak"})
    private static SnakeConfigReader instance;
    private SnakeConfig mSnakeConfig = new SnakeConfig();

    private SnakeConfigReader() {
    }

    public static synchronized SnakeConfigReader get() {
        if (null == instance) {
            instance = new SnakeConfigReader();
        }
        return instance;
    }

    public void init(Application application) {
        this.mApplication = application;
        try {
            InputStream inputStream = application.getAssets().open("snake.xml");
            if (null != inputStream) {
                this.readSnakeConfigIn(inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSnakeConfigIn(InputStream inputStream) {
        if (null == inputStream) {
            return;
        }
        XmlPullParser parser = Xml.newPullParser();
        try {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(inputStream, "utf-8");
            parser.nextTag();
            parser.nextTag();
            parser.require(2, null, "config");
            while (3 != parser.next()) {
                if (2 != parser.getEventType()) continue;
                String name = parser.getName();
                parser.require(2, null, name);
                String tagValue = this.readText(parser);
                switch (name) {
                    case "enable_for_root_activity": {
                        if (!"true".equals(tagValue) && !"false".equals(tagValue)) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of boolean values. eg: true or false, current value: " + tagValue);
                        }
                        this.mSnakeConfig.enableForRootActivity = Boolean.parseBoolean(tagValue);
                        break;
                    }
                    case "only_listen_to_fast_swipe": {
                        if (!"true".equals(tagValue) && !"false".equals(tagValue)) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of boolean values. eg: true or false, current value: " + tagValue);
                        }
                        this.mSnakeConfig.onlyListenToFastSwipe = Boolean.parseBoolean(tagValue);
                        break;
                    }
                    case "min_velocity": {
                        try {
                            this.mSnakeConfig.minVelocity = Integer.parseInt(tagValue);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of integer values, current value: " + tagValue);
                        }
                    }
                    case "hide_shadow_of_edge": {
                        if (!"true".equals(tagValue) && !"false".equals(tagValue)) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of boolean values. eg: true or false, current value: " + tagValue);
                        }
                        this.mSnakeConfig.hideShadowOfEdge = Boolean.parseBoolean(tagValue);
                        break;
                    }
                    case "shadow_start_color": {
                        try {
                            this.mSnakeConfig.shadowStartColor = Color.parseColor((String)tagValue);
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of color string, eg: #ff0000, current value: " + tagValue);
                        }
                    }
                    case "shadow_end_color": {
                        try {
                            this.mSnakeConfig.shadowEndColor = Color.parseColor((String)tagValue);
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of color string, eg: #ff0000, current value: " + tagValue);
                        }
                    }
                    case "enable_swipe_up_to_home": {
                        if (!"true".equals(tagValue) && !"false".equals(tagValue)) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of boolean values. eg: true or false, current value: " + tagValue);
                        }
                        this.mSnakeConfig.enableSwipeUpToHome = Boolean.parseBoolean(tagValue);
                        break;
                    }
                    case "allow_page_linkage": {
                        if (!"true".equals(tagValue) && !"false".equals(tagValue)) {
                            throw new SnakeConfigException("The tag " + name + " only allows the use of boolean values. eg: true or false, current value: " + tagValue);
                        }
                        this.mSnakeConfig.allowPageLinkage = Boolean.parseBoolean(tagValue);
                    }
                }
                parser.require(3, null, name);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == 4) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    public boolean enableForRootActivity() {
        return this.mSnakeConfig.enableForRootActivity;
    }

    public boolean onlyListenToFastSwipe() {
        return this.mSnakeConfig.onlyListenToFastSwipe;
    }

    public int minVelocity() {
        return this.mSnakeConfig.minVelocity;
    }

    public boolean hideShadowOfEdge() {
        return this.mSnakeConfig.hideShadowOfEdge;
    }

    public int shadowStartColor() {
        return this.mSnakeConfig.shadowStartColor;
    }

    public int shadowEndColor() {
        return this.mSnakeConfig.shadowEndColor;
    }

    public boolean swipeUpToHomeEnabled() {
        return this.mSnakeConfig.enableSwipeUpToHome;
    }

    public boolean allowPageLinkage() {
        return this.mSnakeConfig.allowPageLinkage;
    }
}

