/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IOUtils {
    public static final int BUFFER_SIZE = 4096;
    public static final int MAX_STRING_LENGTH = 1024000;

    public static String getFacebookPhotoUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.getScheme() + "://" + uri.getHost() + uri.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    public static String changeUrlToName(String url) {
        String name = url.replaceAll(":", "_");
        name = name.replaceAll("//", "_");
        name = name.replaceAll("/", "_");
        name = name.replaceAll("=", "_");
        name = name.replaceAll(",", "_");
        name = name.replaceAll("&", "_");
        if ((name = name.replaceAll("\\?", "_")).length() > 200) {
            return name.substring(name.length() - 200);
        }
        return name;
    }

    public static boolean checkFileIsExist(String path, boolean isDir) {
        File file = new File(path);
        return file.exists() && isDir == file.isDirectory();
    }

    public static String getMd5Value(String str) {
        String md5Str = null;
        if (str != null && str.length() != 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(str.getBytes());
                byte[] b = md.digest();
                String hexString = IOUtils.bytesToHexString(b);
                md5Str = hexString.substring(8, 24);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                md5Str = IOUtils.changeUrlToName(str);
            }
        }
        return md5Str;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = IOUtils.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    public static void deleteAllFile(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            if (fileList != null && fileList.length > 0) {
                for (File f : fileList) {
                    IOUtils.deleteAllFile(f);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String charset) {
        if (file == null) {
            return null;
        }
        String data = null;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                if (out.size() <= 1024000) continue;
                Log.e((String)"IoUtils", (String)("File too large, maybe not a string. " + file.getAbsolutePath()));
                String string = null;
                return string;
            }
            data = out.toString(charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            data = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
            in = null;
            out = null;
            buffer = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStringToFile(String data, File file, String charset) {
        if (file == null || data == null) {
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(data.getBytes(charset));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveInputStreamToFile(InputStream in, File file) {
        if (file == null || in == null) {
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            byte[] data = new byte[4096];
            int count = -1;
            while ((count = in.read(data)) >= 0) {
                ((OutputStream)out).write(data, 0, count);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileToOutputStream(OutputStream out, File file, boolean catchException) throws IOException {
        if (file == null || out == null) {
            return false;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[4096];
            int count = -1;
            while ((count = ((InputStream)in).read(data)) >= 0) {
                out.write(data, 0, count);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (!catchException) {
                throw e;
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String createUrl(String url, String name, String[] params, String[] values) {
        if (url == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(url);
        if (name != null) {
            if (!url.endsWith("/")) {
                sb.append('/');
            }
            sb.append(name);
        }
        if (params != null && values != null) {
            sb.append("?");
            int len = Math.min(params.length, values.length);
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append("&");
                }
                sb.append(params[i]);
                sb.append("=");
                sb.append(values[i]);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream in, String charset) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            byte[] data = new byte[4096];
            int count = -1;
            while ((count = in.read(data)) >= 0) {
                outStream.write(data, 0, count);
                if (outStream.size() <= 1024000) continue;
                Log.e((String)"IoUtils", (String)"Data too large, maybe not a string. ");
                String string = null;
                return string;
            }
            data = null;
            String string = new String(outStream.toByteArray(), charset);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static float byteToMb(long size) {
        float mb = (float)size / 1024.0f / 1024.0f;
        return (float)Math.round(mb * 100.0f) / 100.0f;
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (!path.exists()) {
            path.mkdirs();
        }
        if (IOUtils.hasGingerbread()) {
            try {
                Method getUsableSpace = File.class.getMethod("getUsableSpace", new Class[0]);
                if (getUsableSpace != null) {
                    return (Long)getUsableSpace.invoke((Object)path, (Object[])null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0L;
            }
        }
        try {
            StatFs stats = new StatFs(path.getPath());
            return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAssetFileToSD(AssetManager am, File destinationfile, String assetsfileName) {
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            int count;
            inputStream = am.open(assetsfileName);
            destinationfile.createNewFile();
            if (!destinationfile.isFile() || !destinationfile.canWrite()) {
                throw new IOException();
            }
            outputStream = new FileOutputStream(destinationfile);
            byte[] buf = new byte[2048];
            while ((count = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static File getCacheDir(Context context, String uniqueName) {
        String cachePath = null;
        try {
            cachePath = "mounted".equals(Environment.getExternalStorageState()) || !IOUtils.isExternalStorageRemovable() ? IOUtils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cachePath == null) {
            return null;
        }
        return new File(cachePath, uniqueName);
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        if (IOUtils.hasFroyo()) {
            try {
                Method getExternalCacheDir = Context.class.getMethod("getExternalCacheDir", new Class[0]);
                if (getExternalCacheDir != null) {
                    File file = (File)getExternalCacheDir.invoke((Object)context, (Object[])null);
                    if (file == null) {
                        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
                        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
                    }
                    return file;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
    }

    private static boolean hasFroyo() {
        return Build.VERSION.SDK_INT >= 8;
    }

    private static boolean hasGingerbread() {
        return Build.VERSION.SDK_INT >= 9;
    }

    @TargetApi(value=9)
    public static boolean isExternalStorageRemovable() {
        if (IOUtils.hasGingerbread()) {
            try {
                Method isExternalStorageRemovable = Environment.class.getMethod("isExternalStorageRemovable", new Class[0]);
                if (isExternalStorageRemovable != null) {
                    return (Boolean)isExternalStorageRemovable.invoke(null, (Object[])null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public static String getDownloadPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/yoogor/download";
    }

    public static String getPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/yoogor";
    }

    public static String getCachePath() {
        return IOUtils.getPath() + "/.cache";
    }

    public static String getTempImgPath() {
        return IOUtils.getPath() + "/img";
    }
}

