/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.utils;

import java.io.Serializable;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;

public class CookieStore
implements CookieJar {
    private final ConcurrentHashMap<URI, List<Cookie>> cookies = new ConcurrentHashMap();

    public synchronized void saveFromResponse(HttpUrl url, List<okhttp3.Cookie> cookies) {
        for (okhttp3.Cookie cookie : cookies) {
            this.add(url.uri(), new Cookie(cookie));
        }
    }

    public synchronized List<okhttp3.Cookie> loadForRequest(HttpUrl url) {
        ArrayList<okhttp3.Cookie> ret = new ArrayList<okhttp3.Cookie>();
        List<Cookie> httpCookies = this.get(url.uri());
        for (Cookie cookie : httpCookies) {
            ret.add(cookie.conventToOk3Cookie());
        }
        return ret;
    }

    public static CookieStore getInstance() {
        return Instance.cookieStore;
    }

    private void add(URI uri, Cookie cookie) {
        if (cookie == null || uri == null) {
            return;
        }
        if (!this.cookies.containsKey(uri)) {
            this.cookies.put(uri, new ArrayList());
        }
        this.cookies.get(uri).clear();
        this.cookies.get(uri).add(cookie);
    }

    private List<Cookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        List<Cookie> cookiesForUri = this.cookies.get(uri);
        if (cookiesForUri != null) {
            Iterator<Cookie> i = cookiesForUri.iterator();
            while (i.hasNext()) {
                Cookie cookie = i.next();
                if (cookie.expires) {
                    i.remove();
                    continue;
                }
                result.add(cookie);
            }
        }
        for (Map.Entry<URI, List<Cookie>> entry : this.cookies.entrySet()) {
            if (uri.equals(entry.getKey())) continue;
            List<Cookie> entryCookies = entry.getValue();
            Iterator<Cookie> i = entryCookies.iterator();
            while (i.hasNext()) {
                Cookie cookie = i.next();
                HttpUrl httpUrl = HttpUrl.parse((String)uri.toString());
                if (!CookieStore.domainMatch(httpUrl, cookie.domain)) continue;
                if (cookie.expires) {
                    i.remove();
                    continue;
                }
                if (result.contains(cookie)) continue;
                result.add(cookie);
            }
        }
        return result;
    }

    private static boolean domainMatch(HttpUrl url, String domain) {
        String urlHost = url.host();
        if (urlHost.equals(domain)) {
            return true;
        }
        return urlHost.endsWith(domain) && urlHost.charAt(urlHost.length() - domain.length() - 1) == '.' && !Util.verifyAsIpAddress((String)urlHost);
    }

    private CookieStore() {
    }

    public synchronized boolean removeAll() {
        this.cookies.clear();
        return true;
    }

    private static class Cookie
    implements Serializable {
        private String comment;
        private String commenturl;
        private boolean discard;
        private String domain;
        private boolean expires;
        private long max_age;
        private String path;
        private String port;
        private boolean secure;
        private int version;
        private String name;
        private String value;

        public Cookie(HttpCookie cookie) {
            this.comment = cookie.getComment();
            this.commenturl = cookie.getCommentURL();
            this.discard = cookie.getDiscard();
            this.domain = cookie.getDomain();
            this.expires = cookie.hasExpired();
            this.max_age = cookie.getMaxAge();
            this.path = cookie.getPath();
            this.port = cookie.getPortlist();
            this.secure = cookie.getSecure();
            this.version = cookie.getVersion();
            this.name = cookie.getName();
            this.value = cookie.getValue();
        }

        public Cookie(okhttp3.Cookie cookie) {
            this.comment = "";
            this.commenturl = "";
            this.discard = false;
            this.domain = cookie.domain();
            this.expires = false;
            this.max_age = cookie.expiresAt();
            this.path = cookie.path();
            this.port = "";
            this.secure = cookie.secure();
            this.version = 0;
            this.name = cookie.name();
            this.value = cookie.value();
        }

        public HttpCookie convenToHttpCookie() {
            HttpCookie httpCookie = new HttpCookie(this.name, this.value);
            httpCookie.setComment(this.comment);
            httpCookie.setCommentURL(this.commenturl);
            httpCookie.setDiscard(this.discard);
            httpCookie.setDomain(this.domain);
            httpCookie.setMaxAge(this.max_age);
            httpCookie.setPath(this.path);
            httpCookie.setPortlist(this.port);
            httpCookie.setSecure(this.secure);
            httpCookie.setVersion(this.version);
            return httpCookie;
        }

        public okhttp3.Cookie conventToOk3Cookie() {
            Cookie.Builder builder = new Cookie.Builder();
            builder.domain(this.domain);
            builder.expiresAt(this.max_age);
            builder.name(this.name);
            builder.value(this.value);
            builder.path(this.path);
            okhttp3.Cookie cookie = builder.build();
            return cookie;
        }
    }

    static class Instance {
        static CookieStore cookieStore = new CookieStore();

        Instance() {
        }
    }
}

