/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.http;

import android.util.Pair;
import com.yoogor.abc.network.http.OkRequestHelper;
import com.yoogor.abc.network.http.interf.CacheCallback;
import com.yoogor.abc.network.http.interf.DownloadCallback;
import com.yoogor.abc.network.http.interf.HttpCallback;
import com.yoogor.abc.network.http.interf.UploadCallback;
import java.util.List;
import java.util.Map;

public class RequestBuilder {
    private OkRequestHelper requestHelper = new OkRequestHelper();

    private RequestBuilder() {
    }

    public static RequestBuilder newBuilder() {
        return new RequestBuilder();
    }

    public RequestBuilder url(String url) {
        this.requestHelper.url(url);
        return this;
    }

    public RequestBuilder hostAndPath(String host, String path) {
        this.requestHelper.hostAndPath(host, path);
        return this;
    }

    public RequestBuilder param(Map<String, String> param) {
        this.requestHelper.setParams(param);
        return this;
    }

    public RequestBuilder desc(String desc) {
        this.requestHelper.setDesc(desc);
        return this;
    }

    public RequestBuilder cache(CacheCallback cacheCallback) {
        this.requestHelper.setSaveCache(cacheCallback);
        return this;
    }

    public RequestBuilder header(Map<String, String> headers) {
        this.requestHelper.setRequestHeader(headers);
        return this;
    }

    public RequestBuilder fileDestPath(boolean overWrite, String fileDestPath) {
        this.requestHelper.setFileDestPath(overWrite, fileDestPath);
        return this;
    }

    public RequestBuilder files(String[] files) {
        this.requestHelper.setFiles(files);
        return this;
    }

    public RequestBuilder files(List<Pair<String, String>> files) {
        this.requestHelper.setFiles(files);
        return this;
    }

    public RequestBuilder files(Map<String, Pair<String, String>> files) {
        this.requestHelper.setFiles(files);
        return this;
    }

    public RequestBuilder uploadProgressCallback(UploadCallback callback) {
        this.requestHelper.setUploadProgressCallback(callback);
        return this;
    }

    public RequestBuilder downloadProgressCallback(DownloadCallback callback) {
        this.requestHelper.setDownloadProgressCallback(callback);
        return this;
    }

    public RequestBuilder httpCallback(HttpCallback callback) {
        this.requestHelper.setHttpCallback(callback);
        return this;
    }

    public RequestBuilder tag(int tag) {
        this.requestHelper.tag(tag);
        return this;
    }

    public OkRequestHelper build() {
        return this.requestHelper;
    }
}

