/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.http;

import android.text.TextUtils;
import com.yoogor.abc.network.http.interf.StatusCode;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpException
extends Exception {
    private int httpCode = -1;
    private StatusCode statusCode = StatusCode.ERROR_OTHER;
    private String msg;

    public HttpException() {
    }

    public HttpException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public HttpException(StatusCode code, String msg) {
        super(msg);
        this.statusCode = code;
        this.msg = msg;
        if (code == StatusCode.ERROR_CONNECTION_NONE) {
            this.msg = "\u7f51\u7edc\u672a\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e";
        } else if (code == StatusCode.ERROR_CONNECTION) {
            this.msg = "\u5f53\u524d\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e";
        } else if (code == StatusCode.ERROR_BIND) {
            this.msg = "\u8bf7\u6c42\u5931\u8d25";
        } else if (code == StatusCode.ERROR_SOCKET_TIME_OUT) {
            this.msg = "\u8bf7\u6c42\u8d85\u65f6";
        } else if (code != StatusCode.OK && !TextUtils.isEmpty((CharSequence)msg) && msg.contains("Canceled")) {
            this.msg = "\u8bf7\u6c42\u5df2\u53d6\u6d88";
        } else if (code == StatusCode.ERROR_OTHER) {
            this.msg = !TextUtils.isEmpty((CharSequence)msg) && msg.startsWith("Unable to resolve host") ? "\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5" : "\u8bf7\u6c42\u5931\u8d25";
        }
    }

    public HttpException(int httpCode, String msg) {
        super(msg);
        this.httpCode = httpCode;
        this.msg = msg;
        if (httpCode >= 500) {
            this.msg = "\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        } else if (httpCode >= 400) {
            this.msg = "\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        }
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = this.msg;
        }
        return message;
    }

    @Override
    public String toString() {
        return "httpCode:" + this.httpCode + ";statusCode:" + this.statusCode.getMsg() + ";msg:" + this.msg;
    }

    public String toJsonString() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("httpCode", this.httpCode);
            obj.put("statusCode", (Object)this.statusCode.getMsg());
            obj.put("msg", (Object)(this.msg + ""));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj.toString();
    }
}

