/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.bridge;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.view.View;

public class ContextWrapper {
    private Activity activity = null;
    private Fragment fragment = null;
    private View view;
    private ContextType contextType = ContextType.TYPE_ACTIVITY;

    public ContextWrapper(Activity activity) {
        this.activity = activity;
        this.contextType = ContextType.TYPE_ACTIVITY;
    }

    public ContextWrapper(Fragment fragment) {
        this.fragment = fragment;
        this.contextType = ContextType.TYPE_FRAGMENT;
    }

    public ContextWrapper(View view) {
        this.view = view;
        this.contextType = ContextType.TYPE_VIEW;
    }

    public ContextType getContextType() {
        return this.contextType;
    }

    public Context getContext() {
        switch (this.contextType) {
            case TYPE_VIEW: {
                return this.view.getContext();
            }
            case TYPE_FRAGMENT: {
                return this.fragment.getActivity();
            }
            case TYPE_ACTIVITY: {
                return this.activity;
            }
        }
        return null;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public View getView() {
        return this.view;
    }

    public static enum ContextType {
        TYPE_VIEW,
        TYPE_FRAGMENT,
        TYPE_ACTIVITY;

    }
}

