/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.demo.orm.utils;

import android.text.TextUtils;
import com.yoogor.demo.orm.extra.AutoIncrementTableColumn;
import com.yoogor.demo.orm.extra.Extra;
import com.yoogor.demo.orm.extra.TableColumn;
import com.yoogor.demo.orm.extra.TableInfo;
import com.yoogor.demo.orm.utils.FieldUtils;
import com.yoogor.demo.orm.utils.Logger;
import java.util.ArrayList;
import java.util.List;

public class SqlUtils {
    public static String getTableSql(TableInfo table) {
        TableColumn primaryKey = table.getPrimaryKey();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("CREATE TABLE IF NOT EXISTS ");
        strSQL.append(table.getTableName());
        strSQL.append(" ( ");
        if (primaryKey instanceof AutoIncrementTableColumn) {
            strSQL.append(" ").append(primaryKey.getColumn()).append(" ").append(" INTEGER PRIMARY KEY AUTOINCREMENT ,");
        } else {
            strSQL.append(" ").append(primaryKey.getColumn()).append(" ").append(primaryKey.getColumnType()).append(" NOT NULL ,");
        }
        for (TableColumn column : table.getColumns()) {
            strSQL.append(" ").append(column.getColumn());
            strSQL.append(" ").append(column.getColumnType());
            strSQL.append(" ,");
        }
        strSQL.append(" ").append("com_m_common_owner").append(" text NOT NULL, ");
        strSQL.append(" ").append("com_m_common_key").append(" text NOT NULL, ");
        strSQL.append(" ").append("com_m_common_createat").append(" INTEGER NOT NULL ");
        if (!(primaryKey instanceof AutoIncrementTableColumn)) {
            strSQL.append(", PRIMARY KEY ( ").append(primaryKey.getColumn()).append(" , ").append("com_m_common_key").append(" , ").append("com_m_common_owner").append(" )");
        }
        strSQL.append(" )");
        String tableStr = strSQL.toString();
        Logger.d("SqliteUtility", "create table = " + tableStr);
        return tableStr;
    }

    public static String createSqlInsert(String insertInto, TableInfo tableInfo) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        if (!(tableInfo.getPrimaryKey() instanceof AutoIncrementTableColumn)) {
            columns.add(tableInfo.getPrimaryKey());
        }
        columns.addAll(tableInfo.getColumns());
        columns.add(FieldUtils.getOwnerColumn());
        columns.add(FieldUtils.getKeyColumn());
        columns.add(FieldUtils.getCreateAtColumn());
        StringBuilder builder = new StringBuilder(insertInto);
        builder.append(tableInfo.getTableName()).append(" (");
        SqlUtils.appendColumns(builder, columns);
        builder.append(") VALUES (");
        SqlUtils.appendPlaceholders(builder, columns.size());
        builder.append(')');
        return builder.toString();
    }

    public static StringBuilder appendColumns(StringBuilder builder, List<TableColumn> columns) {
        int length = columns.size();
        for (int i = 0; i < length; ++i) {
            builder.append('\'').append(columns.get(i).getColumn()).append('\'');
            if (i >= length - 1) continue;
            builder.append(',');
        }
        return builder;
    }

    public static StringBuilder appendPlaceholders(StringBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            if (i < count - 1) {
                builder.append("?,");
                continue;
            }
            builder.append('?');
        }
        return builder;
    }

    public static String appendExtraWhereClauseSql(Extra extra) {
        StringBuffer sb = new StringBuffer();
        if (extra == null || TextUtils.isEmpty((CharSequence)extra.getKey()) && TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append("");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getKey()) && !TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append(" ").append("com_m_common_owner").append(" = '").append(extra.getOwner()).append("' ").append(" and ").append("com_m_common_key").append(" = '").append(extra.getKey()).append("' ");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getKey())) {
            sb.append("com_m_common_key").append(" = '").append(extra.getKey()).append("' ");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append(" ").append("com_m_common_owner").append(" = '").append(extra.getOwner()).append("' ");
        }
        return sb.toString();
    }

    public static String appendExtraWhereClause(Extra extra) {
        StringBuffer sb = new StringBuffer();
        if (extra == null || TextUtils.isEmpty((CharSequence)extra.getKey()) && TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append("");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getKey()) && !TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append(" ").append("com_m_common_key").append(" = ? ").append(" and ").append("com_m_common_owner").append(" = ? ");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getKey())) {
            sb.append("com_m_common_key").append(" = ? ");
        } else if (!TextUtils.isEmpty((CharSequence)extra.getOwner())) {
            sb.append(" ").append("com_m_common_owner").append(" = ? ");
        }
        return sb.toString();
    }

    public static String[] appendExtraWhereArgs(Extra extra) {
        ArrayList<String> argList = new ArrayList<String>();
        if (extra != null) {
            if (!TextUtils.isEmpty((CharSequence)extra.getKey())) {
                argList.add(extra.getKey());
            }
            if (!TextUtils.isEmpty((CharSequence)extra.getOwner())) {
                argList.add(extra.getOwner());
            }
        }
        return argList.toArray(new String[0]);
    }
}

