/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.demo.orm;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.yoogor.demo.orm.SqliteUtility;
import com.yoogor.demo.orm.utils.Logger;
import java.io.File;
import java.io.IOException;

public class SqliteUtilityBuilder {
    public static final String TAG = "SqliteUtility";
    static final String DEFAULT_DB = "com_m_default_db";
    private String path;
    private String dbName = "com_m_default_db";
    private int version = 1;
    private boolean sdcardDb = false;

    public SqliteUtilityBuilder configDBName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public SqliteUtilityBuilder configVersion(int version) {
        this.version = version;
        return this;
    }

    public SqliteUtilityBuilder configSdcardPath(String path) {
        this.path = path;
        this.sdcardDb = true;
        return this;
    }

    public SqliteUtility build(Context context) {
        SQLiteDatabase db = null;
        if (this.sdcardDb) {
            db = SqliteUtilityBuilder.openSdcardDb(this.path, this.dbName, this.version);
            Logger.d(TAG, String.format(String.format("\u6253\u5f00app\u5e93 %s, version = %d", this.dbName, db.getVersion()), new Object[0]));
        } else {
            db = new SqliteDbHelper(context, this.dbName, this.version).getWritableDatabase();
            Logger.d(TAG, String.format(String.format("\u6253\u5f00sdcard\u5e93 %s, version = %d", this.dbName, db.getVersion()), new Object[0]));
        }
        return new SqliteUtility(this.dbName, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLiteDatabase openSdcardDb(String path, String dbName, int version) {
        SQLiteDatabase db = null;
        File dbf = new File(path + File.separator + dbName + ".db");
        if (dbf.exists()) {
            Logger.d(TAG, "\u6253\u5f00\u5e93 %s", dbName);
            db = SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
        } else {
            dbf.getParentFile().mkdirs();
            try {
                if (dbf.createNewFile()) {
                    Logger.d(TAG, "\u65b0\u5efa\u4e00\u4e2a\u5e93\u5728sd\u5361, \u5e93\u540d = %s, \u8def\u5f84 = %s", dbName, dbf.getAbsolutePath());
                    db = SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                throw new RuntimeException("\u65b0\u5efa\u5e93\u5931\u8d25, \u5e93\u540d = " + dbName + ", \u8def\u5f84 = " + path, ioex);
            }
        }
        if (db != null) {
            int dbVersion = db.getVersion();
            Logger.d(TAG, "\u8868 %s \u7684version = %d, newVersion = %d", dbName, dbVersion, version);
            if (dbVersion < version) {
                SqliteUtilityBuilder.dropDb(db);
                db.beginTransaction();
                try {
                    db.setVersion(version);
                    db.setTransactionSuccessful();
                }
                catch (Exception exception) {
                }
                finally {
                    db.endTransaction();
                }
            }
            return db;
        }
        throw new RuntimeException("\u6253\u5f00\u5e93\u5931\u8d25, \u5e93\u540d = " + dbName + ", \u8def\u5f84 = " + path);
    }

    static void dropDb(SQLiteDatabase db) {
        Cursor cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type ='table' AND name != 'sqlite_sequence'", null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                db.execSQL("DROP TABLE " + cursor.getString(0));
                Logger.d(TAG, "\u5220\u9664\u8868 = " + cursor.getString(0));
            }
        }
        if (cursor != null) {
            cursor.close();
            cursor = null;
        }
    }

    static class SqliteDbHelper
    extends SQLiteOpenHelper {
        SqliteDbHelper(Context context, String dbName, int dbVersion) {
            super(context, dbName, null, dbVersion);
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            SqliteUtilityBuilder.dropDb(db);
            this.onCreate(db);
        }
    }
}

