/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.log;

import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.tencent.bugly.crashreport.CrashReport;
import com.tencent.mars.xlog.Log;
import com.tencent.mars.xlog.Xlog;
import com.yoogor.abc.log.LogCache;
import com.yoogor.abc.log.LogLevel;
import com.yoogor.abc.log.LogType;
import com.yoogor.abc.log.ReadLogCallback;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogUtil {
    private boolean debug = true;
    private static HandlerThread logThread = new HandlerThread("LogUtil");
    private static Handler handler = null;
    private final String action = "com.tencent.mars.xlog.subprocess.log";
    private String processName = "";
    private boolean isMainProcess = false;
    private Application application;
    private File file;
    private Runnable saveRunnable = new Runnable(){

        @Override
        public void run() {
            if (LogUtil.this.file != null) {
                LogCache.getInstace().save(LogUtil.this.file);
                handler.postDelayed((Runnable)this, 2000L);
            }
        }
    };

    private LogUtil() {
        logThread.start();
        handler = new Handler(logThread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                try {
                    Object object = msg.obj;
                    if (object != null && object instanceof LogEntity) {
                        ((LogEntity)object).printLog(LogUtil.this.debug);
                    }
                }
                catch (Throwable throwable) {
                    CrashReport.postCatchedException((Throwable)throwable);
                }
            }
        };
    }

    public void startReadLog() {
        handler.post(new Runnable(){

            @Override
            public void run() {
                LogCache.getInstace().startReadlog();
            }
        });
    }

    public void stopReadLog() {
        handler.post(new Runnable(){

            @Override
            public void run() {
                LogCache.getInstace().closeLog();
            }
        });
    }

    public void getNextPage(final int pageSize, final ReadLogCallback readLogCallback) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> result = new ArrayList<String>();
                result.addAll(LogCache.getInstace().readNextPage(pageSize));
                readLogCallback.onLogResult(result);
            }
        });
    }

    public void getPrevPage(final int pageSize, final ReadLogCallback readLogCallback) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> result = new ArrayList<String>();
                result.addAll(LogCache.getInstace().readPrevPage(pageSize));
                readLogCallback.onLogResult(result);
            }
        });
    }

    public void initXlog(Application application) {
        this.application = application;
        this.processName = this.getProcessName((Context)application);
        if (TextUtils.equals((CharSequence)application.getPackageName(), (CharSequence)this.processName)) {
            this.isMainProcess = true;
            this.file = new File(new File(application.getFilesDir(), "logCache"), "log").getAbsoluteFile();
            if (!this.file.exists()) {
                try {
                    if (!this.file.getParentFile().exists()) {
                        this.file.getParentFile().mkdirs();
                    }
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.file != null) {
                LogCache.getInstace().init(this.file);
                handler.postDelayed(this.saveRunnable, 2000L);
            }
            LocalBroadcastManager.getInstance((Context)application).registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent.hasExtra("extra") && intent.getSerializableExtra("extra") instanceof LogEntity) {
                        Message message = handler.obtainMessage();
                        LogEntity logEntity = (LogEntity)intent.getSerializableExtra("extra");
                        logEntity.processName = intent.getStringExtra("processName");
                        message.obj = logEntity;
                        message.sendToTarget();
                    }
                }
            }, new IntentFilter("com.tencent.mars.xlog.subprocess.log"));
            String logPath = new File(application.getFilesDir(), "xlog").getAbsolutePath();
            String logFileName = "log";
            if (this.debug) {
                Xlog.open((boolean)true, (int)0, (int)0, (String)"", (String)logPath, (String)logFileName, (String)"");
                Xlog.setConsoleLogOpen((boolean)true);
            } else {
                Xlog.open((boolean)true, (int)2, (int)0, (String)"", (String)logPath, (String)logFileName, (String)"");
                Xlog.setConsoleLogOpen((boolean)false);
            }
            Log.setLogImp((Log.LogImp)new Xlog());
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void printLog(LogLevel logLevel, String content) {
    }

    public static LogUtil getInstance() {
        return Instance.instance;
    }

    public static void LogObject(String tag, Object object) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.OBJECT, tag, object);
    }

    public static void LogJson(String tag, String message) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.JSON, tag, message);
    }

    public static void LogString(String tag, String message) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.STRING, tag, message);
    }

    public static void LogThrowable(String tag, Throwable throwable) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.THROWABLE, tag, throwable);
    }

    public static void LogNetwork(String tag, String message) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.NETWORK, tag, message);
    }

    public static void LogE(String tag, String message) {
        String header = LogUtil.getHeaderString();
        LogUtil.getInstance().sendMessage(header, LogType.KEYPOINT, tag, message);
    }

    private void sendMessage(String header, LogType logType, String tag, String content) {
        LogEntity logEntity = new LogEntity(header, logType, tag, content);
        if (this.isMainProcess) {
            Message message1 = handler.obtainMessage();
            message1.obj = logEntity;
            message1.sendToTarget();
        } else if (this.application != null) {
            Intent intent = new Intent("com.tencent.mars.xlog.subprocess.log");
            intent.putExtra("extra", (Serializable)logEntity);
            intent.putExtra("processName", this.processName);
            LocalBroadcastManager.getInstance((Context)this.application).sendBroadcast(intent);
        }
    }

    private void sendMessage(String header, LogType logType, String tag, Throwable content) {
        LogEntity logEntity = new LogEntity(header, logType, tag, content);
        if (this.isMainProcess) {
            Message message1 = handler.obtainMessage();
            message1.obj = logEntity;
            message1.sendToTarget();
        } else if (this.application != null) {
            Intent intent = new Intent("com.tencent.mars.xlog.subprocess.log");
            intent.putExtra("extra", (Serializable)logEntity);
            intent.putExtra("processName", this.processName);
            LocalBroadcastManager.getInstance((Context)this.application).sendBroadcast(intent);
        }
    }

    private void sendMessage(String header, LogType logType, String tag, Object content) {
        LogEntity logEntity = new LogEntity(header, logType, tag, content.toString());
        if (this.isMainProcess) {
            Message message1 = handler.obtainMessage();
            message1.obj = new LogEntity(header, logType, tag, content.toString());
            message1.sendToTarget();
        } else if (this.application != null) {
            Intent intent = new Intent("com.tencent.mars.xlog.subprocess.log");
            intent.putExtra("extra", (Serializable)logEntity);
            intent.putExtra("processName", this.processName);
            LocalBroadcastManager.getInstance((Context)this.application).sendBroadcast(intent);
        }
    }

    private static String getHeaderString() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String methodNameShort = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodNameShort).append(" ] ");
        return stringBuilder.toString();
    }

    private String getProcessName(Context context) {
        int pid = Process.myPid();
        String processName = null;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : am.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            processName = appProcess.processName;
            break;
        }
        return TextUtils.isEmpty(processName) ? "" : processName;
    }

    private static class LogEntity
    implements Serializable {
        private String header;
        private LogType logType;
        private String content;
        private String tag;
        private Throwable throwable;
        private String processName;

        public LogEntity(String header, LogType logType, String tag, String content) {
            this.tag = tag;
            this.header = header;
            this.logType = logType;
            this.content = content;
        }

        public LogEntity(String header, LogType logType, String tag, Throwable throwable) {
            this.header = header;
            this.logType = logType;
            this.tag = tag;
            this.throwable = throwable;
        }

        public void printLog(boolean debug) {
            if (!TextUtils.isEmpty((CharSequence)this.processName)) {
                this.header = "[" + this.processName + "]" + this.header;
            }
            if (this.logType == LogType.KEYPOINT) {
                if (debug) {
                    Log.e((String)this.tag, (String)(this.header + this.content));
                    LogCache.getInstace().appendLog("E", this.tag, this.header + this.content);
                } else {
                    Log.i((String)this.tag, (String)(this.header + this.content));
                }
            } else if (this.logType == LogType.NETWORK) {
                if (debug) {
                    Log.e((String)this.tag, (String)(this.header + this.content));
                    LogCache.getInstace().appendLog("E", this.tag, this.header + this.content);
                } else {
                    Log.d((String)this.tag, (String)(this.header + this.content));
                }
            } else if (this.logType == LogType.THROWABLE) {
                if (debug) {
                    Log.e((String)this.tag, (String)(this.header + android.util.Log.getStackTraceString((Throwable)this.throwable)));
                    LogCache.getInstace().appendLog("E", this.tag, this.header + android.util.Log.getStackTraceString((Throwable)this.throwable));
                } else {
                    Log.w((String)this.tag, (String)(this.header + android.util.Log.getStackTraceString((Throwable)this.throwable)));
                    CrashReport.postCatchedException((Throwable)this.throwable);
                }
            } else if (this.logType == LogType.STRING) {
                if (debug) {
                    Log.d((String)this.tag, (String)(this.header + this.content));
                    LogCache.getInstace().appendLog("D", this.tag, this.header + this.content);
                }
            } else if (this.logType == LogType.JSON) {
                if (debug) {
                    Log.e((String)this.tag, (String)(this.header + this.printJson(this.content)));
                    LogCache.getInstace().appendLog("E", this.tag, this.header + this.printJson(this.content));
                } else {
                    Log.d((String)this.tag, (String)(this.header + this.printJson(this.content)));
                }
            } else if (this.logType == LogType.OBJECT && debug) {
                Log.d((String)this.tag, (String)(this.header + this.content));
                LogCache.getInstace().appendLog("D", this.tag, this.header + this.content);
            }
        }

        private String printJson(String object) {
            String json;
            try {
                if (object.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(object);
                    json = jsonObject.toString(4);
                } else if (object.startsWith("{")) {
                    JSONArray jsonArray = new JSONArray(object);
                    json = jsonArray.toString(4);
                } else {
                    json = object;
                }
            }
            catch (JSONException e) {
                json = object;
            }
            return json;
        }
    }

    private static class Instance {
        static LogUtil instance = new LogUtil();

        private Instance() {
        }
    }
}

