/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.log;

import com.yoogor.abc.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class LogCache {
    private List<String> logList = new CopyOnWriteArrayList<String>();
    private String readPrevIterator;
    private String readNextIterator;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");

    static LogCache getInstace() {
        return Instance.logCache;
    }

    private LogCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(File file) {
        LogCache logCache = this;
        synchronized (logCache) {
            FileInputStream bis = null;
            try {
                bis = new FileInputStream(file);
                ObjectInputStream is = new ObjectInputStream(bis);
                List data1 = (List)is.readObject();
                if (data1 != null) {
                    this.logList.addAll(0, data1);
                }
            }
            catch (Exception e) {
                LogUtil.LogThrowable("logCache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendLog(String logType, String logTag, String logContent) {
        LogCache logCache = this;
        synchronized (logCache) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append("[" + logType + "]");
            stringBuilder.append(this.simpleDateFormat.format(new Date()));
            stringBuilder.append(logTag);
            stringBuilder.append(":");
            stringBuilder.append(logContent);
            stringBuilder.trimToSize();
            this.logList.add(stringBuilder.toString());
            this.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(File file) {
        LogCache logCache = this;
        synchronized (logCache) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(outputStream);
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(this.logList);
                os.flush();
            }
            catch (Exception e) {
                LogUtil.LogThrowable("logCache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startReadlog() {
        LogCache logCache = this;
        synchronized (logCache) {
            this.readPrevIterator = this.logList.isEmpty() ? null : this.logList.get(this.logList.size() - 1);
            this.readNextIterator = this.logList.isEmpty() ? null : this.logList.get(this.logList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLog() {
        LogCache logCache = this;
        synchronized (logCache) {
            this.readPrevIterator = null;
            this.readNextIterator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> readNextPage(int pageSize) {
        LogCache logCache = this;
        synchronized (logCache) {
            ArrayList<String> pageData = new ArrayList<String>();
            if (this.readNextIterator == null) {
                this.startReadlog();
            }
            if (this.readNextIterator != null && this.logList.contains(this.readPrevIterator)) {
                ListIterator<String> iterator = this.logList.listIterator(this.logList.indexOf(this.readNextIterator) + 1);
                while (iterator.hasNext() && pageData.size() < pageSize) {
                    pageData.add(iterator.next());
                }
                if (!pageData.isEmpty()) {
                    this.readNextIterator = (String)pageData.get(pageData.size() - 1);
                }
            }
            return pageData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> readPrevPage(int pageSize) {
        LogCache logCache = this;
        synchronized (logCache) {
            ArrayList<String> pageData = new ArrayList<String>();
            if (this.readNextIterator == null) {
                this.startReadlog();
            }
            if (this.readPrevIterator != null && this.logList.contains(this.readPrevIterator)) {
                ListIterator<String> iterator = this.logList.listIterator(this.logList.indexOf(this.readPrevIterator));
                while (iterator.hasPrevious() && pageData.size() < pageSize) {
                    pageData.add(0, iterator.previous());
                }
                if (!pageData.isEmpty()) {
                    this.readPrevIterator = (String)pageData.get(0);
                }
            }
            return pageData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize() {
        LogCache logCache = this;
        synchronized (logCache) {
            if (this.logList.size() > 1000) {
                this.logList.removeAll(this.logList.subList(0, this.logList.size() - 900));
            }
        }
    }

    static class Instance {
        private static LogCache logCache = new LogCache();

        Instance() {
        }
    }
}

