/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher.utils;

import android.util.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceHelper {
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 128;
    private static final int KEEP_ALIVE_TIME = 30;
    private static SynchronousQueue<Runnable> syncQueue = new SynchronousQueue();
    private static ThreadFactory factory = new ThreadFactory(){
        AtomicInteger atomic = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Log.i((String)"new Thread", (String)(this.atomic.incrementAndGet() + ""));
            return new Thread(r);
        }
    };
    private static ExecutorServiceHelper helper;
    private static ExecutorService executor;

    private ExecutorServiceHelper() {
    }

    public static ExecutorService buildExecutorService(int size) {
        return new ThreadPoolExecutor(size, size, 30L, TimeUnit.SECONDS, syncQueue, factory, new ThreadPoolExecutor.DiscardPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorServiceHelper getInstance() {
        if (helper != null) return helper;
        Class<ExecutorServiceHelper> var0 = ExecutorServiceHelper.class;
        Class<ExecutorServiceHelper> clazz = ExecutorServiceHelper.class;
        synchronized (ExecutorServiceHelper.class) {
            if (helper != null) return helper;
            helper = new ExecutorServiceHelper();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return helper;
        }
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return executor.submit(callable);
    }

    public void execRun(Runnable run) {
        executor.execute(run);
    }

    public void shutExecutor() {
        executor.shutdown();
    }

    public void shutExecutorNow() {
        executor.shutdownNow();
    }

    static {
        executor = new ThreadPoolExecutor(4, 128, 30L, TimeUnit.SECONDS, syncQueue, factory, new ThreadPoolExecutor.DiscardPolicy());
    }

    public static abstract class RunnableImpl
    implements Runnable {
        public RunnableImpl() {
            ExecutorServiceHelper.getInstance().execRun(this);
        }
    }
}

