/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher.entity;

import com.yoogor.abc.dispatcher.AppNotifier;
import com.yoogor.abc.dispatcher.IRequestDispatcherImpl;
import com.yoogor.abc.dispatcher.entity.BaseParam;
import com.yoogor.abc.dispatcher.entity.BaseResponse;
import com.yoogor.abc.dispatcher.entity.ExecTaskEntity;
import com.yoogor.abc.dispatcher.entity.MessageFilter;
import com.yoogor.abc.dispatcher.interf.IWorkTask;
import com.yoogor.abc.dispatcher.utils.ExecutorServiceHelper;
import com.yoogor.abc.log.LogUtil;
import java.util.UUID;

public abstract class BaseDataManger {
    public <T extends BaseResponse> MessageFilter<T> request(BaseParam param, T responseType) {
        MessageFilter messageFilter = new MessageFilter();
        UUID uuid = UUID.randomUUID();
        messageFilter.setUuid(uuid);
        IRequestDispatcherImpl.instance().sendRequest(param, responseType, uuid);
        return messageFilter;
    }

    public <T extends BaseResponse> MessageFilter<T> execWorkTask(IWorkTask<T> workTask) {
        MessageFilter messageFilter = new MessageFilter();
        UUID uuid = UUID.randomUUID();
        messageFilter.setUuid(uuid);
        this.executeTask(uuid, workTask);
        return messageFilter;
    }

    private <T extends BaseResponse> void executeTask(final UUID uuid, final IWorkTask<T> workTask) {
        ExecutorServiceHelper.getInstance().execRun(new Runnable(){

            @Override
            public void run() {
                BaseResponse result = null;
                try {
                    result = (BaseResponse)workTask.execute();
                }
                catch (Exception e) {
                    LogUtil.LogThrowable((String)"BaseDataManager", (Throwable)e);
                }
                ExecTaskEntity execTaskEntity = new ExecTaskEntity(uuid, result);
                AppNotifier.instance().notify(execTaskEntity);
            }
        });
    }
}

