/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yoogor.abc.dispatcher.AppNotifier;
import com.yoogor.abc.dispatcher.entity.MessageFilter;
import com.yoogor.abc.dispatcher.interf.IMessageDispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class MessageDispatcher
implements IMessageDispatcher {
    static Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            for (MessageDispatcher messageDispatcher : messageDispatcherListHashMap.keySet()) {
                List<MessageFilter> messageFilters = messageDispatcherListHashMap.get(messageDispatcher);
                if (messageFilters == null) {
                    messageDispatcherListHashMap.remove(messageDispatcher);
                    continue;
                }
                Iterator<MessageFilter> iterator = messageFilters.iterator();
                while (iterator.hasNext()) {
                    MessageFilter filter = iterator.next();
                    if (!filter.compare(msg)) continue;
                    filter.getFilterTask().onExcute(filter.getResult(msg));
                    iterator.remove();
                    messageDispatcher.unRegister(filter);
                }
            }
        }
    };
    static Map<MessageDispatcher, List<MessageFilter>> messageDispatcherListHashMap;
    private AtomicBoolean attached = new AtomicBoolean(true);

    @Override
    public void register(final MessageFilter messageFilter) {
        if (!this.attached.get()) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (!messageDispatcherListHashMap.containsKey(MessageDispatcher.this)) {
                    messageDispatcherListHashMap.put(MessageDispatcher.this, new ArrayList());
                }
                messageDispatcherListHashMap.get(MessageDispatcher.this).add(messageFilter);
            }
        });
    }

    @Override
    public void unRegister(final MessageFilter messageFilter) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (messageDispatcherListHashMap.containsKey(MessageDispatcher.this)) {
                    List<MessageFilter> messageFilters = messageDispatcherListHashMap.get(MessageDispatcher.this);
                    messageFilters.remove(messageFilter);
                    if (messageFilters.isEmpty()) {
                        messageDispatcherListHashMap.remove(MessageDispatcher.this);
                    }
                }
            }
        });
    }

    public void clearMessageFilter() {
        if (messageDispatcherListHashMap.containsKey(this)) {
            messageDispatcherListHashMap.remove(this);
        }
    }

    public void register(AppNotifier appNotifier) {
        this.attached.set(true);
    }

    public void unRegister(AppNotifier appNotifier) {
        this.attached.set(false);
        if (messageDispatcherListHashMap.containsKey(this)) {
            messageDispatcherListHashMap.remove(this);
        }
    }

    static {
        AppNotifier.instance().registerObserver(handler);
        messageDispatcherListHashMap = new ConcurrentHashMap<MessageDispatcher, List<MessageFilter>>();
    }
}

