/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher;

import android.os.Handler;
import android.os.Message;
import com.yoogor.abc.dispatcher.interf.INotifyEntity;
import com.yoogor.abc.log.LogUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AppNotifier {
    public static final int TYPE_APP_NOTIFY = 4097;
    private static final String TAG = AppNotifier.class.getSimpleName();
    private static List<ObServer> obServers = new ArrayList<ObServer>();

    private AppNotifier() {
    }

    public static AppNotifier instance() {
        return Instance.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(Handler handler) {
        List<ObServer> list = obServers;
        synchronized (list) {
            Iterator<ObServer> it = obServers.iterator();
            while (it.hasNext()) {
                ObServer obServer = it.next();
                Handler hand = (Handler)obServer.handlerWeakReference.get();
                if (hand != null && !hand.equals(handler)) continue;
                it.remove();
            }
            obServers.add(new ObServer(handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegistrObserver(Handler handler) {
        List<ObServer> list = obServers;
        synchronized (list) {
            Iterator<ObServer> it = obServers.iterator();
            while (it.hasNext()) {
                ObServer obServer = it.next();
                Handler hand = (Handler)obServer.handlerWeakReference.get();
                if (hand != null && !hand.equals(handler)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(INotifyEntity requestEntity) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 3;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String methodNameShort = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodNameShort).append(" ] ");
        LogUtil.LogE((String)TAG, (String)("\u6536\u5230\u6d88\u606f:\u6765\u81ea------------>" + stringBuilder.toString()));
        List<ObServer> list = obServers;
        synchronized (list) {
            Iterator<ObServer> it = obServers.iterator();
            while (it.hasNext()) {
                ObServer obServer = it.next();
                Handler handler = (Handler)obServer.handlerWeakReference.get();
                if (handler == null) {
                    it.remove();
                    continue;
                }
                Message message = handler.obtainMessage();
                message.obj = requestEntity;
                message.what = 4097;
                message.sendToTarget();
            }
        }
    }

    private static class ObServer {
        WeakReference<Handler> handlerWeakReference;

        ObServer(Handler handler) {
            this.handlerWeakReference = new WeakReference<Handler>(handler);
        }
    }

    static class Instance {
        static AppNotifier instance = new AppNotifier();

        Instance() {
        }
    }
}

