/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.util.AnnoUtil;
import com.yomahub.liteflow.context.ContextBean;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ScriptExecutor {
    public ScriptExecutor init() {
        return this;
    }

    public abstract void load(String var1, String var2);

    public Object execute(ScriptExecuteWrap wrap) throws Exception {
        try {
            return this.executeScript(wrap);
        }
        catch (Exception e) {
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof LiteFlowException) {
                throw (LiteFlowException)e.getCause();
            }
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public abstract Object executeScript(ScriptExecuteWrap var1) throws Exception;

    public abstract void cleanCache();

    public abstract ScriptTypeEnum scriptType();

    public void bindParam(ScriptExecuteWrap wrap, BiConsumer<String, Object> putConsumer, BiConsumer<String, Object> putIfAbsentConsumer) {
        DataBus.getContextBeanList(wrap.getSlotIndex()).forEach(o -> {
            ContextBean contextBean = AnnoUtil.getAnnotation(o.getClass(), ContextBean.class);
            String key = contextBean != null && contextBean.value().trim().length() > 0 ? contextBean.value() : StrUtil.lowerFirst((CharSequence)o.getClass().getSimpleName());
            putConsumer.accept(key, o);
        });
        Map metaMap = BeanUtil.beanToMap((Object)wrap, (String[])new String[0]);
        Slot slot = DataBus.getSlot(wrap.getSlotIndex());
        metaMap.put("requestData", slot.getRequestData());
        Object subRequestData = slot.getChainReqData(wrap.getCurrChainId());
        if (ObjectUtil.isNotNull(subRequestData)) {
            metaMap.put("subRequestData", subRequestData);
        }
        putConsumer.accept("_meta", metaMap);
        ScriptBeanManager.getScriptBeanMap().forEach(putIfAbsentConsumer);
    }
}

