/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.recycler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import java.util.Locale;

public class ScrollPageHelper
extends PagerSnapHelper {
    private OrientationHelper mHorizontalHelper;
    private OrientationHelper mVerticalHelper;
    private int gravity;
    private boolean snapLastItem;
    private boolean isRtlHorizontal;

    public ScrollPageHelper(int gravity, boolean enableSnapLast) {
        this.snapLastItem = enableSnapLast;
        this.gravity = gravity;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null && !(recyclerView.getLayoutManager() instanceof LinearLayoutManager)) {
            throw new IllegalStateException("ScrollPageHelper needs a RecyclerView with a LinearLayoutManager");
        }
        if (recyclerView != null) {
            recyclerView.setOnFlingListener(null);
            if (this.gravity == 0x800003 || this.gravity == 0x800005) {
                this.isRtlHorizontal = this.isRtl();
            }
        }
        super.attachToRecyclerView(recyclerView);
    }

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.gravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager), false)) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.gravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager), false)) : 0;
        return out;
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        View snapView = null;
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.gravity) {
                case 0x800003: {
                    snapView = this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 0x800005: {
                    snapView = this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                    break;
                }
                case 48: {
                    snapView = this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                    break;
                }
                case 80: {
                    snapView = this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                    break;
                }
            }
        }
        return snapView;
    }

    private boolean isRtl() {
        return TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }

    @NonNull
    private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    @NonNull
    private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private int distanceToStart(View targetView, @NonNull OrientationHelper helper, boolean fromEnd) {
        if (this.isRtlHorizontal && !fromEnd) {
            return this.distanceToEnd(targetView, helper, true);
        }
        return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
    }

    private int distanceToEnd(View targetView, @NonNull OrientationHelper helper, boolean fromStart) {
        if (this.isRtlHorizontal && !fromStart) {
            return this.distanceToStart(targetView, helper, true);
        }
        return helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
    }

    @Nullable
    private View findStartView(RecyclerView.LayoutManager layoutManager, @NonNull OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean endOfList;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            boolean reverseLayout = linearLayoutManager.getReverseLayout();
            int firstChild = reverseLayout ? linearLayoutManager.findLastVisibleItemPosition() : linearLayoutManager.findFirstVisibleItemPosition();
            int offset = 1;
            if (layoutManager instanceof GridLayoutManager) {
                offset += ((GridLayoutManager)layoutManager).getSpanCount() - 1;
            }
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            float visibleWidth = this.isRtlHorizontal ? (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child) : (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child);
            if (!reverseLayout) {
                endOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            } else {
                boolean bl = endOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            }
            if (visibleWidth > 0.5f && !endOfList) {
                return child;
            }
            if (this.snapLastItem && endOfList) {
                return child;
            }
            if (endOfList) {
                return null;
            }
            return reverseLayout ? layoutManager.findViewByPosition(firstChild - offset) : layoutManager.findViewByPosition(firstChild + offset);
        }
        return null;
    }

    @Nullable
    private View findEndView(RecyclerView.LayoutManager layoutManager, @NonNull OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean startOfList;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            boolean reverseLayout = linearLayoutManager.getReverseLayout();
            int lastChild = reverseLayout ? linearLayoutManager.findFirstVisibleItemPosition() : linearLayoutManager.findLastVisibleItemPosition();
            int offset = 1;
            if (layoutManager instanceof GridLayoutManager) {
                offset += ((GridLayoutManager)layoutManager).getSpanCount() - 1;
            }
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            float visibleWidth = this.isRtlHorizontal ? (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child) : (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child);
            if (!reverseLayout) {
                startOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            } else {
                boolean bl = startOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            }
            if (visibleWidth > 0.5f && !startOfList) {
                return child;
            }
            if (this.snapLastItem && startOfList) {
                return child;
            }
            if (startOfList) {
                return null;
            }
            return reverseLayout ? layoutManager.findViewByPosition(lastChild + offset) : layoutManager.findViewByPosition(lastChild - offset);
        }
        return null;
    }
}

