/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.pager;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.lang.reflect.Field;

public class VerticalViewPager
extends ViewPager {
    private boolean isVertical = false;
    private long mRecentTouchTime;

    public VerticalViewPager(@NonNull Context context) {
        super(context);
    }

    public VerticalViewPager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    private void init() {
        this.setPageTransformer(true, new HorizontalVerticalPageTransformer());
        this.setOverScrollMode(2);
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean vertical) {
        this.isVertical = vertical;
        this.init();
    }

    private MotionEvent swapXY(MotionEvent event) {
        float width = this.getWidth();
        float height = this.getHeight();
        float swappedX = event.getY() / height * width;
        float swappedY = event.getX() / width * height;
        event.setLocation(swappedX, swappedY);
        return event;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        if (this.getCurrentItem() == 0 && this.getChildCount() == 0) {
            return false;
        }
        if (this.isVertical) {
            boolean intercepted = super.onInterceptTouchEvent(this.swapXY(ev));
            this.swapXY(ev);
            return intercepted;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.getCurrentItem() == 0 && this.getChildCount() == 0) {
            return false;
        }
        if (this.isVertical) {
            return super.onTouchEvent(this.swapXY(ev));
        }
        return super.onTouchEvent(ev);
    }

    @TargetApi(value=19)
    public void setAnimationDuration(final int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Interpolator interpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            };
            Scroller mScroller = new Scroller(this.getContext(), interpolator){
                final int time = 2000;
                {
                    super(x0, x1);
                    this.time = 2000;
                }

                public void startScroll(int x, int y, int dx, int dy, int duration) {
                    duration = System.currentTimeMillis() - VerticalViewPager.this.mRecentTouchTime > 2000L ? during : (duration /= 2);
                    super.startScroll(x, y, dx, dy, duration);
                }

                public void startScroll(int x, int y, int dx, int dy) {
                    super.startScroll(x, y, dx, dy, during);
                }
            };
            mField.set((Object)this, mScroller);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void setScrollFling(int flingDistance, int minimumVelocity) {
        try {
            Field mFlingDistance = ViewPager.class.getDeclaredField("mFlingDistance");
            mFlingDistance.setAccessible(true);
            Object o = mFlingDistance.get((Object)this);
            Log.d((String)"setScrollFling", (String)o.toString());
            mFlingDistance.set((Object)this, flingDistance);
            Field mMinimumVelocity = ViewPager.class.getDeclaredField("mMinimumVelocity");
            mMinimumVelocity.setAccessible(true);
            Object o1 = mMinimumVelocity.get((Object)this);
            Log.d((String)"setScrollFling", (String)o1.toString());
            mMinimumVelocity.set((Object)this, minimumVelocity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    private class HorizontalVerticalPageTransformer
    implements ViewPager.PageTransformer {
        private static final float MIN_SCALE = 0.25f;

        private HorizontalVerticalPageTransformer() {
        }

        public void transformPage(@NonNull View page, float position) {
            if (VerticalViewPager.this.isVertical) {
                if (position < -1.0f) {
                    page.setAlpha(0.0f);
                } else if (position <= 1.0f) {
                    page.setAlpha(1.0f);
                    float xPosition = (float)page.getWidth() * -position;
                    page.setTranslationX(xPosition);
                    float yPosition = position * (float)page.getHeight();
                    page.setTranslationY(yPosition);
                } else {
                    page.setAlpha(0.0f);
                }
            } else {
                int pageWidth = page.getWidth();
                if (position < -1.0f) {
                    page.setAlpha(0.0f);
                } else if (position <= 0.0f) {
                    page.setAlpha(1.0f);
                    page.setTranslationX(0.0f);
                    page.setScaleX(1.0f);
                    page.setScaleY(1.0f);
                } else if (position <= 1.0f) {
                    page.setAlpha(1.0f - position);
                    page.setTranslationX((float)pageWidth * -position);
                    page.setTranslationY(0.0f);
                    float scaleFactor = 0.25f + 0.75f * (1.0f - Math.abs(position));
                    page.setScaleX(scaleFactor);
                    page.setScaleY(scaleFactor);
                } else {
                    page.setAlpha(0.0f);
                }
            }
        }
    }
}

