/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.pager;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.yc.pagerlib.pager.FixedSpeedScroller;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class DirectionalViewPager
extends ViewPager
implements ViewPager.OnPageChangeListener {
    private static final String TAG = "DirectionalViewPager";
    private static final boolean DEBUG = true;
    private static final boolean USE_CACHE = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private PagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private Scroller mScroller;
    private PagerObserver mObserver;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private boolean mScrolling;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mInitialMotion;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mOrientation = 0;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int mScrollState = 0;
    private long mRecentTouchTime;

    public DirectionalViewPager(Context context) {
        super(context);
        this.initViewPager();
    }

    public DirectionalViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewPager();
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.mScroller = new Scroller(this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    @TargetApi(value=19)
    public void setAnimationDuration(int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Interpolator interpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            };
            FixedSpeedScroller scroller = new FixedSpeedScroller(this.getContext(), interpolator, this.mRecentTouchTime);
            scroller.setDuration(during);
            mField.set((Object)this, (Object)scroller);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAdapter != null) {
            this.populate();
        }
    }

    public void onPageScrolled(int i, float v, int i1) {
        super.onPageScrolled(i, v, i1);
    }

    public void onPageSelected(int i) {
    }

    public void onPageScrollStateChanged(int i) {
    }

    private void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(newState);
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mObserver);
            this.mPopulatePending = false;
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else {
                this.populate();
            }
        }
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, true, false);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!always && this.mCurItem == item && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (item < 0) {
            item = 0;
        } else if (item >= this.mAdapter.getCount()) {
            item = this.mAdapter.getCount() - 1;
        }
        if (item > this.mCurItem + 1 || item < this.mCurItem - 1) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean dispatchSelected = this.mCurItem != item;
        this.mCurItem = item;
        this.populate();
        if (smoothScroll) {
            if (this.mOrientation == 0) {
                this.smoothScrollTo(this.getWidth() * item, 0);
            } else {
                this.smoothScrollTo(0, this.getHeight() * item);
            }
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
        } else {
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
            this.completeScroll();
            if (this.mOrientation == 0) {
                this.scrollTo(this.getWidth() * item, 0);
            } else {
                this.scrollTo(0, this.getHeight() * item);
            }
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    void smoothScrollTo(int x, int y) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll();
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.mScrolling = true;
        this.setScrollState(2);
        this.mScroller.startScroll(sx, sy, dx, dy);
        this.invalidate();
    }

    void addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem((ViewGroup)this, position);
        if (index < 0) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
    }

    void dataSetChanged() {
        boolean needPopulate = this.mItems.isEmpty() && this.mAdapter.getCount() > 0;
        int newCurrItem = -1;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                this.mAdapter.destroyItem((ViewGroup)this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurItem != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurItem, this.mAdapter.getCount() - 1));
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurItem) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        if (newCurrItem >= 0) {
            this.setCurrentItemInternal(newCurrItem, false, true);
            needPopulate = true;
        }
        if (needPopulate) {
            this.populate();
            this.requestLayout();
        }
    }

    void populate() {
        int i;
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            Log.i((String)TAG, (String)"populate is pending, skipping for now...");
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate((ViewGroup)this);
        int startPos = this.mCurItem > 0 ? this.mCurItem - 1 : this.mCurItem;
        int count = this.mAdapter.getCount();
        int endPos = this.mCurItem < count - 1 ? this.mCurItem + 1 : count - 1;
        Log.v((String)TAG, (String)("populating: startPos=" + startPos + " endPos=" + endPos));
        int lastPos = -1;
        for (i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!(ii.position >= startPos && ii.position <= endPos || ii.scrolling)) {
                Log.i((String)TAG, (String)("removing: " + ii.position + " @ " + i));
                this.mItems.remove(i);
                --i;
                this.mAdapter.destroyItem((ViewGroup)this, ii.position, ii.object);
            } else if (lastPos < endPos && ii.position > startPos) {
                if (++lastPos < startPos) {
                    lastPos = startPos;
                }
                while (lastPos <= endPos && lastPos < ii.position) {
                    Log.i((String)TAG, (String)("inserting: " + lastPos + " @ " + i));
                    this.addNewItem(lastPos, i);
                    ++lastPos;
                    ++i;
                }
            }
            lastPos = ii.position;
        }
        int n = lastPos = this.mItems.size() > 0 ? this.mItems.get((int)(this.mItems.size() - 1)).position : -1;
        if (lastPos < endPos) {
            int n2 = lastPos = ++lastPos > startPos ? lastPos : startPos;
            while (lastPos <= endPos) {
                Log.i((String)TAG, (String)("appending: " + lastPos));
                this.addNewItem(lastPos, -1);
                ++lastPos;
            }
        }
        Log.i((String)TAG, (String)"Current page list:");
        for (i = 0; i < this.mItems.size(); ++i) {
            Log.i((String)TAG, (String)("#" + i + ": page " + this.mItems.get((int)i).position));
        }
        this.mAdapter.finishUpdate((ViewGroup)this);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.mCurItem;
        ss.adapterState = this.mAdapter.saveState();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(ss.adapterState, ss.loader);
            this.setCurrentItemInternal(ss.position, false, true);
        } else {
            this.mRestoredCurItem = ss.position;
            this.mRestoredAdapterState = ss.adapterState;
            this.mRestoredClassLoader = ss.loader;
        }
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Only HORIZONTAL and VERTICAL are valid orientations.");
            }
        }
        if (orientation == this.mOrientation) {
            return;
        }
        this.completeScroll();
        this.mInitialMotion = 0.0f;
        this.mLastMotionX = 0.0f;
        this.mLastMotionY = 0.0f;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.mOrientation = orientation;
        if (this.mOrientation == 0) {
            this.scrollTo(this.mCurItem * this.getWidth(), 0);
        } else {
            this.scrollTo(0, this.mCurItem * this.getHeight());
        }
        this.requestLayout();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.mInLayout) {
            this.addViewInLayout(child, index, params);
            child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        } else {
            super.addView(child, index, params);
        }
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(DirectionalViewPager.getDefaultSize((int)0, (int)widthMeasureSpec), DirectionalViewPager.getDefaultSize((int)0, (int)heightMeasureSpec));
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            Log.v((String)TAG, (String)("Measuring #" + i + " " + child + ": " + this.mChildWidthMeasureSpec + " x " + this.mChildHeightMeasureSpec));
            child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mOrientation == 0) {
            int scrollPos = this.mCurItem * w;
            if (scrollPos != this.getScrollX()) {
                this.completeScroll();
                this.scrollTo(scrollPos, this.getScrollY());
            }
        } else {
            int scrollPos = this.mCurItem * h;
            if (scrollPos != this.getScrollY()) {
                this.completeScroll();
                this.scrollTo(this.getScrollX(), scrollPos);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int count = this.getChildCount();
        int size = this.mOrientation == 0 ? r - l : b - t;
        for (int i = 0; i < count; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (ii = this.infoForChild(child)) == null) continue;
            int off = size * ii.position;
            int childLeft = this.getPaddingLeft();
            int childTop = this.getPaddingTop();
            if (this.mOrientation == 0) {
                childLeft += off;
            } else {
                childTop += off;
            }
            Log.v((String)TAG, (String)("Positioning #" + i + " " + child + " f=" + ii.object + ":" + childLeft + "," + childTop + " " + child.getMeasuredWidth() + "x" + child.getMeasuredHeight()));
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
    }

    public void computeScroll() {
        Log.i((String)TAG, (String)("computeScroll: finished=" + this.mScroller.isFinished()));
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            Log.i((String)TAG, (String)"computeScroll: still scrolling");
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            if (this.mOnPageChangeListener != null) {
                int value;
                int size;
                if (this.mOrientation == 0) {
                    size = this.getWidth();
                    value = x;
                } else {
                    size = this.getHeight();
                    value = y;
                }
                int position = value / size;
                int offsetPixels = value % size;
                float offset = (float)offsetPixels / (float)size;
                this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
            }
            this.invalidate();
            return;
        }
        this.completeScroll();
    }

    private void completeScroll() {
        boolean needPopulate = this.mScrolling;
        if (needPopulate) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            this.setScrollState(0);
        }
        this.mPopulatePending = false;
        this.mScrolling = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            this.populate();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            Log.v((String)TAG, (String)"Intercept done!");
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                Log.v((String)TAG, (String)"Intercept returning true!");
                return true;
            }
            if (this.mIsUnableToDrag) {
                Log.v((String)TAG, (String)"Intercept returning false!");
                return false;
            }
        }
        switch (action) {
            case 2: {
                float secondaryDiff;
                float primaryDiff;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float xDiff = Math.abs(x - this.mLastMotionX);
                float yDiff = Math.abs(y - this.mLastMotionY);
                if (this.mOrientation == 0) {
                    primaryDiff = xDiff;
                    secondaryDiff = yDiff;
                } else {
                    primaryDiff = yDiff;
                    secondaryDiff = xDiff;
                }
                Log.v((String)TAG, (String)("Moved x to " + x + "," + y + " diff=" + xDiff + "," + yDiff));
                if (primaryDiff > (float)this.mTouchSlop && primaryDiff > secondaryDiff) {
                    Log.v((String)TAG, (String)"Starting drag!");
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    if (this.mOrientation == 0) {
                        this.mLastMotionX = x;
                    } else {
                        this.mLastMotionY = y;
                    }
                    this.setScrollingCacheEnabled(true);
                    break;
                }
                if (!(secondaryDiff > (float)this.mTouchSlop)) break;
                Log.v((String)TAG, (String)"Starting unable to drag!");
                this.mIsUnableToDrag = true;
                break;
            }
            case 0: {
                if (this.mOrientation == 0) {
                    this.mLastMotionX = this.mInitialMotion = ev.getX();
                    this.mLastMotionY = ev.getY();
                } else {
                    this.mLastMotionX = ev.getX();
                    this.mLastMotionY = this.mInitialMotion = ev.getY();
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                if (this.mScrollState == 2) {
                    this.mIsBeingDragged = true;
                    this.mIsUnableToDrag = false;
                    this.setScrollState(1);
                } else {
                    this.completeScroll();
                    this.mIsBeingDragged = false;
                    this.mIsUnableToDrag = false;
                }
                Log.v((String)TAG, (String)("Down at " + this.mLastMotionX + "," + this.mLastMotionY + " mIsBeingDragged=" + this.mIsBeingDragged + "mIsUnableToDrag=" + this.mIsUnableToDrag));
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.completeScroll();
                if (this.mOrientation == 0) {
                    this.mLastMotionX = this.mInitialMotion = ev.getX();
                } else {
                    this.mLastMotionY = this.mInitialMotion = ev.getY();
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 2: {
                float scroll;
                int size;
                float y;
                float x;
                if (!this.mIsBeingDragged) {
                    float secondaryDiff;
                    float primaryDiff;
                    int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                    x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                    y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (this.mOrientation == 0) {
                        primaryDiff = xDiff;
                        secondaryDiff = yDiff;
                    } else {
                        primaryDiff = yDiff;
                        secondaryDiff = xDiff;
                    }
                    Log.v((String)TAG, (String)("Moved x to " + x + "," + y + " diff=" + xDiff + "," + yDiff));
                    if (primaryDiff > (float)this.mTouchSlop && primaryDiff > secondaryDiff) {
                        Log.v((String)TAG, (String)"Starting drag!");
                        this.mIsBeingDragged = true;
                        if (this.mOrientation == 0) {
                            this.mLastMotionX = x;
                        } else {
                            this.mLastMotionY = y;
                        }
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                y = MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                if (this.mOrientation == 0) {
                    size = this.getWidth();
                    scroll = (float)this.getScrollX() + (this.mLastMotionX - x);
                    this.mLastMotionX = x;
                } else {
                    size = this.getHeight();
                    scroll = (float)this.getScrollY() + (this.mLastMotionY - y);
                    this.mLastMotionY = y;
                }
                float lowerBound = Math.max(0, (this.mCurItem - 1) * size);
                float upperBound = Math.min(this.mCurItem + 1, this.mAdapter.getCount() - 1) * size;
                if (scroll < lowerBound) {
                    scroll = lowerBound;
                } else if (scroll > upperBound) {
                    scroll = upperBound;
                }
                if (this.mOrientation == 0) {
                    this.mLastMotionX += scroll - (float)((int)scroll);
                    this.scrollTo((int)scroll, this.getScrollY());
                } else {
                    this.mLastMotionY += scroll - (float)((int)scroll);
                    this.scrollTo(this.getScrollX(), (int)scroll);
                }
                if (this.mOnPageChangeListener == null) break;
                int position = (int)scroll / size;
                int positionOffsetPixels = (int)scroll % size;
                float positionOffset = (float)positionOffsetPixels / (float)size;
                this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                break;
            }
            case 1: {
                int sizeOverThree;
                float lastMotion;
                int initialVelocity;
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                if (this.mOrientation == 0) {
                    initialVelocity = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    lastMotion = this.mLastMotionX;
                    sizeOverThree = this.getWidth() / 3;
                } else {
                    initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    lastMotion = this.mLastMotionY;
                    sizeOverThree = this.getHeight() / 3;
                }
                this.mPopulatePending = true;
                if (Math.abs(initialVelocity) > this.mMinimumVelocity || Math.abs(this.mInitialMotion - lastMotion) >= (float)sizeOverThree) {
                    if (lastMotion > this.mInitialMotion) {
                        this.setCurrentItemInternal(this.mCurItem - 1, true, true);
                    } else {
                        this.setCurrentItemInternal(this.mCurItem + 1, true, true);
                    }
                } else {
                    this.setCurrentItemInternal(this.mCurItem, true, true);
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.setCurrentItemInternal(this.mCurItem, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (this.mOrientation == 0) {
                    this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                } else {
                    this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)index);
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (this.mOrientation == 0) {
                    this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                    break;
                }
                this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)index);
                break;
            }
        }
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex;
            int n = newPointerIndex = pointerIndex == 0 ? 1 : 0;
            if (this.mOrientation == 0) {
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)newPointerIndex);
            } else {
                this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)newPointerIndex);
            }
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled != enabled) {
            this.mScrollingCacheEnabled = enabled;
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            DirectionalViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            DirectionalViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int position;
        Parcelable adapterState;
        ClassLoader loader;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeParcelable(this.adapterState, flags);
        }

        @NonNull
        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in);
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = in.readInt();
            this.adapterState = in.readParcelable(loader);
            this.loader = loader;
        }
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;

        ItemInfo() {
        }
    }
}

