/*
 * Decompiled with CFR 0.152.
 */
package com.yc.pagerlib.recycler;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.yc.pagerlib.inter.OnPagerListener;
import com.yc.pagerlib.recycler.ScrollPageHelper;

public class PagerLayoutManager
extends LinearLayoutManager {
    private RecyclerView mRecyclerView;
    private ScrollPageHelper mPagerSnapHelper;
    private OnPagerListener mOnViewPagerListener;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private int mOrientation;
    private int mDrift;
    private RecyclerView.OnChildAttachStateChangeListener mChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(@NonNull View view) {
            if (PagerLayoutManager.this.mOnViewPagerListener != null && PagerLayoutManager.this.getChildCount() == 1) {
                PagerLayoutManager.this.mOnViewPagerListener.onInitComplete();
            }
        }

        public void onChildViewDetachedFromWindow(@NonNull View view) {
            if (PagerLayoutManager.this.mDrift >= 0) {
                if (PagerLayoutManager.this.mOnViewPagerListener != null) {
                    PagerLayoutManager.this.mOnViewPagerListener.onPageRelease(true, PagerLayoutManager.this.getPosition(view));
                }
            } else if (PagerLayoutManager.this.mOnViewPagerListener != null) {
                PagerLayoutManager.this.mOnViewPagerListener.onPageRelease(false, PagerLayoutManager.this.getPosition(view));
            }
        }
    };

    public PagerLayoutManager(Context context, int orientation) {
        super(context, orientation, false);
        this.mOrientation = orientation;
        this.init();
    }

    public PagerLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.mOrientation = orientation;
        this.init();
    }

    private void init() {
        switch (this.mOrientation) {
            case 0: {
                this.mPagerSnapHelper = new ScrollPageHelper(0x800003, false);
                break;
            }
            case 1: {
                this.mPagerSnapHelper = new ScrollPageHelper(48, false);
                break;
            }
            default: {
                this.mPagerSnapHelper = new ScrollPageHelper(48, false);
            }
        }
    }

    public void onAttachedToWindow(RecyclerView recyclerView) {
        if (recyclerView == null) {
            throw new IllegalArgumentException("The attach RecycleView must not null!!");
        }
        super.onAttachedToWindow(recyclerView);
        this.mRecyclerView = recyclerView;
        if (this.mPagerSnapHelper == null) {
            this.init();
        }
        this.mPagerSnapHelper.attachToRecyclerView(this.mRecyclerView);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mChildAttachStateChangeListener);
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeOnChildAttachStateChangeListener(this.mChildAttachStateChangeListener);
        }
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
    }

    public void onScrollStateChanged(int state) {
        switch (state) {
            case 0: {
                View viewIdle = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
                int positionIdle = 0;
                if (viewIdle != null) {
                    positionIdle = this.getPosition(viewIdle);
                }
                int childCount = this.getChildCount();
                if (this.mOnViewPagerListener == null || childCount != 1) break;
                this.mOnViewPagerListener.onPageSelected(positionIdle, positionIdle == childCount - 1);
                break;
            }
            case 1: {
                View viewDrag = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
                if (viewDrag == null) break;
                int n = this.getPosition(viewDrag);
                break;
            }
            case 2: {
                View viewSettling = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
                if (viewSettling == null) break;
                int n = this.getPosition(viewSettling);
                break;
            }
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.mDrift = dy;
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dx == 0) {
            return 0;
        }
        this.mDrift = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    public void setOnViewPagerListener(OnPagerListener listener) {
        this.mOnViewPagerListener = listener;
    }
}

